<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2023 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Utilities\ArrayHelper;

class plgUserSpbookingprofile extends CMSPlugin{
	
	protected $autoloadLanguage = true;

	public function __construct(& $subject, $config) {
		parent::__construct($subject, $config);
	}
	
	
	function onContentPrepareData($context, $data){
		// Check we are manipulating a valid form.
		if (!in_array($context, array('com_users.profile', 'com_users.user', 'com_users.registration', 'com_admin.profile')))
		{
			return true;
		}
		

		if (is_object($data))
		{
			$userId = isset($data->id) ? $data->id : 0;

			if (!isset($data->spbookingprofile) && $userId > 0)
			{
				// Load the profile data from the database.
				$db = Factory::getDbo();
				$db->setQuery(
					'SELECT profile_key, profile_value FROM `#__user_profiles`'
						. ' WHERE `user_id` = ' . (int) $userId . " AND `profile_key` LIKE 'spbookingprofile.%'"
						. ' ORDER BY ordering'
				);

				try
				{
					$results = $db->loadRowList();
				}
				catch (RuntimeException $e)
				{
					Factory::getApplication()->enqueueMessage($e->getMessage());
					return false;
				}

				// Merge the profile data.
				$data->spbookingprofile = array();

				foreach ($results as $v)
				{
					$k = str_replace('spbookingprofile.', '', $v[0]);
					$data->spbookingprofile[$k] = json_decode($v[1], true);

					if ($data->spbookingprofile[$k] === null)
					{
						$data->spbookingprofile[$k] = $v[1];
					}
				}
			}
		}

		return true;
	}
 


	/**
	 * @param	JForm	The form to be altered.
	 * @param	array	The associated data for the form.
	 * @return	boolean
	 * @since	1.6
	 */
	function onContentPrepareForm($form, $data){

		$name = $form->getName();

		if (!in_array($name, array('com_admin.profile', 'com_users.user', 'com_users.profile', 'com_users.registration')))
		{
			return true;
		}

		// Add the registration fields to the form.
		Form::addFormPath(__DIR__ . '/profiles');
		$form->loadFile('profile');

		$fields = array(
			'phone',
			'address'
		);

		// Change fields description when displayed in frontend or backend profile editing
		$app = Factory::getApplication();

		if ($app->isClient('site') || $name === 'com_users.user' || $name === 'com_admin.profile')
		{
			$form->setFieldAttribute('phone', 'hint', 'PLG_USER_SPBOOKING_PHONE_FIELD', 'spbookingprofile');
			$form->setFieldAttribute('address', 'hint', 'PLG_USER_SPBOOKING_ADDRESS_FIELD', 'spbookingprofile');
		}

		foreach ($fields as $field)
		{
			// Case using the users manager in admin
			if ($name === 'com_users.user')
			{
				// Toggle whether the field is required.
				if ($this->params->get('profile-require_' . $field, 1) > 0)
				{
					$form->setFieldAttribute($field, 'required', ($this->params->get('profile-require_' . $field) == 2) ? 'required' : '', 'spbookingprofile');
				}
				// Remove the field if it is disabled in registration and profile
				elseif ($this->params->get('register-require_' . $field, 1) == 0
					&& $this->params->get('profile-require_' . $field, 1) == 0)
				{
					$form->removeField($field, 'spbookingprofile');
				}
			}
			// Case registration
			elseif ($name === 'com_users.registration')
			{
				// Toggle whether the field is required.
				if ($this->params->get('register-require_' . $field, 1) > 0)
				{
					$form->setFieldAttribute($field, 'required', ($this->params->get('register-require_' . $field) == 2) ? 'required' : '', 'spbookingprofile');
				}
				else
				{
					$form->removeField($field, 'spbookingprofile');
				}
			}
			// Case profile in site or admin
			elseif ($name === 'com_users.profile' || $name === 'com_admin.profile')
			{
				// Toggle whether the field is required.
				if ($this->params->get('profile-require_' . $field, 1) > 0)
				{
					$form->setFieldAttribute($field, 'required', ($this->params->get('profile-require_' . $field) == 2) ? 'required' : '', 'spbookingprofile');
				}
				else
				{
					$form->removeField($field, 'spbookingprofile');
				}
			}
		}

		// Drop the profile form entirely if there aren't any fields to display.
		$remainingfields = $form->getGroup('spbookingprofile');

		if (!count($remainingfields))
		{
			$form->removeGroup('spbookingprofile');
		}

		return true;		
	}

	function onUserBeforeSave($user, $isnew, $new){
		return true;
	}

 
	function onUserAfterSave($data, $isNew, $result, $error){

		$userId = ArrayHelper::getValue($data, 'id', 0, 'int');

		if ($userId && $result && isset($data['spbookingprofile']) && count($data['spbookingprofile']))
		{
			try
			{
				$db = Factory::getDbo();

				// Sanitize the date
			
				$keys = array_keys($data['spbookingprofile']);

				foreach ($keys as &$key)
				{
					$key = 'spbookingprofile.' . $key;
					$key = $db->quote($key);
				}

				$query = $db->getQuery(true)
					->delete($db->quoteName('#__user_profiles'))
					->where($db->quoteName('user_id') . ' = ' . (int) $userId)
					->where($db->quoteName('profile_key') . ' IN (' . implode(',', $keys) . ')');
				$db->setQuery($query);
				$db->execute();

				$query = $db->getQuery(true)
					->select($db->quoteName('ordering'))
					->from($db->quoteName('#__user_profiles'))
					->where($db->quoteName('user_id') . ' = ' . (int) $userId);
				$db->setQuery($query);
				$usedOrdering = $db->loadColumn();

				$tuples = array();
				$order = 1;

				foreach ($data['spbookingprofile'] as $k => $v)
				{
					while (in_array($order, $usedOrdering))
					{
						$order++;
					}

					$tuples[] = '(' . $userId . ', ' . $db->quote('spbookingprofile.' . $k) . ', ' . $db->quote(json_encode($v)) . ', ' . ($order++) . ')';
				}

				$db->setQuery('INSERT INTO `#__user_profiles` VALUES ' . implode(', ', $tuples));
				$db->execute();
			}
			catch (RuntimeException $e)
			{
				Factory::getApplication()->enqueueMessage($e->getMessage());
				return false;
			}
		}

		return true;
	}
 
	
	function onUserAfterDelete($user, $success, $msg){
		if (!$success) {
			return false;
		}
 
		$userId	= ArrayHelper::getValue($user, 'id', 0, 'int');
 
		if ($userId)
		{
			try
			{
				$db = Factory::getDbo();
				$db->setQuery(
					'DELETE FROM `#__user_profiles` WHERE `user_id` = '.$userId .
					" AND profile_key LIKE 'spbookingprofile.%'"
				);
 
				if (!$db->query()) {
					throw new Exception($db->getErrorMsg());
				}
			}
			catch (Exception $e)
			{
				Factory::getApplication()->enqueueMessage($e->getMessage());
				return false;
			}
		}
 
		return true;
	}
 
 
 }