<?php
/**
 * @package mod_spbooking_transports
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

$user = Factory::getUser();

?>

<div id="spbooking-transports<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
  <div class="spbooking-transports-module">
	<div class="spbooking-row">
		<?php if (!empty($transports))
		{
			?>
			<?php foreach ($transports as $transport)
			{
				?>
				<div class="spbooking-col-md-6 spbooking-col-lg-4">
					<div class="spbooking-transport" style="<?php echo !empty($transport->image) ? 'background-image:url(' . $transport->thumb_large . ');' : 'background: rgba(0,0,0,0.2);'; ?>">
					<a href="<?php echo $transport->url;?>" class="full-link"></a>
					<div class="spbooking-transport-discount">
						<span><?php echo Text::_('COM_SPBOOKING_COMMON_SAVE'); ?></span>
						<span class="only-price"><?php echo $transport->save_money; ?></span>
					</div>
					<div class="spbooking-transport-info">
						<?php if (!empty($transport->sale_price))
						{
							?>
							<p class="spbooking-transport-discount-price"> <?php echo SpbookingHelper::formatPrice($transport->sale_price, $transport->currency, $transport->currency_type, $transport->currency_position); ?><small><?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?></small></p>
						<?php } ?>
						<p class="spbooking-transport-size"><span class="transport-size"><?php echo $transport->size; ?></span><span class="tranport-persons"><i class="fa fa-user"></i> <?php echo $transport->person_allowed; ?> pax</span></p>
					</div>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
  </div>
</div>
