<?php
/**
 * @package mod_spbooking_transports
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

HTMLHelper::_('jquery.framework');

// Helper & model
$com_helper 		= JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($com_helper))
{
	require_once $com_helper;
}
else
{
	echo '<p class="alert alert-warning">' . Text::_('MOD_SPBOOKING_COMPONENT_NOT_INSTALLED_OR_MISSING_FILE') . '</p>';

	return;
}

JLoader::register('ModSpbookingTransportHelper', __DIR__ . '/helper.php');

// Includes js and css
$doc = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root(true) . '/modules/' . $module->module . '/assets/css/style.css');

$doc->addScript(Uri::root(true) . '/modules/' . $module->module . '/assets/js/script.js');

$transports = ModSpbookingTransportHelper::getTransports($params);
$menuItemId = SpbookingHelper::getItemId('transports');

if (!empty($transports))
{
	foreach ($transports as $transport)
	{
		$transport->price = (int) $transport->price;
		$transport->sale_price = (int) $transport->sale_price;

		if (!empty($transport->sale_price) && $transport->sale_price < $transport->price)
		{
			$transport->save_money = $transport->price - $transport->sale_price;
			$transport->save_money = SpbookingHelper::formatPrice($transport->save_money, $transport->currency, $transport->currency_type, $transport->currency_position);
		}
		else
		{
			$transport->save_money = 0;
		}

		$transport->price = SpbookingHelper::formatPrice($transport->price, $transport->currency, $transport->currency_type, $transport->currency_position);
		$transport->url = Route::_('index.php?option=com_spbooking&view=transport&id=' . $transport->id . ':' . $transport->alias . $menuItemId);
		$transport->thumb_large = SpbookingHelper::getThumbs($transport->image, 'thumbnail_large', '650x410');

		if (!empty($transport->person_allowed))
		{
			if ((int) $transport->person_allowed <= 3 && (int) $transport->person_allowed >= 0)
			{
				$transport->size = 'Small';
			}
			elseif ((int) $transport->person_allowed <= 6 && (int) $transport->person_allowed > 3)
			{
				$transport->size = 'Midium';
			}
			else
			{
				$transport->size = 'Large';
			}
		}
	}
}


$moduleclass_sfx 	= ($params->get('moduleclass_sfx')) ? htmlspecialchars($params->get('moduleclass_sfx')) : '';
require ModuleHelper::getLayoutPath('mod_spbooking_transports', $params->get('layout'));
