<?php
/**
 * @package mod_spbooking_tranpsports
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModSpbookingTransportHelper
{
	public static function getTransports($params)
	{
		$ids = $params->get('deal_transports', array());
		$transports = array();

		if (!empty($ids))
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('*')
				->from($db->quoteName('#__spbooking_transports'))
				->where($db->quoteName('id') . ' IN (' . implode(',', $ids) . ' )')
				->where($db->quoteName('published') . ' = 1');
			$db->setQuery($query);
			$transports = $db->loadObjectList();
		}

		return $transports;
	}
}
