<?php
/**
 * @package mod_spbooking_search
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// no direct access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

$input = Factory::getApplication()->input;
$rooms = $input->get('rooms', 1, 'INT');
$adult = $input->get('adult', 1, 'INT');
$child = $input->get('child', 0, 'INT');

?>

<div class="spbooking spbooking-search <?php echo $params->get('moduleclass_sfx') . ' ' . $module->id; ?>" id="mod-spbooking-search-<?php echo $module->id;?>">
    <h3 class="title"><?php echo Text::_('MOD_SPBOOKING_SEARCH_FIND_YOUR_ADVENTURE'); ?></h3>
    <div class="spbooking-row">
        <div class="spbooking-col-12">
            <div class="btn-group" role="group" aria-label="Basic example">
                <button type="button" class="btn btn-secondary search-bar-header is-uppercase active" data-view="accomodations"><?php echo Text::_('MOD_SPBOOKING_SEARCH_HOTEL'); ?></button>
                <button type="button" class="btn btn-secondary search-bar-header is-uppercase" data-view="packages"><?php echo Text::_('MOD_SPBOOKING_SEARCH_PACKAGE'); ?></button>
                <button type="button" class="btn btn-secondary search-bar-header is-uppercase" data-view="daily_tour"><?php echo Text::_('MOD_SPBOOKING_SEARCH_DAILY_TOUR'); ?></button>
                <button type="button" class="btn btn-secondary search-bar-header is-uppercase" data-view="transports"><?php echo Text::_('MOD_SPBOOKING_SEARCH_TRANSPORT'); ?></button>
            </div>
        </div>
    </div>

    <!-- accomodation search form -->
    <form action="#" id="mod-spbooking-search-accomodation">
        <div class="spbooking-row mt-10">
            <!-- keyword search input field  -->
            <div class="spbooking-col-12 spbooking-col-lg-5">
                <div class="form-groups">
                    <!-- location search  -->
                    <div class="topbar-search-wrapper">
                        <input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>">
                        <ul class="topbar-search-result"></ul>
                        <div class="topbar-search-loading">
                            <span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
                        </div>
                    </div>
                    <input type="hidden" name="accomodation" class="topbar-accomodation-input" >
                    <input type="hidden" name="city" class="topbar-city-input">
                    <input type="hidden" name="country" class="topbar-country-input">
                </div>
            </div>

            <!-- checkin checkout ranger column -->
            <div class="spbooking-col-12 spbooking-col-md-6 spbooking-col-lg-4">
                <div class="topbar-range">
                    <input type="text" class="form-control topbar-checkin-out-range" placeholder="<?php echo Text::_('MOD_SPBOOKING_SEARCH_CHECKIN_OUT'); ?>">
                    <div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
                    <input type="hidden" class="topbar-search-checkin" name="checkin" >
                    <input type="hidden" class="topbar-search-checkout" name="checkout">
                </div>
            </div>


            <!-- person room info dropdown -->
            <div class="spbooking-col-12 spbooking-col-md-6 spbooking-col-lg-3">
                <div class="form-groups">
                    <div class="topbar-search-person-wrapper">
                        <div class="toggle-person-info"><?php echo $rooms . ' ' . SpbookingHelper::pluralize($rooms, 'MOD_SPBOOKING_SEARCH_ROOM', 'MOD_SPBOOKING_SEARCH_ROOMS') . ', ' . $adult . ' ' . SpbookingHelper::pluralize($adult, 'MOD_SPBOOKING_SEARCH_ADULT', 'MOD_SPBOOKING_SEARCH_ADULTS') . ', ' . $child . ' ' . SpbookingHelper::pluralize($child, 'MOD_SPBOOKING_SEARCH_CHILD', 'MOD_SPBOOKING_SEARCH_CHILDREN'); ?></div>
                        <div class="person-caret"><span class="fa fa-caret-down"></span></div>
                        <div class="person-container">
                            <div class="topbar-btn-group">
                                <div class="person-info-left">
                                    <span class="person-room-title"><?php echo Text::_('MOD_SPBOOKING_SEARCH_ROOMS'); ?></span>
                                </div>
                                <div class="person-info-right">
                                    <button class="btn btn-danger btn-xs btn-minus" ><span class="fa fa-minus"></span></button>
                                    <span class="value value-holder is-room" data-min="1" data-val='<?php echo $rooms; ?>' data-singular="<?php echo Text::_('MOD_SPBOOKING_SEARCH_ROOM'); ?>" data-plural="<?php echo Text::_('MOD_SPBOOKING_SEARCH_ROOMS'); ?>" data-info="<?php echo $rooms . ' ' . SpbookingHelper::pluralize($rooms, 'MOD_SPBOOKING_SEARCH_ROOM', 'MOD_SPBOOKING_SEARCH_ROOMS'); ?>"><?php echo $rooms; ?></span>
                                    <button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
                                    <input type="hidden" name="rooms" class="topbar-search-rooms" value="<?php echo $rooms; ?>">
                                </div>
                            </div>
                            <div class="topbar-btn-group">
                                <div class="person-info-left">
                                    <span class="person-room-title"><?php echo Text::_('MOD_SPBOOKING_SEARCH_ADULTS'); ?></span>
                                </div>
                                <div class="person-info-right">
                                    <button class="btn btn-danger btn-xs btn-minus"><span class="fa fa-minus"></span></button>
                                    <span class="value value-holder is-adult" data-min="1" data-val='<?php echo $adult; ?>' data-singular="<?php echo Text::_('MOD_SPBOOKING_SEARCH_ADULT'); ?>" data-plural="<?php echo Text::_('MOD_SPBOOKING_SEARCH_ADULTS'); ?>" data-info="<?php echo $adult . ' ' . SpbookingHelper::pluralize($adult, 'MOD_SPBOOKING_SEARCH_ADULT', 'MOD_SPBOOKING_SEARCH_ADULTS'); ?>"><?php echo $adult; ?></span>
                                    <button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
                                    <input type="hidden" name="adult" class="topbar-search-adults" value="<?php echo $adult; ?>">
                                </div>
                            </div>
                            <div class="topbar-btn-group">
                                <div class="person-info-left">
                                    <span class="person-room-title"><?php echo Text::_('MOD_SPBOOKING_SEARCH_CHILDREN'); ?></span>
                                </div>
                                <div class="person-info-right">
                                    <button class="btn btn-danger btn-xs btn-minus"><span class="fa fa-minus"></span></button>
                                    <span class="value value-holder is-child" data-min="0" data-val='<?php echo $child; ?>' data-singular="<?php echo Text::_('MOD_SPBOOKING_SEARCH_CHILD'); ?>" data-plural="<?php echo Text::_('MOD_SPBOOKING_SEARCH_CHILDREN'); ?>" data-info="<?php echo $child . ' ' . SpbookingHelper::pluralize($child, 'MOD_SPBOOKING_SEARCH_CHILD', 'MOD_SPBOOKING_SEARCH_CHILDREN'); ?>"><?php echo $child; ?> </span>
                                    <button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
                                    <input type="hidden" name="child" class="topbar-search-children" value="<?php echo $child; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="reserved-box">
            <input type="hidden" class="search-location" >
            <input type="hidden" class="search-accomodation" >
            <input type="hidden" class="search-country" >
            <input type="hidden" class="option" name="option" value="com_spbooking" >
            <input type="hidden" class="view" name="view" value="accomodations" >
            <input type="hidden" class="menuitem" name="Itemid" value="<?php echo str_replace('&Itemid=', '', $menuItemIdAcc); ?>" >
        </div>

        <div class="spbooking-row">
            <div class="spbooking-col-12">
                <button class="btn btn-success search-btn"> <?php echo Text::_('MOD_SPBOOKING_SEARCH_KEYWORD_SEARCH'); ?></button>
            </div>
        </div>
    </form>
    <!-- end of accomodation search -->

    <!-- package search form -->
    <form action="#" id="mod-spbooking-search-package">
        <div class="spbooking-row mt-10">
            <!-- keyword search input field  -->
            <div class="spbooking-col-12 spbooking-col-lg-6">
                <div class="form-groups">
                    <!-- location search  -->
                    <div class="topbar-search-wrapper">
                        <input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>">
                        <ul class="topbar-search-result"></ul>
                        <div class="topbar-search-loading">
                            <span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
                        </div>
                    </div>
                    <input type="hidden" name="package" class="topbar-accomodation-input" >
                    <input type="hidden" name="city" class="topbar-city-input" >
                    <input type="hidden" name="country" class="topbar-country-input" >
                </div>
            </div>
            <div class="spbooking-col-md-6 spbooking-col-lg-3">
                <div class="form-groups">
                    <!-- location search  -->
                    <div class="topbar-search-wrapper">
                        <input type="number" class="form-control search-capacity" name="capacity" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_CAPACITY'); ?>" >
                    </div>
                </div>
            </div>
            <div class="spbooking-col-md-6 spbooking-col-lg-3">
                <div class="form-groups">
                    <!-- location search  -->
                    <div class="topbar-search-wrapper">
                        <select class="form-control spbooking-select overlap search-category" name="category" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_CATEGORY'); ?>">
                            <option value=""><?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_PACKAGE_SELECT_CATEGORY'); ?></option>
                            <?php if(!empty($package_categories)) { ?>
                                <?php foreach($package_categories as $cat) { ?>
                                    <option value="<?php echo $cat->id; ?>"><?php echo $cat->title; ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="spbooking-row mt-10">
            <div class="spbooking-col-md-6">
                <div class="form-groups">
                    <div class="topbar-search-wrapper">
                        <div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
                        <input class="form-control package-date-from" name="date_from" placeholder="<?php echo Text::_('MOD_SPBOOKING_SEARCH_DATE_FROM') ?>">
                    </div>
                </div>
            </div>
            <div class="spbooking-col-md-6">
                <div class="form-groups">
                    <div class="topbar-search-wrapper">
                        <div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
                        <input class="form-control package-date-to" name="date_to" placeholder="<?php echo Text::_('MOD_SPBOOKING_SEARCH_DATE_TO') ?>">
                    </div>
                </div>
            </div>
        </div>

        <div class="reserved-box">
            <input type="hidden" class="search-location" >
            <input type="hidden" class="search-accomodation" >
            <input type="hidden" class="search-country" >
            <input type="hidden" class="option" name="option" value="com_spbooking" >
            <input type="hidden" class="view" name="view" value="packages" >
            <input type="hidden" class="package_type" name="package_type" value="0">
            <input type="hidden" class="menuitem" name="Itemid" value="<?php echo str_replace('&Itemid=', '', $menuItemIdPkg); ?>" >
        </div>

        <div class="spbooking-row mt-10">
            <div class="spbooking-col-12">
                <button class="btn btn-success search-btn"> <?php echo Text::_('MOD_SPBOOKING_SEARCH_KEYWORD_SEARCH'); ?></button>
            </div>
        </div>
    </form>
    <!-- end package search form -->


    <!-- transport search form -->
    <form action="#" id="mod-spbooking-search-transport">
        <div class="spbooking-row mt-10">
            <!-- keyword search input field  -->
            <div class="spbooking-col-12 spbooking-col-lg-6">
                <div class="form-groups">
                    <!-- location search  -->
                    <div class="topbar-search-wrapper">
                        <input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_DESTINATION')?>" >
                        <ul class="topbar-search-result"></ul>
                        <div class="topbar-search-loading">
                            <span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
                        </div>
                    </div>
                    <input type="hidden" name="transport" class="topbar-accomodation-input" >
                    <input type="hidden" name="city" class="topbar-city-input" >
                    <input type="hidden" name="country" class="topbar-country-input" >
                </div>
            </div>

            <!-- checkin checkout ranger column -->
            <div class="spbooking-col-md-6">
                <div class="topbar-range">
                    <input type="text" class="form-control topbar-checkin-out-range" placeholder="<?php echo Text::_('MOD_SPBOOKING_SEARCH_AVAILABLE_IN'); ?>">
                    <div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
                    <input type="hidden" class="topbar-search-checkin" name="checkin" >
                    <input type="hidden" class="topbar-search-checkout" name="checkout" >
                </div>
            </div>

            <!-- search by categories -->
            <div class="spbooking-col-12 spbooking-col-md-6">
                <div class="topbar-search-wrapper">
                    <select class="form-control spbooking-select overlap search-category" name="category" placeholder="<?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_CATEGORY'); ?>">
                        <option value=""><?php echo Text::_('MOD_SPBOOKING_TOPBAR_SEARCH_PACKAGE_SELECT_CATEGORY'); ?></option>
                        <?php if(!empty($transport_categories)) { ?>
                            <?php foreach($transport_categories as $cat) { ?>
                                <option value="<?php echo $cat->id; ?>"><?php echo $cat->title; ?></option>
                            <?php } ?>
                        <?php } ?>
                    </select>
                </div>
            </div>

            <div class="spbooking-col-12 spbooking-col-md-6">
                <!-- search by price range -->
                <span class="transport-ranger"><?php echo Text::_('MOD_SPBOOKING_SEARCH_PRICE_RANGE'); ?></span>
				<div class="content-price-range spbooking-input-wrap spbooking-ranger">
					<div id="transport-price-range"></div>
					<input type="hidden" name="min-price" id="min-price" class="spbooking-ranger">
					<input type="hidden" name="max-price" id="max-price" class="spbooking-ranger">
				</div>
            </div>
        </div>

        <div class="reserved-box">
            <input type="hidden" class="search-location" >
            <input type="hidden" class="search-accomodation" >
            <input type="hidden" class="search-country" >
            <input type="hidden" class="option" name="option" value="com_spbooking" >
            <input type="hidden" class="view" name="view" value="transports" >
            <input type="hidden" class="menuitem" name="Itemid" value="<?php echo str_replace('&Itemid=', '', $menuItemIdTrn); ?>" >
        </div>

        <div class="spbooking-row mt-10">
            <div class="spbooking-col-12">
                <button class="btn btn-success search-btn"><?php echo Text::_('MOD_SPBOOKING_SEARCH_KEYWORD_SEARCH'); ?></button>
            </div>
        </div>
    </form>
</div>
