<?php

/**
 * @package mod_sp_club_ranking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Component\ComponentHelper;

// Frontend component helper
$component_helper_frontend = JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($component_helper_frontend))
{
	require_once $component_helper_frontend;
}

// Required module helpers
JLoader::register('ModSpbookingSearchHelper', __DIR__ . '/helper.php');

// Load css
$doc = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome.min.css');

if (JVERSION < 4)
{
	$doc->addStylesheet(Uri::root() . 'administrator/components/com_spbooking/assets/css/font-awesome-5.min.css');
	$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome-v4-shims.css');
}

$doc->addStylesheet(Uri::root(true) . '/modules/mod_spbooking_search/assets/css/style-search.css');
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/flatpickr.theme.materialGreen.css');
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/nouislider.min.css');
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/style.css');

$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/flatpickr.min.js');
$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/nouislider.min.js');
$doc->addScript(Uri::root(true) . '/modules/mod_spbooking_search/assets/js/spsearch.js');

$package_categories = ModSpbookingSearchHelper::getCategories('package');
$transport_categories = ModSpbookingSearchHelper::getCategories('transport');

$menuItemIdAcc = SpbookingHelper::getItemId('accomodations');
$menuItemIdPkg = SpbookingHelper::getItemId('packages');
$menuItemIdTrn = SpbookingHelper::getItemId('transports');

$price_range = ModSpbookingSearchHelper::getPriceRange('transport');

if (empty($price_range->min_price))
{
	$price_range->min_price = 0;
}


if (empty($price_range->max_price))
{
	$price_range->max_price = 1000;
}

$cParams = ComponentHelper::getParams('com_spbooking');
$currency = $cParams->get('currency', 'USD:$');
$currency_position = $cParams->get('currency_position', 'left');
$currency = explode(':', $currency, 2)[1];


$doc->addScriptDeclaration("
    jQuery(function($){
        $('#mod-spbooking-search-" . $module->id . "').spSearch({
            topsearch_host : '" . Uri::root() . "',
            min_price: " . $price_range->min_price . ",
            max_price: " . $price_range->max_price . ",
            currency: '" . $currency . "',
            currency_position: '" . $currency_position . "'
        });
    });
"
);

require ModuleHelper::getLayoutPath('mod_spbooking_search');
