<?php
/**
 * @package mod_sp_club_ranking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;

$component_helper_frontend = JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($component_helper_frontend))
{
	require_once $component_helper_frontend;
}

class ModSpbookingSearchHelper
{

	public static function getCategories($category_for = 'accomodation')
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id, title')
			->from($db->quoteName('#__spbooking_categories'))
			->where($db->quoteName('category_for') . ' = ' . $db->quote($category_for))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObjectList();
	}

	public static function getKeywordSearchAjax()
	{
		$output 	= array();
		$input 		= Factory::getApplication()->input;
		$keyword 	= $input->get('keyword', '', 'STRING');
		$limit 		= $input->get('limit', 5, 'INT');

		$search_for = $input->get('search_for', 'accomodation');
		$search_tbl = '#__spbooking_accomodations';

		if ($search_for == 'accomodation')
		{
			$search_tbl = '#__spbooking_accomodations';
		}
		elseif ($search_for == 'package')
		{
			$search_tbl = '#__spbooking_packages';
		}
		elseif ($search_for == 'transport')
		{
			$search_tbl = '#__spbooking_transports';
		}

		if (!empty($keyword))
		{
			$keyword = implode('|', explode(' ', $keyword));
		}

		// Search by keyword from accomodation title
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.id, a.title, a.city, a.country')->from($db->quoteName($search_tbl, 'a'))
			->where($db->quoteName('a.title') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->order($db->quoteName('a.title') . ' ASC');

		$query->setLimit($limit);
		$db->setQuery($query);
		$contents = $db->loadObjectList();
		unset($db, $query);

		if (!empty($contents))
		{
			foreach ($contents as $v)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='" . $search_for . "' data-content='" .
				$v->id . "' ><p><strong>" . $v->title . "</strong>, " . $v->city . ", " . $v->country . "</p></li>";
			}
		}

		// Search by keyword from city
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.id, a.city, a.country')->from($db->quoteName($search_tbl, 'a'))
			->where($db->quoteName('a.city') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->group($db->quoteName('a.city'))
			->order($db->quoteName('a.city') . ' ASC');

		$query->setLimit($limit);

		$db->setQuery($query);

		$cities = $db->loadObjectList();
		unset($db, $query);

		if (!empty($cities))
		{
			foreach ($cities as $city)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='city' data-content='" . base64_encode($city->city) . "'><p><strong>" . $city->city . "</strong>, " . $city->country . "</p>";
			}
		}

		// Search by keyword from country name
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.id, a.country')
			->from($db->quoteName($search_tbl, 'a'))
			->where($db->quoteName('a.country') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->group($db->quoteName('a.country'))
			->order($db->quoteName('a.country') . ' ASC');

		$query->setLimit($limit);

		$db->setQuery($query);
		$countries = $db->loadObjectList();
		unset($db, $query);

		if (!empty($countries))
		{
			foreach ($countries as $country)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='country' data-content='" . base64_encode($country->country) . "'><p><strong>" . $country->country . "</strong></p>";
			}
		}

		$result = array();

		if (!empty($output) && count($output) > $limit)
		{
			for ($i = 0; $i < $limit; $i++)
			{
				$result[] = $output[$i];
			}
		}
		else
		{
			$result = $output;
		}

		echo implode("\n", $result);
		die();
	}

	public static function getPriceRange($price_for = 'transport')
	{
		$tbl_name = '#__spbooking_transports';

		if ($price_for == 'transport')
		{
			$tbl_name = '#__spbooking_transports';
		}
		elseif ($price_for == 'package')
		{
			$tbl_name = '#__spbooking_packages';
		}

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('MIN(sale_price) AS min_price, MAX(price) AS max_price')
			->from($tbl_name)
			->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		return $db->loadObject();
	}

}
