;(function($, window, document, undefined){
    var name = "spSearch";
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.spSearch.defaults;
        this.options = $.extend({}, this._defaults, options);
        
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataFactory();
            this.commonMethods();
            this.generalSearchMethod();
        },
        cacheElement: function() {
            this.$element = $(this.element);
        },
        dataFactory: function() {
            this.search_for = 'accomodation';
            this.$search_bar_btns       = this.$element.find('.search-bar-header');
            this.$accomodation_search_form = this.$element.find('form#mod-spbooking-search-accomodation');
            this.$package_search_form = this.$element.find('form#mod-spbooking-search-package');
            this.$transport_search_form = this.$element.find('form#mod-spbooking-search-transport');
            
            this.$search_form = this.$accomodation_search_form;
            this.formElements(this.$search_form);
        },

        formElements: function($parent) {

            this.$search_destination    = $parent.find('.search-destination');
            this.$search_result         = $parent.find('.topbar-search-result');
            this.$search_loading        = $parent.find('.topbar-search-loading');
            this.$accomodation_input    = $parent.find('.topbar-accomodation-input');
            this.$city_input            = $parent.find('.topbar-city-input');
            this.$country_input         = $parent.find('.topbar-country-input');
            this.$checkinout            = $parent.find('.topbar-checkin-out-range');
            this.$checkin               = $parent.find('.topbar-search-checkin');
            this.$checkout              = $parent.find('.topbar-search-checkout');
            this.$toggle_person         = $parent.find('.toggle-person-info');
            this.$person_container      = $parent.find('.person-container');
            this.$package_type          = $parent.find('.package_type');
            this.$date_from             = $parent.find('.date_from');
            this.$date_to               = $parent.find('.date_to');

            $('.btn-plus').off('click');
            $('.btn-minus').off('click');
        },
        renderPrice: function(price) {
            if (this.options.currency_position == 'left') {
                return `${this.options.currency}${price}`;
            } else {
                return `${price}${this.options.currency}`;
            }
        },
        commonMethods: function() {
            let self = this;
            // Price range noUiSlider
            var ranger = document.getElementById('transport-price-range');
            if (ranger !=  null) {
                noUiSlider.create(ranger , {
                    connect: true,
                    behaviour: 'tap',
                    start: [this.options.min_price, parseInt(this.options.max_price)],
                    tooltips: [true, true],
                    step: 1,
                    range: {
                        'min': [this.options.min_price],
                        'max': [parseInt(this.options.max_price)]
                    },
                    format: {
                        to: function (value) {
                            return self.renderPrice(parseInt(value, 10));
                        },
                        from: function (value) {
                            return value;
                        }
                    }
                });
                
                ranger.noUiSlider.on('update', function(values, handle) {
                    $('#min-price').val(values[0]);
                    $('#max-price').val(values[1]);
                });
            }
        },

        searchBarHeader: function() {
            let self = this;
            this.$search_bar_btns.on('click', function(e){
                self.$search_bar_btns.each(function(){
                    if ($(this).hasClass('active')) {
                        $(this).removeClass('active');
                    }
                });
                if (!$(this).hasClass('active')) {
                    $(this).addClass('active');
                }
                let view = $(this).data('view');
                

                if (view == 'accomodations') {
                    self.$search_form = self.$accomodation_search_form;
                    self.$accomodation_search_form.show();
                    self.$package_search_form.hide();
                    self.$transport_search_form.hide();

                    self.search_for = 'accomodation';
                } else if (view == 'packages') {
                    self.$search_form = self.$package_search_form;
                    self.$package_search_form.show();
                    self.$accomodation_search_form.hide();
                    self.$transport_search_form.hide();

                    self.$package_type.val('0'); // value 0 for all packages
                    self.search_for = 'package';
                }  else if (view == 'daily_tour') {
                    self.$search_form = self.$package_search_form;
                    self.$package_search_form.show();
                    self.$accomodation_search_form.hide();
                    self.$transport_search_form.hide();
                    
                    self.$package_type.val('1'); // value 1 for daily tour i.e. short package
                    self.search_for = 'package';
                } else if (view == 'transports') {
                    self.$search_form = self.$transport_search_form;
                    self.$transport_search_form.show();
                    self.$package_search_form.hide();
                    self.$accomodation_search_form.hide();

                    self.search_for = 'transport';
                }

                self.formElements(self.$search_form);

                self.eventHandlers();
                self.initFlatPickr();
                self.updatePersonInfo();
            });
        },

        generalSearchMethod: function() {
            this.searchBarHeader();

            this.eventHandlers();
            this.initFlatPickr();
            this.updatePersonInfo();
        },
        
        eventHandlers: function() {
            let self = this;
            this.$search_destination.on('keyup focus', function(e){
                e.preventDefault();
                let keyword = typeof($(this).val()) == 'string' && $(this).val().length > 0 ? $(this).val() : false;
                let url = 'index.php?option=com_ajax&module=spbooking_search&method=getKeywordSearch&format=json';
                let timer;

                if (keyword) {
                    self.$search_result.empty();
                    self.$search_loading.show();

                    clearTimeout(timer);
                    timer = setTimeout(() => {
                        self.getKeywordSearchResult(url, keyword, 5, self.search_for).then((response) => {
                            if (!!response) {
                                self.$search_result.show();
                                self.$search_result.html(response);
                                self.$search_loading.hide();
                            }
                        });
                    }, 300);
                }
            });

            // Select a specific result
            this.$search_form.on('click', '.topbar-search-result-item' ,  function(e){
                e.preventDefault();
                let restype         = typeof($(this).data('restype')) == 'string' && $(this).data('restype').length > 0 ? $(this).data('restype') : false;
                let accomodation    = false;
                let package         = false;
                let transport       = false;
                let city            = false;
                let country         = false;

                if (restype) {
                    if (restype == 'accomodation') {
                        accomodation = $(this).data('content');
                    } else if (restype == 'city') {
                        city = $(this).data('content');
                    } else if (restype == 'country') {
                        country = $(this).data('content');
                    } else if (restype == 'package') {
                        package = $(this).data('content');
                    } else if (restype == 'transport') {
                        transport = $(this).data('content');
                    }
                }

                if (accomodation) {
                    self.$accomodation_input.val(accomodation);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                } else if (package) {
                    self.$accomodation_input.val(package);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                } else if (transport) {
                    self.$accomodation_input.val(transport);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                } else if (city) {
                    self.$accomodation_input.val('');
                    self.$city_input.val(city);
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                } else if (country) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val(country);
                    self.$search_destination.val($(this).text());
                }

                self.$search_result.hide();
            });

            // Close result div on click outside
            $(document).on('click', function(e) {
                
                if( $(e.target).closest(".topbar-search-result").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".search-destination").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".toggle-person-info").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".topbar-btn-group").length > 0 ) {
                    return false;
                }

                self.$search_result.hide();
                self.$person_container.removeClass('open');
                self.$element.find('.person-caret > span').removeClass('fa-caret-up').addClass('fa-caret-down');
            });

            // toggle person info
            $(document).on('click','.toggle-person-info', function(e) {
                e.preventDefault();
                e.stopPropagation();
                let $person_caret       = $(this).parent().find('.person-caret > span');
                let $person_container   = $(this).parent().find('.person-container');
                if ($person_caret.hasClass('fa-caret-down')) {
                    $person_caret.removeClass('fa-caret-down').addClass('fa-caret-up');
                    $person_container.addClass('open');
                } else if ($person_caret.hasClass('fa-caret-up')) {
                    $person_caret.removeClass('fa-caret-up').addClass('fa-caret-down');
                    $person_container.removeClass('open');
                }

            });

            // increment decrement person information
            $(this.$search_form.find('.btn-minus')).on('click', function(e){
                e.preventDefault();
                e.stopPropagation();
                let $value_holder = $(this).siblings('.value-holder');
                let val = $value_holder.length > 0 && typeof($value_holder.data('val')) == 'number' && $value_holder.data('val') ? parseInt($value_holder.data('val')) : 0;
                let min = $value_holder.length > 0 && typeof($value_holder.data('min')) == 'number' && $value_holder.data('min') ? parseInt($value_holder.data('min')) : 0;
                if (val > min) {
                    val--;
                    console.log(val);
                    $value_holder.data('val', val);
                    let info = val + ' ' + (val > 1 ? $value_holder.data('plural') : $value_holder.data('singular'));
                    $value_holder.text(val);
                    $value_holder.data('info', info);
                    $(this).parent().find('input').val(val);
                    self.updatePersonInfo();
                }
            });
            
            $(this.$search_form.find('.btn-plus')).on('click', function(e){
                e.preventDefault();
                e.stopPropagation();
                let $value_holder = $(this).siblings('.value-holder');
                let val = $value_holder.length > 0 && typeof($value_holder.data('val')) == 'number' && $value_holder.data('val') ? parseInt($value_holder.data('val')) : 0;
                console.log(val);
                
                val++;
                $value_holder.data('val', val);
                let info = val + ' ' + (val > 1 ? $value_holder.data('plural') : $value_holder.data('singular'));
                $value_holder.text(val);
                $value_holder.data('info', info);
                $(this).parent().find('input').val(val);
                self.updatePersonInfo();
            });
            this.submitSearch();
        },
        submitSearch: function() {
            // Submit topbar form
            let self = this;

            this.$search_form.on('submit', function(e){
                e.preventDefault();
                let formData    = $(this).serializeArray();
                let query       = new URLSearchParams(window.location.search);
                
                formData    = typeof(formData) == 'object' && formData instanceof Array && formData.length > 0 ? formData : false;
                query       = typeof (query) == 'object' && query ? query : false;
                
                if (formData) {
                    formData.map((v) => {
                        let name = typeof(v.name) == 'string' && v.name.length > 0 ? v.name : false;
                        let val = typeof(v.value) == 'string' && v.value.length > 0 ? v.value : false;
                        
                        if(name) {
                            if (val) {
                                if (query.has(name)) {
                                    query.set(name, val);
                                } else {
                                    query.append(name, val);
                                }
                            } else {
                                if (query.has(name)) {
                                    query.delete(name);
                                }
                            }
                        }
                    });
                }
                
                window.location.href = self.options.topsearch_host + 'index.php?' + query.toString();
            });
        },
        updatePersonInfo: function() {
            let info = '';
            let $is_room = this.$element.find('.value-holder.is-room');
            let $is_adult = this.$element.find('.value-holder.is-adult');
            let $is_child = this.$element.find('.value-holder.is-child');
            info = $is_room.data('info') + ', ' + $is_adult.data('info') + ', ' + $is_child.data('info');
            this.$toggle_person.text(info);
        },

        getKeywordSearchResult: function(url, keyword, limit, search_for = 'accomodation') {
            let self = this;
            return new Promise((resolve, reject) => {
                $.ajax({
                    url: self.options.topsearch_host + url,
                    type: 'post',
                    data: {
                        keyword: keyword,
                        limit: limit,
                        search_for: search_for
                    },
                    success: function(response) {
                        resolve(response);
                    },
                    error: function(err) {
                        reject(err);
                    }
                });
            });
        },

        initFlatPickr: function() {
            let self = this;
            this.$checkinout.flatpickr({
                mode: "range",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                defaultDate: [self.options.checkin, self.options.checkout],
                onOpen: function() {
                    let $calendar_icon = self.$checkinout.siblings('.range-icon').find('span');
                    if ($calendar_icon.hasClass('text-mute')) {
                        $calendar_icon.removeClass('text-mute').addClass('text-green');
                    }
                },
                onClose: function() {
                    let $calendar_icon = self.$checkinout.siblings('.range-icon').find('span');
                    if ($calendar_icon.hasClass('text-green')) {
                        $calendar_icon.removeClass('text-green').addClass('text-mute');
                    }
                },
                onChange: function(selectedDates, dateStr, instance) {
                    dateStr = typeof(dateStr) == 'string' && dateStr.length > 0 ? dateStr : false;
                    
                    if (!!dateStr) {
                        dateStr = dateStr.split('to');
                        let checkin = typeof(dateStr[0]) == 'string' && dateStr[0].length > 0 ? dateStr[0] : false;
                        let checkout = typeof(dateStr[1]) == 'string'  && dateStr[1].length > 0 ? dateStr[1] : false;

                        if (!!checkin) {
                            self.$checkin.val(checkin.trim());
                            if (!!checkout) {
                                self.$checkout.val(checkout.trim());
                            } else {
                                let day = new Date(checkin);
                                const newDate = new Date(day.setDate(day.getDate() + 1));
                                self.$checkout.val(`${newDate.getFullYear()}-${newDate.getMonth()}-${newDate.getDate()}`);
                            }
                        }
                    }
                }
            });

            $('.package-date-from').flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d"
            });
            $('.package-date-to').flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: 'today',
                dateFormat: "Y-m-d"
            });
        }

    });

    $.fn.spSearch = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spSearch.defaults = {
        topsearch_host: '',
        search_for: 'accomodation',
        checkin: '',
        checkout: '',
        min_price: 0,
        max_price: 999999,
        currency: '$',
        currency_position: 'left'
    };
})(jQuery, window, document);