<?php
/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

$user = Factory::getUser();
?>

<div id="spbooking-packages<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
  <div class="spbooking-packages-module">
	<div class="spbooking-row">
	  <?php if (!empty($packages))
		{
			?>
			<?php foreach ($packages as $package)
			{
				?>
			<div class="spbooking-col-md-6 spbooking-col-lg-4">
				<div class="spbooking-package">
					<div class="spbooking-package-img-wrap">
						<a href="<?php echo $package->url; ?>" class="full-link"></a>
						<?php
						if (!empty($package->image))
						{
							?>
							<img src="<?php echo $package->thumb; ?>" alt="package">
						<?php } ?>
						<?php
						if (!empty($package->save_money))
						{
							?>
							<div class="spbooking-package-discount">
								<span><?php echo Text::_('COM_SPBOOKING_COMMON_SAVE'); ?></span>
								<span class="only-price"><?php echo SpbookingHelper::formatPrice($package->save_money, $package->currency, $package->currency_type, $package->currency_position); ?></span>
							</div>
						<?php } ?>
						<ul class="package-tags">
							<li><span><?php echo Text::_('MOD_SPBOOKING_PACKAGES_FEATURE_TITLE'); ?></span></li>
							<?php
							if (!empty($package->package_tags))
							{
								?>
								<?php foreach ($package->package_tags as $tag)
								{
									?>
									<li><span><?php echo $tag->title; ?></span></li>
								<?php } ?>
							<?php } ?>
						</ul>
					</div>
					<div class="spbooking-package-info">
						<div class="spbooking-price-wrap spbooking-d-flex">
							<?php if (!empty($package->sale_price))
							{
								?>
								<span class="price"><small><?php echo Text::_('MOD_SPBOOKING_PACKAGE_FROM'); ?></small><del><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></del> <span><?php echo SpbookingHelper::formatPrice($package->sale_price, $package->currency, $package->currency_type, $package->currency_position); ?></span></span>
							<?php }
							else
							{
								?>
								<span class="price"><small><?php echo Text::_('MOD_SPBOOKING_PACKAGE_FROM'); ?></small> <span><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></span></span>
							<?php }  ?>
							<a href="<?php echo $package->url; ?>" class="spbooking-btn spbooking-btn-pirmary"><?php echo Text::_('MOD_SPBOOKING_PACKAGES_VIEW_TOUR'); ?></a>
						</div>
						<h3 class="title"><a href="<?php echo $package->url; ?>"><?php echo $package->title; ?></a></h3>
						<div class="spbooking-package-meta spbooking-d-flex">
							<?php if (!empty($package->state) && !empty($package->country))
							{
								?>
								<span><i class="fa fa-map-marker"></i><?php echo $package->state . ', ' . $package->country; ?></span>
							<?php } ?>
							<?php
							if (!empty($package->start_date) && !empty($package->end_date))
							{
								?>
								<span><i class="fa fa-calendar"></i><?php echo HTMLHelper::_('date', $package->start_date, 'd M') . ' - ' . HTMLHelper::_('date', $package->end_date, 'd M'); ?></span>                            
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			  
			<?php } ?>
	  <?php } ?>
	</div>
  </div>
</div>
