<?php

/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

$user = Factory::getUser();
?>

<div id="spbooking-packages<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
  <div class="spbooking-packages-module spbooking-classic-deals-packages">
	<div class="spbooking-row">
		<?php if (!empty($packages))
		{
			?>
			<?php foreach ($packages as $package)
			{
				?>
				<div class="spbooking-col-md-6 spbooking-col-lg-3">
					<div class="spbooking-package" style="<?php echo !empty($package->image) ? 'background-image:url(' . $package->thumb_large . ');' : 'background: rgba(0,0,0,0.2);'; ?>">
						<?php
						if (!empty($package->save_money))
						{
							?>
							<div class="spbooking-package-discount">
								<span><?php echo Text::_('COM_SPBOOKING_COMMON_SAVE'); ?></span>
								<span class="only-price"><?php echo SpbookingHelper::formatPrice($package->save_money, $package->currency, $package->currency_type, $package->currency_position); ?></span>
							</div>
						<?php } ?>
						<div class="spbooking-package-info">
							<h4 class="spbooking-package-discount-title"><a href="<?php echo $package->url; ?>"><?php echo $package->title; ?></a></h4>
							<?php
							if (!empty($package->sale_price))
							{
								?>
								<p class="spbooking-package-discount-price"> <?php echo SpbookingHelper::formatPrice($package->sale_price, $package->currency, $package->currency_type, $package->currency_position); ?><small><?php echo Text::_('COM_SPBOOKING_COMMON_PERSON'); ?></small></p>
							<?php } ?>
							<a href="<?php echo $package->url; ?>" class="spbooking-btn spbooking-btn-primary"><?php echo Text::_('MOD_SPBOOKING_PACKAGES_VIEW_DEAL'); ?></a>
						</div>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
  </div>
</div>
