<?php
/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;

$user = Factory::getUser();
?>

<div id="spbooking-packages<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
  <div class="spbooking-packages-module spbooking-classic-packages">
	<div class="spbooking-row">
		<?php if (!empty($packages))
		{
			?>
			<?php foreach ($packages as $package)
			{
				?>
				<div class="spbooking-col-md-6 spbooking-col-lg-4">
					<div class="spbooking-package">
					<div class="spbooking-package-img-wrap">
						<a href="<?php echo $package->url; ?>" class="full-link"></a>
						<?php
						if ($package->image)
						{
							?>
							<img src="<?php echo $package->thumb_large; ?>" alt="package">
						<?php } ?>
					</div>
					<div class="spbooking-package-info">
						<?php if (!empty($package->total))
						{
							?>
							<p class="spbooking-package-daily-tour"><?php echo $package->total . ' ' . SpbookingHelper::pluralize($package->total, 'MOD_SPBOOKING_PACKAGES_PACKAGE', 'MOD_SPBOOKING_PACKAGES_PACKAGES'); ?> </p>
						<?php } ?>
						<?php
						if (!empty($city_state) && $city_state == 'state')
						{
							?>
							<?php if (!empty($package->state) && !empty($package->country))
							{
								?>
								<h3 class="title"><a href="<?php echo $package->url; ?>"><?php echo $package->state . ', ' . $package->country; ?></a></h3>
							<?php } ?>
						<?php }
						elseif (!empty($city_state) && $city_state == 'city')
						{
							?>
							<?php if (!empty($package->city) && !empty($package->country))
							{
								?>
								<h3 class="title"><a href="<?php echo $package->url; ?>"><?php echo $package->city . ', ' . $package->country; ?></a></h3>
							<?php } ?>
						<?php }
						elseif (!empty($city_state) && $city_state == 'country')
						{
							?>
							<?php if (!empty($package->country))
							{
								?>
								<h3 class="title"><a href="<?php echo $package->url; ?>"><?php echo $package->country; ?></a></h3>
							<?php } ?>
						<?php } ?>
					</div>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
  </div>
</div>
