<?php
/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

HTMLHelper::_('jquery.framework');

// Helper & model
$com_helper 		= JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($com_helper))
{
	require_once $com_helper;
}
else
{
	echo '<p class="alert alert-warning">' . Text::_('MOD_SPBOOKING_COMPONENT_NOT_INSTALLED_OR_MISSING_FILE') . '</p>';

	return;
}

JLoader::register('ModSpbookingPackageHelper', __DIR__ . '/helper.php');

// Includes js and css
$doc        = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/style.css');
$doc->addStylesheet(Uri::root(true) . '/modules/' . $module->module . '/assets/css/style.css');

$doc->addScript(Uri::root(true) . '/modules/' . $module->module . '/assets/js/script.js');

// Get layout type
$layout = $params->get('layout', '_:default');

// Data proccesing for classic layout
$packages = array();
$menuItemId = SpbookingHelper::getItemId('packages');

if ($layout == '_:classic')
{
	$city_state = $params->get('city_state', 'state');
	$classic_limit = $params->get('classic_limit', 6);

	if ($city_state == 'state')
	{
		$states = $params->get('state', array());

		if (!empty($states))
		{
			$packages = ModSpbookingPackageHelper::getPackages('state', $states, $classic_limit);
		}
	}
	elseif ($city_state == 'city')
	{
		$cities = $params->get('city', array());

		if (!empty($cities))
		{
			$packages = ModSpbookingPackageHelper::getPackages('city', $cities, $classic_limit);
		}
	}
	elseif ($city_state == 'country')
	{
		$countries = $params->get('country', array());

		if (!empty($countries))
		{
			$packages = ModSpbookingPackageHelper::getPackages('country', $countries, $classic_limit);
		}
	}

	if (!empty($packages))
	{
		foreach ($packages as $package)
		{
			$link = 'index.php?option=com_spbooking&view=packages';

			if ($city_state == 'state')
			{
				$link .= '&p_state=' . $package->state;
			}
			elseif ($city_state == 'city')
			{
				$link .= '&p_city=' . $package->city;
			}
			elseif ($city_state == 'country')
			{
				$link .= '&p_country=' . $package->country;
			}

			$link .= $menuItemId;
			$package->url = Route::_($link);

			$package->price = (int) $package->price;
			$package->sale_price = (int) $package->sale_price;

			$package->thumb_large = SpbookingHelper::getThumbs($package->image, 'thumbnail_large', '650x410');
		}
	}
}
elseif ($layout == '_:default')
{
	$packages = ModSpbookingPackageHelper::getPackagesForDefaultLayout($params);

	if (!empty($packages))
	{
		foreach ($packages as $package)
		{
			$package->price = (int) $package->price;
			$package->sale_price = (int) $package->sale_price;

			if (!empty($package->sale_price) && $package->sale_price < $package->price)
			{
				$package->save_money = $package->price - $package->sale_price;
			}
			else
			{
				$package->save_money = 0;
			}

			$package->url = Route::_('index.php?option=com_spbooking&view=package&id=' . $package->id . ':' . $package->alias . $menuItemId);
			$package->package_tags = ModSpbookingPackageHelper::getTags($package->package_tags);
			$package->thumb = SpbookingHelper::getThumbs($package->image, 'thumbnail', '360x348');
		}
	}
}
elseif ($layout == '_:dealsClassic')
{
	$packages = ModSpbookingPackageHelper::getPackagesForDealsClassicLayout($params);

	if (!empty($packages))
	{
		foreach ($packages as $package)
		{
			$package->price = (int) $package->price;
			$package->sale_price = (int) $package->sale_price;

			if (!empty($package->sale_price) && $package->sale_price < $package->price)
			{
				$package->save_money = $package->price - $package->sale_price;
			}
			else
			{
				$package->save_money = 0;
			}

			$package->url = Route::_('index.php?option=com_spbooking&view=package&id=' . $package->id . ':' . $package->alias . $menuItemId);
			$package->thumb_large = SpbookingHelper::getThumbs($package->image, 'thumbnail_large', '650x410');
		}
	}
}



$moduleclass_sfx 	= ($params->get('moduleclass_sfx')) ? htmlspecialchars($params->get('moduleclass_sfx')) : '';
require ModuleHelper::getLayoutPath('mod_spbooking_packages', $params->get('layout'));
