<?php
/**
 * @package mod_sp_club_ranking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;

class ModSpbookingPackageHelper
{
	public static function getPackages($getby, $items, $limit = 6)
	{
		// If any parameter not given then return empty array
		if (empty($getby) || empty($items))
		{
			return array();
		}

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*, count(' . $getby . ') as total')
			->from($db->quoteName('#__spbooking_packages'));

		if (!empty($getby) && !empty($items))
		{
			$query->where($db->quoteName($getby) . ' IN (' . implode(',', $db->quote($items)) . ')');
		}

		$query->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$query->group($db->quoteName($getby));
		$query->order($db->quoteName('ordering') . ' ASC');
		$query->setLimit($limit);
		$db->setQuery($query);

		$packages = $db->loadObjectList();

		return $packages;
	}

	public static function getPackagesForDefaultLayout($params)
	{

		$limit = $params->get('default_limit', 3);
		$package_type = $params->get('package_type', '');

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__spbooking_packages'));

		if (!empty($package_type))
		{
			if ($package_type == 'featured')
			{
				$query->where($db->quoteName('featured') . ' = 1');
			}
			else
			{
				$query->where($db->quoteName('package_type') . ' = ' . $db->quote($package_type));
			}
		}

		$query->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$query->order($db->quoteName('ordering') . ' ASC');
		$query->setLimit($limit);
		$db->setQuery($query);

		$packages = $db->loadObjectList();

		return $packages;
	}

	public static function getPackagesForDealsClassicLayout($params)
	{
		$ids = $params->get('deal_packages', array());
		$packages = array();

		if (!empty($ids))
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('*')
				->from($db->quoteName('#__spbooking_packages'));
			$query->where($db->quoteName('id') . ' IN (' . implode(',', $ids) . ' )');
			$query->where($db->quoteName('published') . ' = 1');
			$db->setQuery($query);
			$packages = $db->loadObjectList();
		}

		return $packages;
	}

	public static function getTags($tags)
	{
		if (empty($tags))
		{
			return array();
		}

		$tags = json_decode($tags, true);

		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('id, title')->from($db->quoteName('#__spbooking_tags'))
			->where($db->quoteName('id') . ' IN (' . implode(',', $tags) . ')')
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObjectList();
	}


}
