<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;

class JFormFieldSpdeals extends FormField
{
	protected $type = 'Spdeals';

	protected function getInput()
	{
		$multiple = '';

		if (!empty($this->multiple))
		{
			$multiple = 'multiple';
		}

		$deals = $this->getDeals();

		foreach ($deals as $key => $item)
		{
			$options[] = HTMLHelper::_('select.option', $item->id, $item->title);
		}

		return HTMLHelper::_('select.genericlist', $options, $this->name, $multiple, 'value', 'text', $this->value);
	}

	private function getDeals()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id, title')
			->from($db->quoteName('#__spbooking_packages'))
			->where($db->quoteName('sale_price') . ' > 0')
			->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		$deals = $db->loadObjectList();

		return $deals;
	}
}
