<?php
/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

$user = Factory::getUser();
?>

<div id="spbooking-destinations<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
	<div class="top-destinations-module">
		<div class="spbooking-row">
			<?php if (!empty($destinations))
			{
				?>
				<?php foreach ($destinations as $key => $destination)
				{
					?>
					<?php
						$col = 5;

					if ($key % 5 == 0)
					{
						$col = 5;
					}
					elseif ($key % 5 == 1)
					{
						$col = 7;
					}
					elseif ($key % 5 == 2 || $key % 5 == 3 || $key % 5 == 4)
					{
						$col = 4;
					}
					?>
					<div class="spbooking-col-sm-<?php echo $col; ?>">
						<div class="top-destination">
								<a class="full-link" href="<?php echo $destination->url; ?>"></a>
								<?php
								if (!empty($destination->image))
								{
									?>
									<div class="destiantion-image-wrap" style="background-image: url(<?php echo Uri::root() . $destination->image; ?>)"></div>
								<?php } ?>
							<div class="destiantion-info-wrap">
								<?php if (!empty($destination->total))
								{
									?>
									<div class="total-tour">
										<span><?php echo $destination->total; ?> <?php echo SpbookingHelper::pluralize($destination->total, 'MOD_SPBOOKING_DESTINATION_TOUR', 'MOD_SPBOOKING_DESTINATION_TOURS'); ?></span>
									</div>
								<?php } ?>
								<?php
								if (!empty($destination->title))
								{
									?>
									<div class="tour-title">
										<h4><?php echo $destination->title; ?></h4>
									</div>
								<?php } ?>
								<?php
								if (!empty($destination->country) && !empty($destination->city))
								{
									?>
									<div class="tour-place">
										<span><i class="fa fa-map-marker"></i></span>
										<span><?php echo $destination->city . ', ' . $destination->country; ?></span>
									</div>
								<?php } ?>
								<div class="destination-button-wrapper">
									<a class="spbooking button" href="<?php echo $destination->url; ?>"><?php echo Text::_('MOD_SPBOOKING_DESTINATION_VIEW_DEAL'); ?></a>
								</div>
							</div>
						</div>
					</div>
					
				<?php } ?>
			<?php } ?>
		</div>
	</div>
</div>
