<?php
/**
 * @package mod_spbooking_destinations
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

HTMLHelper::_('jquery.framework');

// Helper & model
$com_helper 		= JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($com_helper))
{
	require_once $com_helper;
}
else
{
	echo '<p class="alert alert-warning">' . Text::_('MOD_SPBOOKING_COMPONENT_NOT_INSTALLED_OR_MISSING_FILE') . '</p>';

	return;
}

JLoader::register('ModSpbookingDestinationHelper', __DIR__ . '/helper.php');

// Includes js and css
$doc        = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root(true) . '/modules/' . $module->module . '/assets/css/style.css');

$doc->addScript(Uri::root(true) . '/modules/' . $module->module . '/assets/js/script.js');


$destinations = ModSpbookingDestinationHelper::getPlaces($params);
$menuItemId = SpbookingHelper::getItemId('places');

if (!empty($destinations))
{
	foreach ($destinations as $destination)
	{
		$destination->url = Route::_('index.php?option=com_spbooking&view=places&m_country=' . $destination->country . $menuItemId);
	}
}

$moduleclass_sfx = ($params->get('moduleclass_sfx')) ? htmlspecialchars($params->get('moduleclass_sfx')) : '';
require ModuleHelper::getLayoutPath('mod_spbooking_destination', $params->get('layout'));
