<?php
/**
 * @package mod_sp_club_ranking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModSpbookingDestinationHelper
{
	public static function getPlaces($params)
	{
		$country = $params->get('country', array());
		$places = array();

		if (!empty($country))
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('*, COUNT(country) as total')
				->from($db->quoteName('#__spbooking_places'))
				->where($db->quoteName('country') . ' IN (' . implode(',', $db->quote($country)) . ')')
				->where($db->quoteName('published') . ' = 1')
				->group($db->quoteName('country'));

			$db->setQuery($query);
			$places = $db->loadObjectList();
		}

		return $places;
	}
}
