<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;

jimport('joomla.form.formfield');

class JFormFieldSpstates extends FormField
{
	protected $type = 'Spstates';

	protected function getInput()
	{
		$multiple = '';

		if (!empty($this->multiple))
		{
			$multiple = 'multiple';
		}

		$states = $this->getStates();

		foreach ($states as $key => $item)
		{
			$options[] = HTMLHelper::_('select.option', $item, $item);
		}

		return HTMLHelper::_('select.genericlist', $options, $this->name, $multiple, 'value', 'text', $this->value);
	}

	private function getStates()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('state')
			->from($db->quoteName('#__spbooking_packages'))
			->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		$states = $db->loadColumn();
		$output = array();

		if (!empty($states))
		{
			foreach ($states as $state)
			{
				if (!in_array($state, $output))
				{
					$output[] = $state;
				}
			}
		}

		return $output;
	}
}
