<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;


class JFormFieldSpcities extends FormField
{
	protected $type = 'Spcities';

	protected function getInput()
	{
		$multiple = '';

		if (!empty($this->multiple))
		{
			$multiple = 'multiple';
		}

		$cities = $this->getCities();

		foreach ($cities as $key => $item)
		{
			$options[] = HTMLHelper::_('select.option', $item, $item);
		}

		return HTMLHelper::_('select.genericlist', $options, $this->name, $multiple, 'value', 'text', $this->value);
	}

	private function getCities()
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('city')
			->from($db->quoteName('#__spbooking_places'))
			->where($db->quoteName('published') . ' = 1')
			->group($db->quoteName('city'));

		$db->setQuery($query);

		$cities = $db->loadColumn();

		return $cities;
	}
}
