<?php

/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

$user = Factory::getUser();
?>


<div id="spbooking-accomodation<?php echo $module->id; ?>" class="spbooking <?php echo $params->get('moduleclass_sfx') ?>">
	<div class="spbooking-accomodation-module">
		<div class="spbooking-row spbooking-no-gutters">
			<?php foreach ($accomodations as $accomodation)
			{
				?>
				<div class="spbooking-col-md-6 spbooking-col-lg-3">
					<div class="jeetravel-accomodation-wrap">
						<div class="accomodation-img-wrap">
							<a class="full-link" href="<?php echo $accomodation->url ?>"></a>
							<?php if (!empty($accomodation->banner))
							{
								?>
								<img src="<?php echo $accomodation->thumb_large; ?>" alt="<?php echo Uri::root() . $accomodation->title; ?>">
							<?php } ?>
						</div>
						<div class="accomodation-info-wrap">
							<?php if ($showRatings)
							{
								?>
							<div class="accomodation-rating">
								<?php foreach (range(1, 5) as $index)
								{
									?>
									<?php if ($index <= $accomodation->review['average_rating'])
									{
										?>
										<span class="fa fa-star is-filled"></span>
									<?php }
									elseif ($index > $accomodation->review['average_rating'] && $accomodation->review['average_rating'] > $index - 1)
									{
										?>
										<span class="fa fa-star-half-o is-filled"></span>
									<?php }
									else
									{
										?>
										<span class="fa fa-star-o"></span>
									<?php } ?>
								<?php } ?>
							</div>
							<?php } ?>							
							<div class="accomodation-title">
								<a href="<?php echo $accomodation->url ?>">
									<h5><?php echo $accomodation->title; ?></h5>
								</a>
							</div>
							<div class="accomodation-price">
								<?php if (!empty($accomodation->original_price))
								{
									$price = (!empty($accomodation->sale_price) ? $accomodation->sale_price : $accomodation->original_price); ?>
									<div class="spbooking-price-wrap spbooking-d-flex">
										<span class="price">
											<small>
												<?php echo Text::_('MOD_SPBOOKING_ACCOMODATION_PRICE_FROM'); ?>
											</small>
											<span><?php echo SpbookingHelper::formatPrice($price, $accomodation->currency, $accomodation->currency_type, $accomodation->currency_position, false, 2); ?></span>
											<span class="person-tag">
												/ <?php echo Text::_('MOD_SPBOOKING_ROOM_NIGHT'); ?>
											</span>
										</span>
									</div>
								<?php } ?>
							</div>
							<div class="accomodation-place">
								<?php
								$location = ($accomodation->city) ? $accomodation->city . ', ' . $accomodation->country : $accomodation->country;
								?>
								<p><?php echo $location; ?></p>
							</div>
						</div>
					</div>
				</div> <!-- /.spbooking-col-md-6  -->
			<?php } ?>

		</div> <!-- /.spbooking-row -->
	</div> <!-- /.spbooking-accomodation-module -->
</div> <!-- /#spbooking-accomodation -->
