<?php
/**
 * @package mod_spbooking_accomodation
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Component\ComponentHelper;

HTMLHelper::_('jquery.framework');

// Helper & model
$com_helper 		        = JPATH_BASE . '/components/com_spbooking/helpers/helper.php';
$accomodation_model         = JPATH_BASE . '/components/com_spbooking/models/accomodations.php';
$module_model               = __DIR__ . '/helper.php';

if (file_exists($com_helper) && file_exists($accomodation_model) && file_exists($module_model))
{
	require_once $com_helper;
	require_once $accomodation_model;
	require_once $module_model;
}
else
{
	echo '<p class="alert alert-warning">' . Text::_('MOD_SPBOOKING_COMPONENT_NOT_INSTALLED_OR_MISSING_FILE') . '</p>';

	return;
}

$accomodations = ModSpbookingAccomodationHelper::getaccomodations($params);
$showRatings   = ComponentHelper::getParams('com_spbooking')->get('rating');

if (empty($accomodations) && !count((array) $accomodations))
{
	echo '<p class="alert alert-warning">' . Text::_('MOD_SPBOOKING_NO_ITEM_FOUND') . '</p>';

	return false;
}

foreach ($accomodations as $accomodation)
{
	$min_original_price           = 0;
	$min_special_price            = 0;

	$accomodation->checkin        = new Date;
	$accomodation->checkin        = $accomodation->checkin->format('Y-m-d');
	$accomodation->checkout       = new Date('now +1 day');
	$accomodation->checkout       = $accomodation->checkout->format('Y-m-d');

	$accomodation->sale_price     = 0;
	$accomodation->original_price = 0;

	$accomodation->review         = SpbookingHelper::calculateReview($accomodation->id, 'accomodation');
	$accomodation->thumb_large    = SpbookingHelper::getThumbs($accomodation->banner, 'thumbnail_large', '650x410');
	$accomodation->rooms          = SpbookingHelper::getAvailableRooms($accomodation->checkin, $accomodation->checkout, $accomodation->id);

	if (!empty($accomodation->rooms))
	{
		$special_price  = array();
		$original_price = array();

		foreach ($accomodation->rooms as $key => $room)
		{
			// Minimum room price
			if (!empty($room->special_avg_price) && is_numeric($room->special_avg_price))
			{
				$special_price[] = $room->special_avg_price;
			}


			if (!empty($room->original_avg_price) && is_numeric($room->original_avg_price))
			{
				$original_price[] = $room->original_avg_price;
			}
		}

		if (!empty($special_price))
		{
			$min_special_price = min($special_price);
		}


		if (!empty($original_price))
		{
			$min_original_price = min($original_price);
		}

		if (!empty($min_special_price) && $min_special_price < $min_original_price)
		{
			$accomodation->sale_price     = $min_special_price;
			$accomodation->original_price = $min_original_price;
		}
		else
		{
			$accomodation->sale_price     = 0;
			$accomodation->original_price = $min_original_price;
		}
	}
}

// Includes js and css
$doc        = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root(true) . '/modules/' . $module->module . '/assets/css/style.css');

$doc->addScript(Uri::root(true) . '/modules/' . $module->module . '/assets/js/script.js');

$moduleclass_sfx 	= ($params->get('moduleclass_sfx')) ? htmlspecialchars($params->get('moduleclass_sfx')) : '';
require ModuleHelper::getLayoutPath('mod_spbooking_accomodation', $params->get('layout'));
