<?php
/**
 * @package mod_spbooking_packages
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

class ModSpbookingAccomodationHelper
{

	public static function getAccomodations($params)
	{

		// Get item Type
		$ordering 		= $params->get('ordering', 'DESC');
		$item_type 		= $params->get('item_type', '');
		$limit 			= $params->get('limit', '6');
		$category_id	= $params->get('category_id', '');
		$country		= $params->get('country', '');
		$tags			= $params->get('tags', '');

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*');
		$query->from($db->quoteName('#__spbooking_accomodations', 'a'));
		$query->where($db->quoteName('a.published') . ' = 1');
		$query->where('a.language in (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		$query->where($db->quoteName('a.access') . " IN (" . implode(',', Factory::getUser()->getAuthorisedViewLevels()) . ")");

		if ($category_id)
		{
			$query->where($db->quoteName('a.category_id') . ' = ' . $db->quote($category_id));
		}

		if ($country)
		{
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote($country));
		}

		// Tag
		if (!empty($tags))
		{
			$query->where($db->quoteName('a.accomodation_tags') . ' IN (' . implode(',', $tags) . ')');
		}

		if ($item_type == 'discount')
		{
			// Discount code will be here
		}
		elseif ($item_type == 'featured')
		{
			$query->where($db->quoteName('a.featured') . ' = 1');
		}

		$query->order($db->quoteName('a.ordering') . $ordering);
		$query->setLimit($params->get('limit', $limit));
		$db->setQuery($query);
		$accomodations = $db->loadObjectList();

		foreach ($accomodations as &$accomodation)
		{
			$accomodation->url = Route::_('index.php?option=com_spbooking&view=accomodation&id=' . $accomodation->id . ':' . $accomodation->alias . SpBookingHelper::getItemid('accomodations'));
		}

		return $accomodations;
	}

}
