<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewTransports extends HtmlView
{
	protected $items;

	protected $pagination;

	public function display($tpl = null)
	{
		$model 			    = $this->getModel();
		$this->items		= $this->get('Items');
		$this->helper       = new SpbookingHelper;
		$this->pagination	= $this->get('Pagination');
		$this->menuItemId   = SpbookingHelper::getItemId('packages');
		$this->cParams      = ComponentHelper::getParams('com_spbooking');
		$this->columns      = $this->cParams->get('transports_columns', 3);

		// Get filter data
		$this->categories      = $this->helper->getCategories('transport');

		$this->features = array();

		// Insert data inside the array
		foreach ($this->items as &$this->item)
		{
			$this->item->url = Route::_('index.php?option=com_spbooking&view=transport&id=' . $this->item->id . ':' . $this->item->alias . SpbookingHelper::getItemid('transports'));
			$this->item->review = SpbookingHelper::calculateReview($this->item->id, 'transport');

			// Group the featrures by name
			$this->item->features     = (!empty($this->item->features) && is_string($this->item->features)) ? json_decode($this->item->features) : array();

			if (!empty($this->item->features))
			{
				foreach ($this->item->features as $feature)
				{
					if (!empty($feature->key) && $feature->key)
					{
						$hash = str_replace(' ', '-', strtolower($feature->key));
						$this->features[$hash] = $feature;
					}
				}
			}

			$this->item->thumb = SpbookingHelper::getThumbs($this->item->image, 'thumbnail', '360x348');
		}

		return parent::display($tpl = null);
	}
}

