<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewTransport extends HtmlView
{
	protected $item;

	public function display($tpl = null)
	{
		$model      = $this->getModel();
		$doc        = Factory::getDocument();
		$this->item = $this->get('Item');

		$this->cParams                  = ComponentHelper::getParams('com_spbooking');
		$this->showRatings              = $this->cParams->get('rating');
		$this->item->facilities         = (SpbookingHelper::checkIsJson($this->item->facilities)) ? json_decode($this->item->facilities) : array();
		$this->item->features           = (SpbookingHelper::checkIsJson($this->item->features)) ? json_decode($this->item->features) : array();
		$this->item->place_ids          = (SpbookingHelper::checkIsJson($this->item->place_ids)) ? json_decode($this->item->place_ids) : array();
		$this->item->gallery            = (SpbookingHelper::checkIsJson($this->item->gallery)) ? json_decode($this->item->gallery) : array();

		// $this->item->certificates       = (SpbookingHelper::checkIsJson($this->item->certificates)) ? json_decode($this->item->certificates) : $this->item->certificates;
		$this->item->reviews            = SpbookingHelper::calculateReview($this->item->id, 'transport');
		$this->item->additional_reviews = (!empty($this->item->additional_reviews) && is_string($this->item->additional_reviews)) ? json_decode($this->item->additional_reviews) : array();
		$this->item->certificates       = (!empty($this->item->certificates) && is_string($this->item->certificates)) ? json_decode($this->item->certificates) : array();
		$this->places = SpbookingHelper::getPlacesInfo($this->item->place_ids);

		$this->item->carousel_background = $this->cParams->get('transport_review_background', '');

		if (!empty($this->item->carousel_background))
		{
			$this->item->carousel_background = "background: url(" . Uri::root() . $this->item->carousel_background . ")";
		}
		else
		{
			$this->item->carousel_background = '';
		}

		$this->edit_slidershow	= $this->cParams->get('edit_slidershow_height_width','');	
		
		$this->slideShowWidth  = ($this->cParams->get('slideshow_width') && $this->edit_slidershow ? $this->cParams->get('slideshow_width') : '');	
		$this->slideShowHeight = ($this->cParams->get('slideshow_height') && $this->edit_slidershow ? $this->cParams->get('slideshow_height') : '');			
		
		$doc->addScriptDeclaration("var feedbackUrl = '" . Route::_('index.php?option=com_spbooking&task=accomodation.submitFeedback') . "';");
		$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spreview.css');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/feedback.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spreview.js');

		return parent::display($tpl = null);
	}
}

