<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;

$top_review_limit = 5;

$slideShowWidth = ($this->slideShowWidth) ? 'spbooking-col-' . $this->slideShowWidth*2 : 'spbooking-col-12';
$height			= ($this->slideShowHeight) ? $this->slideShowHeight : '';
$style  		= ($this->slideShowWidth) ? "style='margin-right:auto'" : '';
?>


<div id="spbooking" class="spbooking spbooking-view-transport spbooking-view-details">
	<div class="spbooking-container">
		<!-- package details basic information -->
		<div class="spbooking-row spbooking-align-center">
			<div class="spbooking-col-12 spbooking-col-lg-9 spbooking-details-top-left">
				<h2 class="spbooking-title"><?php echo $this->item->title; ?></h2>

				<div class="spbooking-title-bottom">
					<?php if (!empty($this->item->category_id) && !empty($this->item->category_title))
					{
						?>
						<div class="transport-location pull-left">
							<span class="text-mute"><?php echo $this->item->category_title; ?></span>
						</div>
					<?php } ?>
					<?php
					if ((!empty($this->item->category_id) && !empty($this->item->category_title)) && (!empty($this->item->person_allowed) && $this->item->person_allowed))
					{
						?>
						<span class="pull-left">&nbsp;|&nbsp;</span>
					<?php } ?>
					<?php
					if (!empty($this->item->person_allowed) && $this->item->person_allowed)
					{
						?>
						<div class="transport-location pull-left">
							<i class="fa fa-user-o"></i>&nbsp;<span class="text-mute"><?php echo $this->item->person_allowed; ?></span>
						</div>
					<?php } ?>
				</div> <!-- /.spbooking-title-bottom -->
			</div> <!-- /.spbooking-col-9 -->
			<div class="spbooking-col-12 spbooking-col-lg-3 spbooking-details-top-right">
				<!-- Adult -->
				<?php if (!empty($this->item->price) && $this->item->price != 0.00)
				{
					?>
					<div class="spbooking-price-box text-right">
						<?php if (!empty($this->item->sale_price) && $this->item->sale_price != 0.00)
						{
							?>
							<div class="original-price">
								<del class="text-mute">
									<?php echo SpbookingHelper::formatPrice($this->item->price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</del>
							</div>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->sale_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?> (<?php echo Text::_('COM_SPBOOKING_ADULT'); ?>)
							</div>
						<?php }
						else
						{
							?>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?> (<?php echo Text::_('COM_SPBOOKING_ADULT'); ?>)
							</div>
						<?php } ?>
					</div>
				<?php } ?>
				<!-- Child Price -->
				<?php if (!empty($this->item->child_price) && $this->item->child_price != 0.00)
				{
					?>
					<div class="spbooking-price-box text-right">
						<?php if (!empty($this->item->child_sale_price) && $this->item->child_sale_price != 0.00)
						{
							?>
							<div class="original-price">
								<del class="text-mute">
									<?php echo SpbookingHelper::formatPrice($this->item->child_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</del>
							</div>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->child_sale_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?>
								(<?php echo Text::_('COM_SPBOOKING_CHILD'); ?>)
							</div>
						<?php }
						else
						{
							?>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->child_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?>
								(<?php echo Text::_('COM_SPBOOKING_CHILD'); ?>)
							</div>
						<?php } ?>
					</div>
				<?php } ?>
				<div class="spbooking-top-right-bottom mt-10">
					<a href="<?php echo Uri::root() . ('index.php?option=com_spbooking&view=checkout&layout=transport&checkout_for=transport&transport_id=' . $this->item->id); ?>" class="spbooking-btn spbooking-btn-primary spbooking-btn"><?php echo Text::_('COM_SPBOOKING_COMMON_BOOK_NOW'); ?></a>
				</div> <!-- /.spbooking-top-right-bottom  -->
			</div> <!-- /.spbooking-col-3 -->
		</div>
	</div>


	<!-- package gallery -->
	<div class="spbooking-row spbooking-package-image mt-preset">
		<!-- rooms gallery -->
		<div class="transport-images <?php echo $slideShowWidth; ?>" <?php echo $style; ?>>
			<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $this->item->gallery, 'title' => $this->item->title, 'banner_image' => $this->item->image, 'modifier_class' => 'tranport-gallery', 'show_title' => false, 'height' => $height)); ?>
		</div>
	</div> <!-- /.spbooking-package-gallery -->

	<div class="spbooking-container">
		<!-- package overview -->
		<div class="spbooking-row spbooking-package-overview mt-preset">
			<?php // Generate columns
			if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) == 1)
			{
				$left_col = 6;
				$right_col = 3;
				$review_col = 3;
			}
			else
			{
				$left_col = 9;
				$right_col = 3;
				$review_col = 12;
			}
			?>
			<!-- package description -->
			<div class="spbooking-col-md-12 spbooking-col-lg-<?php echo $left_col; ?>">
				<h4 class="overview is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_OVERVIEW_TITLE'); ?></h4>
				<?php
				if (!empty($this->item->description))
				{
					?>
					<div class="description"><?php echo $this->item->description; ?></div>
				<?php } ?>
			</div>

			<!-- overall rating -->
			<?php if ($this->showRatings)
			{
				?>
			<div class="spbooking-col spbooking-col-md-6 spbooking-col-lg-<?php echo $right_col; ?>">
				<div class="overall-rating">
					<div class="spbooking-box">
						<label class="title"><?php echo Text::_('COM_SPBOOKING_PACKAGE_OVERALL_RATING'); ?></label>
						<h1 class="rating"><?php echo $this->item->reviews['average_rating']; ?><small>/5</small></h1>
						<?php
						foreach (range(1, 5) as $key => $rating)
						{
							?>
							<?php if ($rating <= $this->item->reviews['average_rating'])
							{
								?>
								<span class="fa fa-star is-filled"></span>
							<?php }
							elseif ($rating > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $rating - 1)
							{
								?>
								<span class="fa fa-star-half-o is-filled"></span>
							<?php }
							else
							{
								?>
								<span class="fa fa-star-o"></span>
							<?php } ?>
						<?php } ?>
						<p class="total-reivews"><?php echo "(" . $this->item->reviews['total_reviews'] . " " . SpbookingHelper::pluralize($this->item->reviews['total_reviews'], 'COM_SPBOOKING_TOTAL_REVIEW_TEXT', 'COM_SPBOOKING_TOTAL_REVIEWS_TEXT') . ")"; ?></p>
					</div>
				</div>
			</div> <!-- /.spbooking-col- -->
			<?php } ?>           

			<?php if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) == 1)
			{
				?>
				<div class="spbooking-col-md-6 spbooking-col-lg-<?php echo $review_col; ?> spbooking-item-certificates">
					<div class="travel-award">
						<div class="spbooking-box">
							<?php foreach ($this->item->certificates as $certificate)
							{
								?>
								<img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
							<?php } ?>
						</div>
					</div>
				</div><!-- /.spbooking-col- -->
			<?php } ?>
		</div>

		<?php if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) > 1)
		{
			?>
			<!-- package overview -->
			<div class="spbooking-row spbooking-item-certificates">
				<?php foreach ($this->item->certificates as $certificate)
				{
					?>
					<div class="spbooking-col-sm-3 mt-20">
						<img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
					</div>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if (!empty($this->item->facilities))
		{
			?>
			<!-- transport overview -->
			<div class="spbooking-row tour-overview tour-main-facilities mt-20">
				<div class="spbooking-col-12">
					<div class="spbooking-row">
						<?php foreach ($this->item->facilities as $facility)
						{
							?>
							<div class="spbooking-col-md-6 spbooking-col-lg-4 mt-20">
								<div class="spbooking-row">
									<div class="spbooking-col-2">
										<?php if (!empty($facility->icon_image))
										{
											?>
											<?php if (!empty($facility->icon) && $facility->icon_image == 'icon')
											{
												?>
												<span class="text-green <?php echo $facility->icon; ?> fa-2x"></span>
											<?php }
											elseif (!empty($facility->image) && $facility->image)
											{
												?>
												<img src="<?php echo $facility->image; ?>" alt="">
											<?php }
											else
											{
												?>
												<span class="text-green fa fa-check-square-o fa-2x"></span>
											<?php } ?>
										<?php } ?>
									</div>
									<div class="spbooking-col">
										<?php if (!empty($facility->key))
										{
											?>
											<p class="is-uppercase"><?php echo $facility->key; ?></p>
										<?php } ?>
										<?php
										if (!empty($facility->value))
										{
											?>
											<p class="text-mute"><?php echo $facility->value; ?></p>
										<?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>
					</div> <!-- /.spbooking-row -->
				</div> <!-- /.spbooking-col-12 -->
			</div> <!-- /.tour-overview -->
		<?php } ?>

		<?php if (!empty($this->item->features))
		{
			?>
			<!-- transport features -->
			<div class="spbooking-row transport-overview mt-20">
				<div class="spbooking-col-12">
					<h4 class="tour-over-view-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_TRANSPORT_FEATURES'); ?></h4>
					<div class="spbooking-row">
						<?php foreach ($this->item->features as $feature)
						{
							?>
							<div class="spbooking-col-md-6 spbooking-col-lg-4 mt-20 each-feature">
								<div class="spbooking-row">
									<div class="spbooking-col-2">
										<?php if (!empty($feature->icon_image))
										{
											?>
											<?php if (!empty($feature->icon) && $feature->icon_image == 'icon')
											{
												?>
												<span class="text-green feature-icon <?php echo $feature->icon; ?> fa-2x"></span>
											<?php }
											elseif (!empty($feature->image) && $feature->image)
											{
												?>
												<img src="<?php echo $feature->image; ?>" alt="">
											<?php }
											else
											{
												?>
												<span class="text-green feature-icon fa fa-check-square-o fa-2x"></span>
											<?php } ?>
										<?php } ?>
									</div>
									<div class="spbooking-col">
										<?php if (!empty($feature->key))
										{
											?>
											<p class="is-uppercase"><?php echo $feature->key; ?></p>
										<?php } ?>
										<?php
										if (!empty($feature->value))
										{
											?>
											<p class="text-mute"><?php echo $feature->value; ?></p>
										<?php } ?>
									</div>
								</div> <!-- /.spbooking-row -->
							</div>
						<?php } ?>
					</div> <!-- /.spbooking-row -->
				</div> <!-- /.spbooking-col- -->
			</div> <!-- /.tour-overview -->
		<?php } // Has features
		?>
	</div>

	<?php if (!empty($this->places))
	{
		?>
		<div class="transport-places mt-20">
			<div class="spbooking-container">
				<h3><?php echo Text::_('COM_SPBOOKING_COMMON_PLACES'); ?></h3>
			</div>
			<div class="spbooking-row">
				<?php foreach ($this->places as $place)
				{
					?>
					<div class="spbooking-col-md-4 mt-20">
						<div class="transport-place" style="background-image: url(<?php echo $place->image; ?>);">
							<a class="full-link" href="<?php echo $place->url; ?>"></a>
							<div class="transport-place-caption">
								<?php if ($place->title)
								{
									?>
									<a href="<?php echo $place->url; ?>">
										<h4><?php echo $place->title; ?></h4>
									</a>
								<?php } ?>
							</div>
						</div>
					</div>
				<?php } ?>
			</div> <!-- /.spbooking-row" -->
		</div> <!-- /.transport-places -->
	<?php } ?>

	<?php if ((!empty($this->item->reviews['top_rating']) || !empty($this->item->additional_reviews)) && $this->showRatings)
	{
		?>
		<!-- review slider carousel -->
		<div class="spbooking-row mt-preset spbooking-item-review-wrap">
			<div class="spbooking-col carousel-background" style="<?php echo $this->item->carousel_background; ?>">
				<!-- top review carousel -->
				<?php if (!empty($this->item->reviews['top_rating']))
				{
					?>
					<div class="top-reviews-carousel owl-carousel">
						<?php foreach ($this->item->reviews['top_rating'] as $key => $rating)
						{
							?>
							<?php if ($key < $top_review_limit)
							{
								?>
								<div class="content-container">
									<?php if (!empty($rating->review))
									{
										?>
										<blockquote class="blockquote">
											<p class="mb-0"><?php echo "\"" . $rating->review . "\""; ?></p>
											<?php
											if (!empty($rating->user_name))
											{
												?>
												<footer class="blockquote-footer"><?php echo $rating->user_name; ?></footer>
											<?php } ?>
										</blockquote>
									<?php } ?>

									<?php if (!empty($rating->inner_rating))
									{
										?>
										<?php foreach (range(1, 5) as $index)
										{
											?>
											<?php if ($index <= $rating->inner_rating)
											{
												?>
												<span class="fa fa-star is-filled"></span>
											<?php }
											elseif ($index > $rating->inner_rating && $rating->inner_rating > $index - 1)
											{
												?>
												<span class="fa fa-star-half-o is-filled"></span>
											<?php }
											else
											{
												?>
												<span class="fa fa-star-o"></span>
											<?php } ?>
										<?php } ?>
									<?php } ?>
								</div>
							<?php } ?>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if (!empty($this->item->additional_reviews))
				{
					?>
					<!-- additional review -->
					<div class="additional-review mt-20">
						<?php foreach ($this->item->additional_reviews as $ad_review)
						{
							?>
							<div class="review-wrapper">
								<?php if (!empty($ad_review->rating))
								{
									?>
									<h1><strong><?php echo $ad_review->rating; ?></strong><small>/5</small></h1>
								<?php } ?>
								<?php
								if (!empty($ad_review->rating))
								{
									?>
									<?php foreach (range(1, 5) as $index)
									{
										?>
										<?php if ($index <= $ad_review->rating)
										{
											?>
											<span class="fa fa-star is-filled"></span>
										<?php }
										elseif ($index > $ad_review->rating && $ad_review->rating > $index - 1)
										{
											?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php }
										else
										{
											?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
								<?php } ?>
								<?php
								if (!empty($ad_review->image))
								{
									?>
									<img src="<?php echo $ad_review->image; ?>" alt="<?php echo $ad_review->provider; ?>">
								<?php }
								else
								{
									?>
									<p><strong><?php echo $ad_review->provider; ?></strong></p>
								<?php } ?>
							</div>
						<?php } ?>

						<!-- award certifications -->
						<?php if (!empty($this->item->certificates))
						{
							?>
							<?php foreach ($this->item->certificates as $certificate)
							{
								?>
								<div class="review-wrapper">
									<?php if (!empty($certificate->image))
									{
										?>
										<img src="<?php echo Uri::root() . $certificate->image; ?>" alt="" width="100" height="100">
									<?php } ?>
								</div>
							<?php } ?>
						<?php } ?>

						<!-- customer review  -->
						<div class="review-wrapper">
							<h1 class="rating"><strong><?php echo $this->item->reviews['average_rating']; ?></strong><small>/5</small></h1>
							<?php
							foreach (range(1, 5) as $key => $rating)
							{
								?>
								<?php if ($rating <= $this->item->reviews['average_rating'])
								{
									?>
									<span class="fa fa-star is-filled"></span>
								<?php }
								elseif ($rating > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $rating - 1)
								{
									?>
									<span class="fa fa-star-half-o is-filled"></span>
								<?php }
								else
								{
									?>
									<span class="fa fa-star-o"></span>
								<?php } ?>
							<?php } ?>
							<p><strong><?php echo Text::_('COM_SPBOOKING_CUSTOMER_REVIEW'); ?></strong></p>
						</div> <!-- /.review-wrapper -->
					</div> <!-- /.additional-review -->
				<?php } // !empty($this->item->additional_review)
				?>
			</div> <!-- /.spbooking-col -->
		</div> <!-- /.spbooking-item-review-wrap -->
	<?php } // Is top rating or additional review
	?>

	<div class="spbooking-container">
		<?php if (!empty($this->item->reviews['reviews']))
		{
			?>
			<!-- user comments -->
			<div class="spbooking-row accomodation-user-comments">
				<div class="spbooking-col-12">
					<label class="user-comments-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_USER_COMMENTS') . " (" . $this->item->reviews['total_reviews'] . ")"; ?></label>
					<ul class="user-comment-list list-group">
						<?php foreach ($this->item->reviews['reviews'] as $comment)
						{
							?>
							<li class="user-comment-item list-group-item">
								<div class="comment-header">
									<img class="img-round" src="<?php echo Uri::root() . 'components/com_spbooking/assets/images/default.png'; ?>" alt="">
									<p class='user-name'><?php echo $comment->user_name; ?></p>
									<small class="comment-date text-mute"><?php echo HTMLHelper::_('date', $comment->created, 'jS M, Y'); ?></small>
								</div>
								<?php if (!empty($comment->review))
								{
									?>
									<div class="comment-body mt-10">
										<p><?php echo $comment->review; ?></p>
									</div>
								<?php } ?>

								<?php if (!empty($comment->inner_rating) && $this->showRatings)
								{
									?>
									<?php foreach (range(1, 5) as $index)
									{
										?>
										<?php if ($index <= $comment->inner_rating)
										{
											?>
											<span class="fa fa-star is-filled"></span>
										<?php }
										elseif ($index > $comment->inner_rating && $comment->inner_rating > $index - 1)
										{
											?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php }
										else
										{
											?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
									<strong><?php echo $comment->inner_rating; ?></strong>
								<?php } ?>

							</li>
						<?php } ?>
					</ul>
				</div>
			</div>
		<?php } ?>

		<!-- give feedback form -->
		<!-- if review enabled -->
		<?php if (!empty($this->cParams->get('review', 1)))
		{
			$review_categories_feedback = SpbookingHelper::getReviewOptions(array('safty_security' => 'Safety and Security', 'maintenance' => 'Maintenance', 'cleanliness' => 'Cleanliness', 'service' => 'Service', 'hospitality' => 'Hospitality'));
			?>
			<!-- if guest review disabled -->
			<?php if ($this->cParams->get('guest_review', 0) == 0)
			{
				?>
				<!-- if user logged in -->
				<?php if (Factory::getUser()->id > 0)
				{
					?>
					<div class="spbooking-row user-feedback">
						<div class="spbooking-col-sm-12">
							<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
							<form action="#" class="feedback-form" id="feedback-form">
								<div class="feedback-first-formgroup">
									<div class="form-group overall-rating">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

										<?php foreach (range(1, 5) as $index)
										{
											?>
											<?php if ($index <= $this->item->reviews['average_rating'])
											{
												?>
												<span class="fa fa-star is-filled"></span>
											<?php }
											elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1)
											{
												?>
												<span class="fa fa-star-half-o is-filled"></span>
											<?php }
											else
											{
												?>
												<span class="fa fa-star-o"></span>
											<?php } ?>
										<?php } ?>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
										<ul class="review-categories-list">
											<?php foreach ($review_categories_feedback as $k => $value)
											{
												?>
											<li class="review-list-item" >
												<span class="review-list-item-title" data-alias="<?php echo $k; ?>"><?php echo $value; ?> </span>
												<input type="hidden" name="review_categories[]" value="<?php echo $k; ?>">
											</li>
											<?php } ?> 
										</ul>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
										<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
									</div>
								</div>

								<div class="feedback-second-formgroup">
									<div class="form-row form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
										<div class="group-row">
											<div class="row">
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
												<div class="col">
													<div class="reserve-box">
														<input type="hidden" name="transport_id" value="<?php echo $this->item->id; ?>">
														<input type="hidden" name="review_for" value="transport">
													</div>

													<div class="form-group submit-button-wrap">
														<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
													</div>
												</div>
											</div>
										</div>
									</div>
							</form>
						</div>
					</div>
				<?php }
				else
				{
					?>
					<p class="login-message">
						<?php $link = base64_encode(Route::_('index.php?option=com_spbooking&view=transport&id=' . $this->item->id . SpbookingHelper::getItemid('transports'))); ?>
						<?php $login_link = Route::_('index.php?option=com_users&view=login' . SpbookingHelper::getItemid('login') . '&return=' . $link); ?>
						<?php echo Text::sprintf('COM_SPBOOKING_LOGIN_FOR_FEEDBACK', $login_link); ?>
					</p>
				<?php } ?>
			<?php }
			else
			{
				?>
				<!-- if guest review allowed -->
				<div class="spbooking-row user-feedback">
					<div class="spbooking-col-sm-12">
						<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
						<form action="#" class="feedback-form" id="feedback-form">
							<div class="feedback-first-formgroup">
								<div class="form-group overall-rating">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

									<?php foreach (range(1, 5) as $index)
									{
										?>
										<?php if ($index <= $this->item->reviews['average_rating'])
										{
											?>
											<span class="fa fa-star is-filled"></span>
										<?php }
										elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1)
										{
											?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php }
										else
										{
											?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
									<ul class="review-categories-list">
										<?php foreach ($review_categories_feedback as $rcfk => $value)
										{
											?>
										<li class="review-list-item" >
											<span class="review-list-item-title" data-alias="<?php echo $rcfk; ?>"><?php echo $value; ?> </span>
											<input type="hidden" name="review_categories[]" value="<?php echo $rcfk; ?>">
										</li>
										<?php } ?>
									</ul>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
									<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
								</div>
							</div>

							<div class="feedback-second-formgroup">
								<div class="form-row form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
									<div class="group-row">
										<div class="row">
											<?php if (Factory::getUser()->id > 0)
											{
												?>
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
											<?php }
											else
											{
												?>
												<div class="col-md-6">
													<input type="text" class="form-control" name="user_name" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_NAME'); ?>">
												</div>
												<div class="col-md-6">
													<input type="email" class="form-control" name="user_email" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_EMAIL'); ?>">
												</div>
											<?php } ?>
											<div class="col">
												<div class="reserve-box">
													<input type="hidden" name="transport_id" value="<?php echo $this->item->id; ?>">
													<input type="hidden" name="review_for" value="transport">
												</div>

												<div class="form-group submit-button-wrap">
													<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
												</div>
											</div>
										</div>
									</div>
								</div>
						</form>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>

</div>
