<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewPlaces extends HtmlView
{
	protected $items;

	protected $pagination;

	public function display($tpl = null)
	{
		$model 			    = $this->getModel();
		$this->helper       = new SpbookingHelper;
		$this->items		= (!empty($this->get('Items')) ? $this->get('Items') : array());
		$this->pagination	= $this->get('Pagination');
		$this->menuItemId   = SpbookingHelper::getItemId('places');
		$this->cParams      = ComponentHelper::getParams('com_spbooking');
		$this->columns      = $this->cParams->get('places_columns', 2);

		// Get filter data
		$this->tags         = $this->helper->getItemTags('place');
		$this->categories   = $this->helper->getCategories('place');

		// Insert data inside the array
		foreach ($this->items as $item)
		{
			$item->url = Route::_('index.php?option=com_spbooking&view=place&id=' . $item->id . ':' . $item->alias . SpbookingHelper::getItemid('places'));
			$item->review = SpbookingHelper::calculateReview($item->id, 'place');
			$item->thumb = SpbookingHelper::getThumbs($item->image, 'large', '650x410');
		}

		return parent::display($tpl = null);
	}
}

