<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

?>

<div id="sp-booking-packages" class="spbooking-view-pakcages spbooking-view-places spbooking">
	<!-- spbooking-pakcages-list -->
	<div class="spbooking-pakcages-list">
		<div class="spbooking-item-filter">
				<?php echo LayoutHelper::render('places.filter'); ?>
			</div> <!-- /.spbooking-item-filter -->
		<div class="spbooking-row">
			<!-- contents column -->
			<div class="spbooking-col-md-12">
				<!-- accomodation contents container -->
				<div class="package-contents">
					<!-- if $this->items has value -->
					<?php if (!empty($this->items))
					{
						?>
						<?php echo LayoutHelper::render('places.grid.listing', array('places' => $this->items, 'columns' => $this->columns)); ?>
					<?php }
					else
					{
						?>
						<div class="spbooking-empty-item">
							<p><?php echo Text::sprintf('COM_SPBOOKING_NO_ITEM_FOUND', Text::_('COM_SPBOOKING_PLACES')); ?></p>
						</div>
					<?php } ?>
				</div>
				<!-- pagination  -->
				<?php if ($this->pagination->pagesTotal > 1)
				{
					?>
					<div class="pagination">
						<?php echo $this->pagination->getPagesLinks(); ?>
					</div>
				<?php } ?>
			</div> <!-- /.spbooking-col-sm-8" -->
		</div> <!-- /.spbooking-row -->
	</div>  <!-- spbooking-pakcages-list -->
</div> <!-- /.spbooking-view-pakcages -->
