<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewPlace extends HtmlView
{
	protected $item;
	public function display($tpl = null)
	{
		$model      = $this->getModel();
		$doc = Factory::getDocument();
		$this->helper           = new SpbookingHelper;
		$this->item             = $this->get('Item');
		$this->item->reviews    = SpbookingHelper::calculateReview($this->item->id, 'place');
		$this->cParams          = ComponentHelper::getParams('com_spbooking');
		$this->showRatings      = $this->cParams->get('rating');
		$this->item->tags       = $this->helper->getTagsInfo($this->item->place_tags, 'places');
		$this->tags_title = array();

		foreach ($this->item->tags as &$this->item->tag)
		{
			$this->tags_title[$this->item->tag->id] = '<a href="' . $this->item->tag->url . '">' . $this->item->tag->title . '</a>';
		}

		$this->video_thumb = '';

		if (!empty($this->item->video) && filter_var($this->item->video, FILTER_VALIDATE_URL))
		{
			// Video parse
			$video = parse_url($this->item->video);

			switch ($video['host'])
			{
				case 'youtu.be':
					$id = trim($video['path'], '/');
					$this->video_thumb = "https://i3.ytimg.com/vi/{$id}/maxresdefault.jpg";
					$this->item->videosrc = '//www.youtube.com/embed/' . $id;
				break;

				case 'www.youtube.com':
				case 'youtube.com':
					parse_str($video['query'], $query);
					$id = $query['v'];
					$this->video_thumb = "https://i3.ytimg.com/vi/{$id}/maxresdefault.jpg";
					$this->item->videosrc = '//www.youtube.com/embed/' . $id;
				break;

				case 'vimeo.com':
				case 'www.vimeo.com':
					$id = trim($video['path'], '/');
					$vimeo = unserialize(file_get_contents("http://vimeo.com/api/v2/video/{$id}.php"));
					$this->video_thumb = $vimeo[0]['thumbnail_large'];
					$this->item->videosrc = "//player.vimeo.com/video/{$id}";
				break;
			}
		}

		$doc->addScriptDeclaration("var feedbackUrl = '" . Route::_('index.php?option=com_spbooking&task=accomodation.submitFeedback') . "';");
		$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spreview.css');
		$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/prettyPhoto.css');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/feedback.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spreview.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/jquery.prettyPhoto.js');

		return parent::display($tpl = null);
	}
}

