<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

$top_review_limit = 5;

?>


<div id="spbooking" class="spbooking spbooking-view-place spbooking-view-details">
	<div class="spbooking-container">
		<!-- package details basic information -->
		<div class="spbooking-row spbooking-align-center">
			<div class="spbooking-col-12 spbooking-text-center">
				<h2 class="spbooking-title"><?php echo $this->item->title; ?></h2>

				<div class="spbooking-title-bottom">
					<?php if (!empty($this->item->location))
					{
						?>
						<div class="spbooking-title-bottom-text location">
							<span class="text-mute"><?php echo $this->item->location; ?></span>
						</div>
					<?php } ?>
					<?php
					if (!empty($this->item->tags) && !empty($this->tags_title))
					{
						?>
						<div class="spbooking-title-bottom-text tag-tile">
							<span><?php echo implode(', ', $this->tags_title); ?></span>
						</div>
					<?php } ?>
				</div> 
				<?php if ($this->showRatings)
				{
					?>
				<div class="total-rating">
					<span class="rating"><?php echo $this->item->reviews['average_rating']; ?><small>/5</small></span>
					<?php
					foreach (range(1, 5) as $key => $rating)
					{
						?>
						<?php if ($rating <= $this->item->reviews['average_rating'])
						{
							?>
							<span class="fa fa-star is-filled"></span>
						<?php }
						elseif ($rating > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $rating - 1)
						{
							?>
							<span class="fa fa-star-half-o is-filled"></span>
						<?php }
						else
						{
							?>
							<span class="fa fa-star-o"></span>
						<?php } ?>
					<?php } ?>
					<p class="total-reivews"><?php echo "(" . $this->item->reviews['total_reviews'] . " " . SpbookingHelper::pluralize($this->item->reviews['total_reviews'], 'COM_SPBOOKING_TOTAL_REVIEW_TEXT', 'COM_SPBOOKING_TOTAL_REVIEWS_TEXT') . ")"; ?></p>
				</div>
				<?php } ?>                

				<!-- Contact Info -->
				<div class="spbooking-container place-contact-info">
					<div class="spbooking-right-info-box">
						<?php if (!empty($this->item->web) && !empty($this->item->web))
						{
							?>
							<div class="spbooking-title-right-info">
								<i class="fa fa-globe" aria-hidden="true"></i> <span><?php echo $this->item->web; ?></span>
							</div>
						<?php }?>
						<?php
						if (!empty($this->item->email) && !empty($this->item->email))
						{
							?>
							<div class="spbooking-title-right-info">
								<i class="fa fa-envelope" aria-hidden="true"></i> <span><?php echo $this->item->email; ?></span>
							</div>
						<?php }?>
						<?php
						if (!empty($this->item->phone) && !empty($this->item->phone))
						{
							?>
							<div class="spbooking-title-right-info">
								<i class="fa fa-phone" aria-hidden="true"></i> <span><?php echo $this->item->phone; ?></span>
							</div>
						<?php }?>
					</div>
				</div>
			</div> <!-- /.spbooking-col-12 -->
		</div>
	</div>


	<!-- package gallery -->
	<div class="spbooking-row spbooking-details-image mt-preset">
		<!-- rooms gallery -->
		<div class="spbooking-col-12">
			<?php if (!empty($this->item->gallery))
			{
				?>
				<div class="owl-carousel room-gallery owl-theme">
					<?php foreach (json_decode($this->item->gallery) as $image)
					{
						?>
						<div class="image-holder">
							<img src="<?php echo Uri::root() . $image->image; ?>" alt="<?php echo $image->alt_text; ?>">
						</div>
					<?php } ?>
				</div>
			<?php }
			elseif ($this->item->image)
			{
				?>
				<div class="spbooking-image-wrap">
					<img src="<?php echo $this->item->image; ?>" alt="<?php echo $this->item->title; ?>">
				</div>
			<?php } ?>
		</div>
	</div> <!-- /.spbooking-package-gallery -->

	<div class="spbooking-container">
		<!-- package overview -->
		<div class="spbooking-row spbooking-package-overview mt-preset">
			<!-- package description -->
			<div class="spbooking-col-md-12 spbooking-col-lg-12">
				<?php if (!empty($this->item->description))
				{
					?>
					<div class="description"><?php echo $this->item->description; ?></div>
				<?php } ?>
			</div>
		</div>
	</div>

	<!-- video section -->
	<div class="spbooking-row">
		<div class="spbooking-col-12">
			<?php if (!empty($this->item->video))
			{
				?>
				<div class="video-thumbnails" style="background-image:url(<?php echo $this->video_thumb; ?>);">
					<a href="<?php echo $this->item->video . '&width=1000&height=500'; ?>" class="" rel="prettyPhoto" title="video">
						<div class="play-circle"><span class="fa fa-play"></span></div>    
					</a>
				</div>
			<?php } ?>
		</div>
	</div>

	<div class="spbooking-container">
		<?php if (!empty($this->item->reviews['reviews']))
		{
			?>
			<!-- user comments -->
			<div class="spbooking-row accomodation-user-comments">
				<div class="spbooking-col-12">
					<label class="user-comments-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PACKAGE_USER_COMMENTS') . " (" . $this->item->reviews['total_reviews'] . ")"; ?></label>
					<ul class="user-comment-list list-group">
						<?php foreach ($this->item->reviews['reviews'] as $comment)
						{
							?>
							<li class="user-comment-item list-group-item">
								<div class="comment-header">
									<img class="img-round" src="<?php echo Uri::root() . 'components/com_spbooking/assets/images/default.png';?>" alt="">
									<p class='user-name'><?php echo $comment->user_name; ?></p>
									<small class="comment-date text-mute"><?php echo HTMLHelper::_('date', $comment->created, 'jS M, Y'); ?></small>
								</div>
								<?php if (!empty($comment->review))
								{
									?>
									<div class="comment-body mt-10">
										<p><?php echo $comment->review; ?></p>
									</div>
								<?php } ?>

								<?php if (!empty($comment->inner_rating) && $this->showRatings)
								{
									?>
									<?php foreach (range(1, 5) as $index)
									{
										?>
										<?php if ($index <= $comment->inner_rating)
										{
											?>
											<span class="fa fa-star is-filled"></span>
										<?php }
										elseif ($index > $comment->inner_rating && $comment->inner_rating > $index - 1)
										{
											?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php }
										else
										{
											?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
									<strong><?php echo $comment->inner_rating; ?></strong>
								<?php } ?>

							</li>
						<?php } ?>
					</ul>
				</div>
			</div>
		<?php } ?>

		<!-- give feedback form -->
		<!-- if review enabled -->
		<?php if (!empty($this->cParams->get('review', 1)))
		{
			$review_categories_feedback = SpbookingHelper::getReviewOptions(array('safty_security' => 'Safety and Security', 'maintenance' => 'Maintenance', 'cleanliness' => 'Cleanliness', 'service' => 'Service', 'hospitality' => 'Hospitality'));
			?>
			<!-- if guest review disabled -->
			<?php if ($this->cParams->get('guest_review', 0) == 0)
			{
				?>
				<!-- if user logged in -->
				<?php if (Factory::getUser()->id > 0)
				{
					?>
					<div class="spbooking-row user-feedback">
						<div class="spbooking-col-sm-12">
							<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
							<form action="#" class="feedback-form" id="feedback-form">
								<div class="feedback-first-formgroup">
									<div class="form-group overall-rating">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

										<?php foreach (range(1, 5) as $index)
										{
											?>
											<?php if ($index <= $this->item->reviews['average_rating'])
											{
												?>
												<span class="fa fa-star is-filled"></span>
											<?php }
											elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1)
											{
												?>
												<span class="fa fa-star-half-o is-filled"></span>
											<?php }
											else
											{
												?>
												<span class="fa fa-star-o"></span>
											<?php } ?>
										<?php } ?>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
										<ul class="review-categories-list">
										<?php foreach ($review_categories_feedback as $k => $value)
										{
											?>
											<li class="review-list-item" >
												<span class="review-list-item-title" data-alias="<?php echo $k; ?>"><?php echo $value; ?> </span>
												<input type="hidden" name="review_categories[]" value="<?php echo $k; ?>">
											</li>
										<?php } ?> 
										</ul>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
										<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
									</div>
								</div>

								<div class="feedback-second-formgroup">
									<div class="form-row form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
										<div class="group-row">
											<div class="row">
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>" >
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>" >
											<div class="col">
												<div class="reserve-box">
													<input type="hidden" name="place_id" value="<?php echo $this->item->id; ?>">
													<input type="hidden" name="review_for" value="place">
												</div>

												<div class="form-group submit-button-wrap">
													<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
												</div>
											</div>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				<?php }
				else
				{
					?>
					<p class="login-message">
						<?php $link = base64_encode(JRoute::_('index.php?option=com_spbooking&view=place&id=' . $this->item->id . SpbookingHelper::getItemid('places'))); ?>
						<?php $login_link = Route::_('index.php?option=com_users&view=login' . SpbookingHelper::getItemid('login') . '&return=' . $link); ?>
						<?php echo Text::sprintf('COM_SPBOOKING_LOGIN_FOR_FEEDBACK', $login_link); ?>
					</p>
				<?php } ?>
			<?php }
			else
			{
				?>
				<!-- if guest review allowed -->
				<div class="spbooking-row user-feedback">
					<div class="spbooking-col-sm-12">
						<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
						<form action="#" class="feedback-form" id="feedback-form">
							<div class="feedback-first-formgroup">
								<div class="form-group overall-rating">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

									<?php foreach (range(1, 5) as $index)
									{
										?>
										<?php if ($index <= $this->item->reviews['average_rating'])
										{
											?>
											<span class="fa fa-star is-filled"></span>
										<?php }
										elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1)
										{
											?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php }
										else
										{
											?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
									<ul class="review-categories-list">
										<?php foreach ($review_categories_feedback as $rcfk => $value)
										{
											?>
										<li class="review-list-item" >
											<span class="review-list-item-title" data-alias="<?php echo $rcfk; ?>"><?php echo $value; ?> </span>
											<input type="hidden" name="review_categories[]" value="<?php echo $rcfk; ?>">
										</li>
										<?php } ?>                                                  
									</ul>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
									<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
								</div>
							</div>

							<div class="feedback-second-formgroup">
								<div class="form-row form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
									<div class="group-row">
										<div class="row">
											<?php if (Factory::getUser()->id > 0)
											{
												?>
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>" >
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>" >
											<?php }
											else
											{
												?>
												<div class="col-md-6">
													<input type="text" class="form-control" name="user_name" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_NAME'); ?>">
												</div>
												<div class="col-md-6">
													<input type="email" class="form-control" name="user_email" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_EMAIL'); ?>">
												</div>
											<?php } ?>
										<div class="col">
											<div class="reserve-box">
												<input type="hidden" name="place_id" value="<?php echo $this->item->id; ?>">
												<input type="hidden" name="review_for" value="place">
											</div>

											<div class="form-group submit-button-wrap">
												<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
											</div>
										</div>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>

</div>
