<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
require_once JPATH_ROOT . '/components/com_spbooking/assets/vendor/autoload.php';

use Stripe\Stripe;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Stripe\Checkout\Session;
use Joomla\CMS\Language\Text;
use Stripe\Exception\ApiErrorException;

?>

<div class="spbooking spbooking-payment">
	<!-- display invoice  -->
	<?php if (!empty($this->item))
	{
		?>
		<div class="spbooking-row">
			<div class="spbooking-col-12">
				<table class="table table-bordered">
					<thead>
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_PAYMENT_INFO'); ?></th>
							<th><?php echo Text::_('COM_SPBOOKING_ROOM_PRICE'); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								<?php if (!empty($this->item->transport->title))
								{
									?>
									<p class="spbooking-title"><?php echo $this->item->transport->title; ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->adult))
								{
									?>
									<p class="text-mute">
										<?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->child))
								{
									?>
									<p class="text-mute">
										<?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->pickup_location))
								{
									?>
									<p class="text-mute">
										<?php echo Text::_('COM_SPBOOKING_PAYMENT_PICKUP_LOCATION') . ': ' . $this->item->cartData->pickup_location . "(" . $this->item->cartData->pickup_date . " " . $this->item->cartData->pickup_time . ")"; ?>
									</p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->dropoff_location))
								{
									?>
									<p class="text-mute">
										<?php echo Text::_('COM_SPBOOKING_PAYMENT_DROPOFF_LOCATION') . ': ' . $this->item->cartData->dropoff_location . "(" . $this->item->cartData->dropoff_date . " " . $this->item->cartData->dropoff_time . ")"; ?>
									</p>
								<?php } ?>
							</td>
							<td>
								<!-- Adult -->
								<?php if (!empty($this->item->cartData->sale_price))
								{
									?>
									<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></del>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->sale_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>) X <?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
								<?php }
								else
								{
									?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>) X <?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
								<?php } ?>
								<br>
								<!-- Child -->
								<?php
								if ($this->item->cartData->child > 0)
								{
									if (!empty($this->item->cartData->child_sale_price))
									{
										?>
										<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></del>
										<br>
										<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_sale_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?>) X <?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
									<?php }
									else
									{
										?>
										<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') ?>) X <?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
										<?php
									}
								} ?>

							</td>
						</tr>
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_CHECKOUT_SUBTOTAL'); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?>
							</td>
						</tr>
						<!-- Tax -->
						<tr>
							<th><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->tax, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
							</td>
						</tr>
						<tr>
							<th><?php echo Text::sprintf('COM_SPBOOKING_CHECKOUT_TOTAL', $this->item->tax); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->total, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	<?php }
	else
	{
		?>
		<div class="alert alert-danger fade show text-center">
			<strong>Error</strong>
			<p><?php echo Text::_('COM_SPBOOKING_INVOICE_ERROR'); ?></p>
		</div>
	<?php }; ?>

	<!-- payment form -->
	<div class="payment-option mt-30">
		<h4 class="spbooking-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PAYMENT_TITLE'); ?></h4>

		<div class="spbooking-box">

			<!-- Stripe Button -->
			<?php if ((is_array($this->payment_method) && in_array('stripe', $this->payment_method)))
			{
				$input_checked = ($this->params->get('payment_method') == 'stripe') ? "checked='checked'" : '';
				?>
					<div class="custom-control custom-radio custom-control-inline">
						<input type="radio" id="stripe" name="payment-method" class="custom-control-input" value="stripe">
						<label class="custom-control-label" for="stripe">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_STRIPE'); ?>
						</label>
					</div>

			<?php } ?>
			<!-- Stripe Button End -->

			<?php if ((is_array($this->payment_method) && in_array('paypal', $this->payment_method)))
			{
				?>
				<div class="custom-control custom-radio custom-control-inline text-left">
					<input type="radio" id="paypal" name="payment-method" class="custom-control-input" value="paypal" checked>
					<label class="custom-control-label" for="paypal">
						<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYPAL'); ?>
					</label>
				</div>
			<?php } ?>

			<?php if ((is_array($this->payment_method) && in_array('paylater', $this->payment_method)))
			{
				$input_checked = ($this->params->get('payment_method') == 'paylater') ? "checked='checked'" : ''; ?>
					<div class="custom-control custom-radio custom-control-inline">
						<input type="radio" id="paylater" name="payment-method" class="custom-control-input" value="paylater">
						<label class="custom-control-label" for="paylater">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYLATER'); ?>
						</label>
					</div>

			<?php } ?>

		</div>

		<div class="reserve-box">
			<input type="hidden" name="paypal_paid" class="paypal-paid" value="<?php echo $this->total; ?>">
			<input type="hidden" name="paylater_paid" class="paylater-paid" value="0">
			<input type="hidden" name="booked_id" value="<?php echo $this->booked_id; ?>">
			<input type="hidden" name="pay_for" value="transport">
		</div>
		<div class="spbooking-row mt-20">
			<!-- term and condition -->
			<div class="spbooking-col-6">
				<div class="custom-control custom-checkbox">
					<input type="checkbox" class="custom-control-input" id="payment_tac" name="payment_tac" required>
					<label class="custom-control-label" for="payment_tac"><?php echo Text::_('COM_SPBOOKING_PAYMENT_TAC_TEXT'); ?></label>
				</div>
			</div>

			<!-- proceed -->
			<div class="spbooking-col-6">
				<?php if (is_array($this->payment_method) && in_array('paypal', $this->payment_method))
				{
					if ($this->params->get('shop_environment') == 'sandbox')
					{
						$action = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
					}
					else
					{
						$action = 'https://www.paypal.com/cgi-bin/webscr';
					}

					$user_email = ($this->item->email) ? $this->item->email : $this->user->email;
					$user_name = !empty($this->item->name) ? $this->item->name : $this->user->name;
					?>
					<form action="<?php echo $action; ?>" method="post" class="pull-right spbooking-paypal-form spbooking-payment-method payment-method-paypal">
						<input type="hidden" name="cmd" value="_cart">
						<input type="hidden" name="upload" value="1">
						<input type="hidden" name="business" value="<?php echo $this->params->get('paypal_id'); ?>">
						<div id="item_<?php echo $this->transport_id; ?>" class="itemwrap">
							<input type="hidden" name="item_name_1" value="<?php echo $this->item->transport->title; ?>">
							<input type="hidden" name="item_number_1" value="<?php echo $this->transport_id; ?>">
							<input type="hidden" name="quantity_1" value="1">
							<input type="hidden" name="amount_1" value="<?php echo $this->total; ?>">
						</div>
						<input type="hidden" name="invoice" value="<?php echo $this->booked_id; ?>">
						<input type="hidden" name="custom" value='<?php echo json_encode(array('userid' => $this->user->id, 'order_type' => 'transport', 'itemid' => $this->item->id, 'useremail' => $user_email, 'username' => $user_name)); ?>'>
						<input type="hidden" name="currency_code" value="<?php echo $this->currency[0]; ?>">
						<input type="hidden" name="notify_url" value="<?php echo $this->notify_url; ?>" />
						<input type="hidden" name="return" value="<?php echo $this->return_success; ?>" />
						<input type="hidden" name="cancel_return" value="<?php echo $this->return_cencel; ?>" />
						<button type="submit" class="spbooking-btn spbooking-btn-primary paypal-submit-btn" disabled="disabled" name="submit"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?>
						</button>
					</form>
				<?php } ?>

				<?php if (is_array($this->payment_method) && in_array('paylater', $this->payment_method))
				{
					$button_hide = 'style="display: none";';
					$username = !empty($this->item->name) ? $this->item->name : '';
					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$item_title = $this->item->transport->title;
					$cartdata = base64_encode(serialize(array('order_type' => 'transport', 'item_title' => $item_title, 'itemid' => $this->item->id, 'booked_id' => $this->booked_id, 'userid' => $this->user->id, 'useremail' => $user_email, 'username' => $username, 'payment_type' => 'paylater')));
					?>
					<div class="spbooking-payment-method payment-method-paylater pull-right" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $this->paylater_url . '&cdata=' . $cartdata; ?>" class="spbooking-btn spbooking-btn-primary paylater-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>

				<!-- Stripe -->
				<?php if (is_array($this->payment_method) && in_array('stripe', $this->payment_method))
				{
					$button_hide = 'style="display: none";';

					Stripe::setApiKey($this->params->get('stripe_key'));

					$username = !empty($this->item->name) ? $this->item->name : '';
					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;

					$line_item = array();

					$price = $this->subtotal * 100;

					$line_item =
						[
							[
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => ucwords($this->item->transport->title),
										'description'   => $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ' ' . (isset($this->item->cartData->child) ? $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') : '')
									],
									'unit_amount' => $price,
								],
								'quantity' => 1,
							],
							[
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => Text::_('COM_SPBOOKING_TAX_TEXT'),
									],
									'unit_amount' => (float) $this->tax * 100,
								],
								'quantity' => 1,
							]
						];

					try
					{
						$checkout_session = Session::create([
							'line_items'    => $line_item,
							'metadata'      => array(
								'order_type'    => 'transport',
								'item_title'    => $this->item->transport->title,
								'itemid'        => $this->item->id,
								'booked_id'     => $this->booked_id,
								'userid'        => $this->user->id,
								'useremail'     => $user_email,
								'username'      => $username,
								'payment_type'  => 'stripe',
								'payment_amount' => $this->total
							),
							'mode'          => 'payment',
							'success_url'   => Uri::base() . 'index.php?option=com_spbooking&task=payment.stripeSuccess&session_id={CHECKOUT_SESSION_ID}',
							'cancel_url'    => $this->return_cencel,
							]
						);
					}
					catch (ApiErrorException $e)
					{
						return Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
					}

					?>
					<div class="spbooking-payment-method payment-method-stripe pull-right mt-10" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $checkout_session->url; ?>" class="spbooking-btn spbooking-btn-primary stripe-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>
			</div>
		</div>

		<!--</form> -->
	</div>


</div>
