<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
require_once JPATH_ROOT . '/components/com_spbooking/assets/vendor/autoload.php';

use Stripe\Stripe;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Stripe\Checkout\Session;
use Joomla\CMS\Language\Text;
use Stripe\Exception\ApiErrorException;

$notify_url     = Uri::base() . 'index.php?option=com_spbooking&view=payment&task=notify';
$return_success = Uri::base() . 'index.php?option=com_spbooking&view=payment&task=success';
$return_cencel  = Uri::base() . 'index.php?option=com_spbooking&view=payment&task=cancel';

?>

<div class="spbooking spbooking-payment">
	<!-- display invoice  -->
	<?php if (!empty($this->item))
	{
		?>
		<div class="spbooking-row">
			<div class="spbooking-col-12">
				<table class="table table-bordered">
					<thead>
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_PAYMENT_INFO'); ?></th>
							<th><?php echo Text::_('COM_SPBOOKING_ROOM_PRICE'); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								<?php if (!empty($this->item->package->title))
								{
									?>
									<p class="spbooking-title"><?php echo $this->item->package->title; ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->adult))
								{
									?>
									<p class="text-mute"><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->child))
								{
									?>
									<p class="text-mute"><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->pickup_location))
								{
									?>
									<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_PAYMENT_PICKUP_LOCATION') . ': ' . $this->item->cartData->pickup_location . "(" . $this->item->cartData->pickup_date . " " . $this->item->cartData->pickup_time . ")"; ?></p>
								<?php } ?>
								<?php
								if (!empty($this->item->cartData->dropoff_location))
								{
									?>
									<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_PAYMENT_DROPOFF_LOCATION') . ': ' . $this->item->cartData->dropoff_location . "(" . $this->item->cartData->dropoff_date . " " . $this->item->cartData->dropoff_time . ")"; ?></p>
								<?php } ?>
							</td>
							<td>
								<!-- Adult -->
								<?php if (!empty($this->item->cartData->sale_price))
								{
									?>
									<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></del>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->sale_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position) . ' x ' . $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_PERSON', 'COM_SPBOOKING_PERSONS') . ' = '; ?></span>
									<span><?php echo SpbookingHelper::formatPrice($this->total_adult_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
								<?php }
								else
								{
									?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position) . ' x ' . $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ' = '; ?></span>
									<span><?php echo SpbookingHelper::formatPrice($this->total_adult_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
								<?php } ?>
								<br>
								<!-- Child -->
								<?php if (!empty($this->item->cartData->child_sale_price) && $this->item->cartData->child > 0)
								{
									?>
									<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></del>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_sale_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position) . ' x ' . $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') . ' = '; ?></span>
									<span><?php echo SpbookingHelper::formatPrice($this->total_child_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
								<?php }
								else
								{
									if ($this->item->cartData->child)
									{
										?>
										<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position) . ' x ' . $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') . ' = '; ?></span>
										<span><?php echo SpbookingHelper::formatPrice($this->total_child_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
									<?php } ?>
								<?php } ?>
							</td>
						</tr>
						<?php if (!empty($this->item->cartData->additionalServices))
						{
							?>
							<tr>
								<th><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES') ?></th>
								<td>
									<ul class="day-wise-price">
										<?php foreach ($this->item->cartData->additionalServices as $key => $service)
										{
											?>
											<li class="price-item">
												<strong class="text-mute"><?php echo $service->title . '= '; ?></strong>
												<?php echo SpbookingHelper::formatPrice($service->price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position);?>                                               
											</li>
										<?php } ?>
									</ul>
								</td>
							</tr>

						<?php } ?>
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_CHECKOUT_SUBTOTAL'); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></td>
						</tr>
						<!-- Tax -->
						<tr>
							<th><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->tax, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></td>
						</tr>
						<tr>
							<th><?php echo Text::sprintf('COM_SPBOOKING_CHECKOUT_TOTAL', $this->item->tax); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->total, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	<?php }
	else
	{
		?>
		<div class="alert alert-danger fade show text-center">
			<strong>Error</strong>
			<p><?php echo Text::_('COM_SPBOOKING_INVOICE_ERROR'); ?></p>
		</div>
	<?php }; ?>

	<!-- payment form -->
	<div class="payment-option mt-30">
		<h4 class="spbooking-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_PAYMENT_TITLE'); ?></h4>
		<!-- payment radio options -->
		<div class="spbooking-box">
			<!-- Stripe Button -->
			<?php if ((is_array($this->payment_method) && in_array('stripe', $this->payment_method)))
			{
				$input_checked = ($this->params->get('payment_method') == 'stripe') ? "checked='checked'" : '';
				?>
				<div class="custom-control custom-radio custom-control-inline">
					<input type="radio" id="stripe" name="payment-method" class="custom-control-input" value="stripe">
					<label class="custom-control-label" for="stripe">
						<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_STRIPE'); ?>
					</label>
				</div>
			<?php } ?>
			<!-- Stripe Button End -->
			<?php if ((is_array($this->payment_method) && in_array('paypal', $this->payment_method)))
			{
				?>
				<div class="custom-control custom-radio custom-control-inline text-left">
					<input type="radio" id="paypal" name="payment-method" class="custom-control-input" value="paypal" checked>
					<label class="custom-control-label" for="paypal">
						<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYPAL'); ?>
					</label>
				</div>
			<?php } ?>

			<?php if ((is_array($this->payment_method) && in_array('paylater', $this->payment_method)))
			{
				$input_checked = ($this->params->get('payment_method') == 'paylater') ? "checked='checked'" : ''; ?>
				<div class="custom-control custom-radio custom-control-inline">
					<input type="radio" id="paylater" name="payment-method" class="custom-control-input" value="paylater">
					<label class="custom-control-label" for="paylater">
						<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYLATER'); ?>
					</label>
				</div>
			<?php } ?>

		</div>

		<div class="reserve-box">
			<input type="hidden" name="paypal_paid" class="paypal-paid" value="<?php echo $this->total; ?>">
			<input type="hidden" name="paylater_paid" class="paylater-paid" value="0">
			<input type="hidden" name="booked_id" value="<?php echo $this->booked_id; ?>">
			<input type="hidden" name="pay_for" value="package">
		</div>
		<div class="spbooking-row mt-20">
			<!-- term and condition -->
			<div class="spbooking-col-6">
				<div class="custom-control custom-checkbox">
					<input type="checkbox" class="custom-control-input" id="payment_tac" name="payment_tac" required>
					<label class="custom-control-label" for="payment_tac"><?php echo Text::_('COM_SPBOOKING_PAYMENT_TAC_TEXT'); ?></label>
				</div>
			</div>

			<!-- proceed -->
			<div class="spbooking-col-6">
				<?php
				$user_email = ($this->item->email) ? $this->item->email : $this->user->email;
				$user_name = !empty($this->item->name) ? $this->item->name : $this->user->name;

				if (is_array($this->payment_method) && in_array('paypal', $this->payment_method))
				{
					if ($this->params->get('shop_environment') == 'sandbox')
					{
						$action = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
					}
					else
					{
						$action = 'https://www.paypal.com/cgi-bin/webscr';
					}
					?>
					<form action="<?php echo $action; ?>" method="post" class="pull-right spbooking-paypal-form spbooking-payment-method payment-method-paypal">
						<input type="hidden" name="cmd" value="_cart">
						<input type="hidden" name="upload" value="1">
						<input type="hidden" name="business" value="<?php echo $this->params->get('paypal_id'); ?>">
						<div id="item_<?php echo $this->package_id; ?>" class="itemwrap">
							<input type="hidden" name="item_name_1" value="<?php echo $this->item->package->title; ?>">
							<input type="hidden" name="item_number_1" value="<?php echo $this->package_id; ?>">
							<input type="hidden" name="quantity_1" value="1">
							<input type="hidden" name="amount_1" value="<?php echo $this->total; ?>">
						</div>
						<input type="hidden" name="invoice" value="<?php echo $this->booked_id; ?>">
						<input type="hidden" name="custom" value='<?php echo json_encode(array('userid' => $this->user->id, 'order_type' => 'package', 'itemid' => $this->item->id, 'useremail' => $user_email, 'username' => $user_name)); ?>'>
						<input type="hidden" name="currency_code" value="<?php echo $this->currency[0]; ?>">
						<input type="hidden" name="notify_url" value="<?php echo $this->notify_url; ?>" />
						<input type="hidden" name="return" value="<?php echo $this->return_success; ?>" />
						<input type="hidden" name="cancel_return" value="<?php echo $this->return_cencel; ?>" />
						<button type="submit" class="spbooking-btn spbooking-btn-primary paypal-submit-btn" disabled="disabled" name="submit"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</form>
				<?php } ?>

				<?php if (is_array($this->payment_method) && in_array('paylater', $this->payment_method))
				{
					$button_hide = 'style="display: none";';
					$username = !empty($this->item->name) ? $this->item->name : '';
					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$item_title = $this->item->package->title;
					$cartdata = base64_encode(serialize(array('order_type' => 'package', 'item_title' => $item_title, 'itemid' => $this->item->id, 'booked_id' => $this->booked_id, 'userid' => $this->user->id, 'useremail' => $user_email, 'username' => $username, 'payment_type' => 'paylater')));
					?>
					<div class="spbooking-payment-method payment-method-paylater pull-right mt-10" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $this->paylater_url . '&cdata=' . $cartdata; ?>" class="spbooking-btn spbooking-btn-primary paylater-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>

				<!-- Stripe -->
				<?php if (is_array($this->payment_method) && in_array('stripe', $this->payment_method))
				{
					$button_hide = 'style="display: none";';

					Stripe::setApiKey($this->params->get('stripe_key'));

					$line_item = array();

					$price = ($this->total_child_price + $this->total_adult_price) * 100;
					$services = '';

					$description = $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ' ' . $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') . ' ' . $services;

					$line_item =
						[
							[
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => ucwords($this->item->package->title),
										'description'   => $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ' ' . $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'),
									],
									'unit_amount' => $price,
								],
								'quantity' => 1,
							]
						];

					if (!empty($this->item->cartData->additionalServices))
					{
						$services = '';

						foreach ($this->item->cartData->additionalServices as $serviceCharge)
						{
							$services .= $serviceCharge->title . ' -- ';
						}

						$addionalData = [
							'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'),
										'description'   => $services,
									],
									'unit_amount' => $this->additional_service * 100,
								],
								'quantity' => 1,
							];
						array_push($line_item, $addionalData);
					}

					$taxData = [
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => Text::_('COM_SPBOOKING_TAX_TEXT'),
									],
									'unit_amount' => (int) $this->tax * 100,
								],
								'quantity' => 1,
							];

					array_push($line_item, $taxData);

					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$username = !empty($this->item->name) ? $this->item->name : '';

					try
					{
						$checkout_session = Session::create([
							'line_items'    => $line_item,
							'metadata'      => array(
								'order_type'    => 'package',
								'item_title'    => $this->item->package->title,
								'itemid'        => $this->item->id,
								'booked_id'     => $this->booked_id,
								'userid'        => $this->user->id,
								'useremail'     => $user_email,
								'username'      => $username,
								'payment_type'  => 'stripe',
								'payment_amount' => $this->total
							),
							'mode'          => 'payment',
							'success_url'   => Uri::base() . 'index.php?option=com_spbooking&task=payment.stripeSuccess&session_id={CHECKOUT_SESSION_ID}',
							'cancel_url'    => $this->return_cencel,
							]
						);
					}
					catch (ApiErrorException $e)
					{
						return Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
					}

					?>
					<div class="spbooking-payment-method payment-method-stripe pull-right mt-10" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $checkout_session->url; ?>" class="spbooking-btn spbooking-btn-primary stripe-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>


</div>
