<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

require_once JPATH_ROOT . '/components/com_spbooking/assets/vendor/autoload.php';

use Stripe\Stripe;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Stripe\Checkout\Session;
use Joomla\CMS\Language\Text;
use Stripe\Exception\ApiErrorException;

?>

<div class="spbooking spbooking-payment">
	<!-- display invoice  -->
	<?php if (!empty($this->item))
	{
		?>
		<div class="spbooking-row">
			<div class="spbooking-col-12">
				<table class="table table-bordered">
					<thead>
						<th><?php echo Text::_('COM_SPBOOKING_ROOM_TITLE'); ?></th>
						<th><?php echo Text::_('COM_SPBOOKING_ROOM_PRICE'); ?></th>
					</thead>
					<tbody>
						<?php if (!empty($this->item->cartData))
						{
							?>
							<?php foreach ($this->item->cartData as $keys => $cartData)
							{
								if ($keys != 'additionalServices')
								{
									?>
									<tr>
										<td>
											<p><?php echo $cartData->room_title; ?></p>
											<?php
											if (!empty($cartData->adult))
											{
												?>
												<span class="text-mute"><?php echo $cartData->adult . ' ' . SpbookingHelper::pluralize($cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></span>
											<?php } ?>
											<?php
											if (!empty($cartData->child))
											{
												?>
												<span class="text-mute"><?php echo $cartData->child . ' ' . SpbookingHelper::pluralize($cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></span>
											<?php } ?>
											<?php
											if (!empty($cartData->n_rooms))
											{
												?>
												<span class="text-mute"><?php echo $cartData->n_rooms . ' ' . SpbookingHelper::pluralize($cartData->n_rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS'); ?></span>
											<?php } ?>
											<?php
											if (!empty($cartData->nights))
											{
												?>
												<span class="text-mute"><?php echo ' x ' . $cartData->nights . ' ' . SpbookingHelper::pluralize($cartData->nights, 'COM_SPBOOKING_ROOM_NIGHT', 'COM_SPBOOKING_ROOM_NIGHTS'); ?></span>
											<?php } ?>
											<?php
											if (!empty($cartData->room_price) && is_array($cartData->room_price))
											{
												?>
												<ul class="day-wise-price">
													<?php foreach ($cartData->room_price as $v)
													{
														?>
														<li class="price-item">
															<strong class="text-mute"><?php echo $v->date . ': '; ?></strong>
															<?php
															$adult_price = (!empty($v->special_price) && $v->special_price < $v->original_price) ? $v->special_price : $v->original_price;
															$child_price = (!empty($v->child_special_price) && $v->child_special_price < $v->child_price && $v->child_val) ? $v->child_special_price : $v->child_price;
															?>
															<span class="text-mute"><?php echo SpbookingHelper::formatPrice($adult_price, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position); ?> (<?php echo Text::_('COM_SPBOOKING_ADULT') ?>)
															</span>
															<?php if ($child_price)
															{
																?>
																<span class="text-mute"><?php echo SpbookingHelper::formatPrice($child_price, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position); ?> (<?php echo Text::_('COM_SPBOOKING_CHILD') ?>)
															<?php } ?>

														</li>
													<?php } ?>
												</ul>

											<?php } ?>
										</td>
										<td><?php echo SpbookingHelper::formatPrice($this->calculateUnitPrice($cartData->room_price) * (int) $cartData->n_rooms, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position, false, 2); ?>
										</td>
									</tr>
								<?php }
								else
								{
									$sum = 0;
									?>
									<tr>
										<td>
											<p><b><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES') ?></b></p>
											<ul class="day-wise-price">
												<?php foreach ($cartData as $additionalServices)
												{
													?>
													<li class="price-item">
														<strong class="text-mute"><?php echo $additionalServices->title . ': '; ?></strong>
														<?php $sum = $sum + $additionalServices->price; ?>
														<span class="text-mute"><?php echo SpbookingHelper::formatPrice($additionalServices->price, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position); ?> 
														</span>
													</li>
												<?php } ?>
											</ul>
										</td>
										<td><?php echo SpbookingHelper::formatPrice($sum, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position) ?></td>
									</tr>
								<?php } ?>
							<?php } ?>
						<?php } ?>

						<!-- subtotal -->
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_BOOKING_SUBTOTAL'); ?></th>
							<td><?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position, false, 2); ?>
							</td>
						</tr>

						<!-- tax info -->
						<tr>
							<?php $tax = SpbookingHelper::formatPrice($this->tax, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position, false, 2); ?>
							<th><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
							<td><?php echo $tax; ?>
							</td>
						</tr>

						<!-- total -->
						<tr>
							<th><?php echo Text::_('COM_SPBOOKING_BOOKING_TOTAL'); ?></th>
							<th><?php echo SpbookingHelper::formatPrice($this->total, $this->item->accomodation->currency, $this->item->accomodation->currency_type, $this->item->accomodation->currency_position, false, 2); ?>
							</th>
						</tr>
					</tbody>
				</table>

			</div>
		</div>
	<?php }
	else
	{
		?>
		<div class="alert alert-danger fade show text-center">
			<strong><?php echo Text::_('JGLOBAL_ERROR'); ?></strong>
			<p><?php echo Text::_('COM_SPBOOKING_INVOICE_ERROR'); ?></p>
		</div>
	<?php }; ?>

	<!-- payment type selection -->
	<div class="spbooking-row">
		<div class="spbooking-col-12">
			<div class="spbooking-box">

				<!-- Stripe Button -->
				<?php if ((is_array($this->payment_method) && in_array('stripe', $this->payment_method)))
				{
					$input_checked = ($this->params->get('payment_method') == 'stripe') ? "checked='checked'" : '';
					?>
					<div class="custom-control custom-radio custom-control-inline">
						<input type="radio" id="stripe" name="payment-method" class="custom-control-input" value="stripe">
						<label class="custom-control-label" for="stripe">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_STRIPE'); ?>
						</label>
					</div>

				<?php } ?>

				<?php if ((is_array($this->payment_method) && in_array('paypal', $this->payment_method)))
				{
					?>
					<div class="custom-control custom-radio custom-control-inline text-left">
						<input type="radio" id="paypal" name="payment-method" class="custom-control-input" value="paypal" checked>
						<label class="custom-control-label" for="paypal">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYPAL'); ?>
						</label>
					</div>
				<?php } ?>

				<?php if ((is_array($this->payment_method) && in_array('paylater', $this->payment_method)))
				{
					$input_checked = ($this->params->get('payment_method') == 'paylater') ? "checked='checked'" : '';
					?>
					<div class="custom-control custom-radio custom-control-inline">
						<input type="radio" id="paylater" name="payment-method" class="custom-control-input" value="paylater">
						<label class="custom-control-label" for="paylater">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_METHOD_PAYLATER'); ?>
						</label>
					</div>

				<?php } ?>

			</div>
		</div>
	</div>

	<div class="spbooking-row">
		<!-- term and condition -->
		<div class="spbooking-col-6">
			<div class="custom-control custom-checkbox">
				<input type="checkbox" class="custom-control-input" id="payment_tac" name="payment_tac" required>
				<label class="custom-control-label" for="payment_tac"><?php echo Text::_('COM_SPBOOKING_PAYMENT_TAC_TEXT'); ?></label>
			</div>
		</div>

		<div class="spbooking-col-6">
			<div class="submit-payment-form">
				<?php if (is_array($this->payment_method) && in_array('paypal', $this->payment_method))
				{
					if ($this->params->get('shop_environment') == 'sandbox')
					{
						$action = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
					}
					else
					{
						$action = 'https://www.paypal.com/cgi-bin/webscr';
					}

					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$user_name = !empty($this->item->name) ? $this->item->name : $this->user->name;
					?>
					<form action="<?php echo $action; ?>" method="post" class="pull-right spbooking-paypal-form spbooking-payment-method payment-method-paypal mt-10">
						<input type="hidden" name="cmd" value="_cart">
						<input type="hidden" name="upload" value="1">
						<input type="hidden" name="business" value="<?php echo $this->params->get('paypal_id'); ?>">
						<div id="item_<?php echo $this->item->accomodation->id; ?>" class="itemwrap">
							<input type="hidden" name="item_name_1" value="<?php echo $this->item->accomodation->title; ?>">
							<input type="hidden" name="item_number_1" value="<?php echo $this->item->accomodation->id; ?>">
							<input type="hidden" name="quantity_1" value="1">
							<input type="hidden" name="amount_1" value="<?php echo $this->total; ?>">
						</div>                      
						<input type="hidden" name="invoice" value="<?php echo $this->booked_id; ?>">
						<input type="hidden" name="custom" value='<?php echo json_encode(array('userid' => $this->user->id, 'order_type' => 'room', 'itemid' => $this->item->id, 'useremail' => $user_email, 'username' => $user_name)); ?>'>
						<input type="hidden" name="currency_code" value="<?php echo $this->currency[0]; ?>">
						<input type="hidden" name="notify_url" value="<?php echo $this->notify_url; ?>" />
						<input type="hidden" name="return" value="<?php echo $this->return_success; ?>" />
						<input type="hidden" name="cancel_return" value="<?php echo $this->return_cencel; ?>" />
						<button type="submit" class="spbooking-btn spbooking-btn-primary paypal-submit-btn" disabled="disabled" name="submit"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</form>
				<?php } ?>

				<?php if (is_array($this->payment_method) && in_array('paylater', $this->payment_method))
				{
					$button_hide = 'style="display: none";';
					$username = !empty($this->item->name) ? $this->item->name : '';
					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$item_title = $this->item->accomodation->title;
					$cartdata = base64_encode(serialize(array('order_type' => 'room', 'item_title' => $item_title, 'itemid' => $this->item->id, 'booked_id' => $this->booked_id, 'userid' => $this->user->id, 'useremail' => $user_email, 'username' => $username, 'payment_type' => 'paylater')));
					?>
					<div class="spbooking-payment-method payment-method-paylater pull-right mt-10" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $this->paylater_url . '&cdata=' . $cartdata; ?>" class="spbooking-btn spbooking-btn-primary paylater-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>

				<!-- Stripe -->
				<?php if (is_array($this->payment_method) && in_array('stripe', $this->payment_method))
				{
					$button_hide = 'style="display: none";';

					Stripe::setApiKey($this->params->get('stripe_key'));


					$line_items = array();

					foreach ($this->item->cartData as $key => $cart)
					{
						$price  = $charge = 0;
						$description = '';

						if ($key == 'additionalServices')
						{
							foreach ($cart as $serviceCharge)
							{
								$charge += (int) $serviceCharge->price * 100;
								$description .= $serviceCharge->title . ' -- ';
							}

							$title = Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES');
							$price = $charge;
						}
						else
						{
							$price       = $this->calculateUnitPrice($cart->room_price) * 100 * $cart->n_rooms;
							$description = $cart->adult . ' ' . SpbookingHelper::pluralize($cart->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ' ' . (isset($cart->child) ? $cart->child . ' ' . SpbookingHelper::pluralize($cart->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') : '') . ' x ' . $cart->nights . ' ' . SpbookingHelper::pluralize($cart->nights, 'COM_SPBOOKING_ROOM_NIGHT', 'COM_SPBOOKING_ROOM_NIGHTS');
							$title      = ucwords($cart->room_title);
						}

						$line_item =
							[
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => $title,
										'description'   => $description,
									],
									'unit_amount' => $price,
								],
								'quantity' => 1,
							];

						array_push($line_items, $line_item);
					}

					$tax_data =
							[
								'price_data' => [
									'currency'     => $this->currency[0],
									'product_data' => [
										'name'          => Text::_('COM_SPBOOKING_TAX_TEXT'),

									],
									'unit_amount' => (int) $this->tax * 100,
								],
								'quantity' => 1,
							];

					array_push($line_items, $tax_data);

					$user_email = !empty($this->item->email) ? $this->item->email : $this->user->email;
					$username = !empty($this->item->name) ? $this->item->name : '';

					try
					{
						$checkout_session = Session::create([
							'line_items'    => $line_items,
							'metadata'      => array(
								'order_type'    => 'room',
								'item_title'    => $this->item->accomodation->title,
								'itemid'        => $this->item->id,
								'booked_id'     => $this->booked_id,
								'userid'        => $this->user->id,
								'useremail'     => $user_email,
								'username'      => $username,
								'payment_type'  => 'stripe',
								'payment_amount' => $this->total
							),
							'mode'          => 'payment',
							'success_url'   => Uri::base() . 'index.php?option=com_spbooking&task=payment.stripeSuccess&session_id={CHECKOUT_SESSION_ID}',
							'cancel_url'    => $this->return_cencel,
							]
						);
					}
					catch (ApiErrorException $e)
					{
						return Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
					}
					?>
					<div class="spbooking-payment-method payment-method-stripe pull-right mt-10" <?php echo $button_hide; ?>>
						<button data-href="<?php echo $checkout_session->url; ?>" class="spbooking-btn spbooking-btn-primary stripe-submit-btn" disabled="disabled"><?php echo Text::_('COM_SPBOOKING_CART_PROCEED_CHECKOUT'); ?></button>
					</div>
				<?php } ?>
				<!-- Stripe End -->
			</div> <!-- /.submit-payment-form -->
		</div>

	</div>


</div>
