<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewPackages extends HtmlView
{
	protected $items;

	protected $pagination;

	public function display($tpl = null)
	{
		// Common
		$model 			    = $this->getModel();
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->menuItemId   = SpbookingHelper::getItemId('packages');
		$this->cParams      = ComponentHelper::getParams('com_spbooking');
		$this->columns      = $this->cParams->get('packages_columns', 2);

		// Get filter data
		$this->facilities   = $model->getPackageFacilities();
		$this->tags         = SpbookingHelper::getItemTags();

		// Insert data inside the array
		foreach ($this->items as $item)
		{
			$item->url = Route::_('index.php?option=com_spbooking&view=package&id=' . $item->id . ':' . $item->alias . SpbookingHelper::getItemid('packages'));

			$item->save_money = 0;
			$item->price_formated = 0;

			$item->sale_price = (int) $item->sale_price;
			$item->price = (int) $item->price;

			if (!empty($item->sale_price) && $item->sale_price < $item->price)
			{
				$item->price_formated = SpbookingHelper::formatPrice($item->sale_price);
				$item->save_money = $item->price - $item->sale_price;
			}
			else
			{
				$item->price_formated = SpbookingHelper::formatPrice($item->price, $item->currency, $item->currency_type, $item->currency_position);
			}

			$item->review   = SpbookingHelper::calculateReview($item->id, 'package');
			$item->thumb = SpbookingHelper::getThumbs($item->image, 'thumbnail', '360x348');
		}

		$input          = Factory::getApplication()->input;
		$disableSidebar = $input->get('disable_sidebar', 0, 'INT');

		if ($disableSidebar)
		{
			$this->_layout = 'without_sidebar';
		}

		return parent::display($tpl = null);
	}
}

