<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use SpbookingHelper as Helper;
use Joomla\CMS\Layout\LayoutHelper;

$input = Factory::getApplication()->input;
$view_style = $input->get('view_style', 'grid', 'WORD');
$package_type = $input->get('package_type', 0);

?>

<div id="sp-booking-packages " class="spbooking-view-pakcages spbooking">
	<div class="spbooking-row topbar-search-options">
		<div class="spbooking-col-sm-12">
			<?php echo LayoutHelper::render('packages.topbar_filter'); ?>
		</div>
	</div>

	<!-- spbooking-pakcages-list -->
	<div class="spbooking-pakcages-list">
		<div class="spbooking-row">
			<!-- contents column -->
			<div class="spbooking-col-md-12 spbooking-col-lg-12">
				<!-- view style switcher -->
				<div class="view-style-switcher">
					<button class="btn btn-primary view-style-grid <?php echo $view_style == 'grid' ? 'active' : ''; ?>" data-view="packages" data-menuitemid="<?php echo str_replace("&Itemid=", "", $this->menuItemId); ?>" data-ptype="<?php echo $package_type; ?>"  type="button"><span class="fa fa-th"></span></button>
					<button class="btn btn-primary view-style-list <?php echo $view_style == 'list' ? 'active' : ''; ?>" data-view="packages" data-menuitemid="<?php echo str_replace("&Itemid=", "", $this->menuItemId); ?>" data-ptype="<?php echo $package_type; ?>"  type="button"><span class="fa fa-list"></span></button>
					<span class="text-mute"><?php echo Text::sprintf('COM_SPBOOKING_TOTAL_N_RESULTS_FOUND', count((array) $this->items), Helper::pluralize(count((array) $this->items), 'COM_SPBOOKING_RESULT', 'COM_SPBOOKING_RESULTS')); ?></span>
				</div>

				<!-- accomodation contents container -->
				<div class="spbooking-package-contents">
					<!-- if $this->items has value -->
					<?php if (!empty($this->items))
					{
						?>
						<?php if ($view_style === 'grid')
						{
							?>
							<?php echo LayoutHelper::render('packages.grid.listing', array('packages' => $this->items, 'columns' => $this->columns)); ?>
						<?php }
						elseif ($view_style == 'list')
						{
							?>
							<?php echo LayoutHelper::render('packages.list.listing', array('packages' => $this->items, 'columns' => $this->columns)); ?>
						<?php } ?>
					<?php }
					else
					{
						?>
						<div class="spbooking-empty-item">
							<p><?php echo Text::sprintf('COM_SPBOOKING_NO_ITEM_FOUND', Text::_('COM_SPBOOKING_PACKAGES')); ?></p>
						</div>
					<?php } ?>
				</div>

				<!-- pagination  -->
				<?php if ($this->pagination->pagesTotal > 1)
				{
					?>
					<div class="pagination">
						<?php echo $this->pagination->getPagesLinks(); ?>
					</div>
				<?php } ?>
			</div> <!-- /.spbooking-col-sm-8 -->
		</div> <!-- /.spbooking-row -->
	</div>  <!-- /.spbooking-pakcages-list -->
</div> <!-- /#sp-booking-packages -->
