<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingViewPackage extends HtmlView
{
	protected $item;

	public function display($tpl = null)
	{
		$model              = $this->getModel();
		$doc                = Factory::getDocument();
		$accomodation_model = BaseDatabaseModel::getInstance('Accomodation', 'SpbookingModel');
		$this->cParams      = ComponentHelper::getParams('com_spbooking');
		$this->item         = $this->get('Item');
		$this->showRatings  = $this->cParams->get('rating');

		$this->item->gallery            = (!empty($this->item->gallery) && $this->item->gallery) ? json_decode($this->item->gallery) : array();
		$this->item->includes           = (!empty($this->item->package_included) && $this->item->package_included) ? json_decode($this->item->package_included) : array();
		$this->item->excludes           = (!empty($this->item->package_excluded) && $this->item->package_excluded) ? json_decode($this->item->package_excluded) : array();
		$this->item->overview           = (!empty($this->item->overview) && is_string($this->item->overview)) ? json_decode($this->item->overview) : array();
		$this->item->reviews            = SpbookingHelper::calculateReview($this->item->id, 'package');
		$this->item->activities         = (!empty($this->item->activities) && is_string($this->item->activities)) ? json_decode($this->item->activities) : array();
		$this->item->additional_reviews = (!empty($this->item->additional_reviews) && is_string($this->item->additional_reviews)) ? json_decode($this->item->additional_reviews) : array();
		$this->item->certificates       = (!empty($this->item->certificates) && is_string($this->item->certificates)) ? json_decode($this->item->certificates) : array();
		$this->item->is_available       = true;
		$this->item->major_activities   = (!empty($this->item->major_activities) && is_string($this->item->major_activities) ? json_decode($this->item->major_activities) : array());
		$this->item->custom             = (!empty($this->item->custom) && is_string($this->item->custom) ? json_decode($this->item->custom) : array());

		// Check if the package is available for booking
		$today           = new DateTime('today');
		$start_date      = new DateTime($this->item->start_date);
		$end_date        = new DateTime($this->item->end_date);

		$this->item->is_available 		 = ($this->item->show_end_date && $today > $start_date) ? !($today > $end_date) : !($today < $start_date);
		$this->item->carousel_background = $this->cParams->get('package_review_background', '');

		if (!empty($this->item->carousel_background))
		{
			$this->item->carousel_background = "background: url(" . Uri::root() . $this->item->carousel_background . ")";
		}
		else
		{
			$this->item->carousel_background = '';
		}

		// Group the activities by the day number
		$activities = array();

		if (!empty($this->item->activities))
		{
			foreach ($this->item->activities as $activity)
			{
				$activities[$activity->day][] = $activity;
			}
		}

		$this->item->activities = $activities;
		$this->item->location = '';

		if (!empty($this->item->city))
		{
			$this->item->location .= $this->item->city . ', ';
		}

		if (!empty($this->item->country))
		{
			$this->item->location .= $this->item->country;
		}

		$doc->addScriptDeclaration("var feedbackUrl = '" . Route::_('index.php?option=com_spbooking&task=accomodation.submitFeedback') . "';");
		$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spreview.css');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/feedback.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spreview.js');

		return parent::display($tpl = null);
	}
}

