<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;

class SpbookingViewInvoices extends HtmlView
{
	protected $items;

	protected $pagination;

	public function display($tpl = null)
	{
		$model 			= $this->getModel();
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		$menuItemId = SpbookingHelper::getItemId('invoices');

		if (!empty($this->items) && Factory::getUser()->id > 0)
		{
			foreach ($this->items as $item)
			{
				if ($item->booking_for == 'room')
				{
					$item->title = $model->getContentInfo($item->accomodation_id, 'accomodation')->title;
					$item->url = Route::_('index.php?option=com_spbooking&view=invoice&id=' . $item->id . '&booking_id=' . $item->booked_id . $menuItemId);
				}
				elseif ($item->booking_for == 'package')
				{
					$item->title = $model->getContentInfo($item->package_id, 'package')->title;
					$item->url = Route::_('index.php?option=com_spbooking&view=invoice&layout=package&id=' . $item->id . '&booking_id=' . $item->booked_id . $menuItemId);
				}
				elseif ($item->booking_for == 'transport')
				{
					$item->title = $model->getContentInfo($item->transport_id, 'transport')->title;
					$item->url = Route::_('index.php?option=com_spbooking&view=invoice&layout=transport&id=' . $item->id . '&booking_id=' . $item->booked_id . $menuItemId);
				}
			}
		}

		return parent::display($tpl = null);
	}
}

