<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

$input = Factory::getApplication()->input;
$booked_id = $input->get('booked_id', '', 'STRING');
$booking_for = $input->get('booking_for', '', 'STRING');
$booking_status = $input->get('booking_status', '', 'STRING');
$from = $input->get('from', '', 'STRING');
$to = $input->get('to', '', 'STRING');

$menuItemId = SpbookingHelper::getItemId('invoices');

?>
	
<div class="spbooking spbooking-invoices-list-wrap">

	<div class="spbooking-row mt-20">
		<div class="spbooking-col-12">
			<div class="spbooking-box-layout">
				<form action="<?php echo Route::_('index.php?option=com_spbooking&view=invoices' . $menuItemId); ?>" >
					<div class="d-flex justify-content-between">
						<div class="mr-10 flex-grow-1">
							<input type="text" name="booked_id" class="form-control" placeholder="<?php echo Text::_('COM_SPBOOKING_INVOICE_BOOKING_ID'); ?>" value="<?php echo $booked_id; ?>" >
						</div>
						
						<div class="mr-10 flex-grow-1">
							<select name="booking_for" id="" class="form-control spbooking-select">
								<option value=""><?php echo Text::_('COM_SPBOOKING_SELECT_BOOKING_FOR'); ?></option>
								<option value="room" <?php echo $booking_for == 'room' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_ACCOMODATION'); ?></option>
								<option value="package" <?php echo $booking_for == 'package' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_PACKAGE'); ?></option>
								<option value="transport" <?php echo $booking_for == 'transport' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TRANSPORT'); ?></option>
							</select>
						</div>
						
						<div class="form-groups mr-10 flex-grow-1">
							<select name="booking_status" id="" class="form-control spbooking-select">
								<option value=""><?php echo Text::_('COM_SPBOOKING_SELECT_BOOKING_STATUS'); ?></option>
								<option value="invalid" <?php echo $booking_status == 'invalid' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_STATUS_INVALID'); ?></option>
								<option value="in_approve" <?php echo $booking_status == 'in_approve' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_STATUS_INAPPROVE'); ?></option>
								<option value="paylater" <?php echo $booking_status == 'paylater' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_STATUS_PAYLATER'); ?></option>
								<option value="paid" <?php echo $booking_status == 'paid' ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_STATUS_PAID'); ?></option>
							</select>
						</div>
					</div>

					<div class="d-flex justify-content-between">
						<div class="form-groups mr-10 flex-grow-1">
							<input type="text" name="from" class="form-control spbooking-invoice-date-picker" placeholder="<?php echo Text::_('COM_SPBOOKING_FROM'); ?>" value="<?php echo $from; ?>" >
						</div>
						
						<div class="form-groups mr-10 flex-grow-1">
							<input type="text" name="to" class="form-control spbooking-invoice-date-picker" placeholder="<?php echo Text::_('COM_SPBOOKING_TO'); ?>" value="<?php echo $to; ?>" >
						</div>
					</div>

					<div class="mt-10">
						<button class="spbooking-btn spbooking-btn-primary"><span class="fa fa-search"></span> <?php echo Text::_('COM_SPBOOKING_SUBMIT'); ?></button>
						<a href="<?php echo Route::_('index.php?option=com_spbooking&view=invoices' . $menuItemId); ?>" class="spbooking-btn spbooking-btn-link"><?php echo Text::_('COM_SPBOOKING_RESET'); ?></a>
					</div>
				</form>
			</div>
		</div>
	</div>

	<div class="spbooking-row mt-20">
		<div class="spbooking-col-12">
			<?php if (Factory::getUser()->id > 0)
			{
				?>
				<div class="spbooking-box-layout">
					<table class="spbooking-table spbooking-table-striped">
						<thead class="thead-dark">
							<tr>
								<th><?php echo Text::_('COM_SPBOOKING_INVOICE_BOOKING_ID'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_INVOICE_BOOKING_FOR'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_INVOICE_CHECKIN'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_INVOICE_CHECKOUT'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_INVOICE_STATUS'); ?></th>
							</tr>
						</thead>
	
						<?php if (!empty($this->items))
						{
							?>
							<?php foreach ($this->items as $item)
							{
								?>
								<tr>
									<td><a href="<?php echo $item->url; ?>" target="_blank"><?php echo $item->booked_id; ?></a></td>
									<td><?php echo "<small>[" . ucfirst($item->booking_for == 'room' ? 'accomodation' : $item->booking_for) . "]</small> " . $item->title; ?></td>
									<td><?php echo HTMLHelper::_('date', $item->checkin, 'd F, Y'); ?></td>
									<td><?php echo HTMLHelper::_('date', $item->checkout, 'd F, Y'); ?></td>
									<td><?php echo $item->booking_status; ?></td>
								</tr>
							<?php } ?>
						<?php } ?>
					</table>
	
					<!-- pagination  -->
					<?php if ($this->pagination->pagesTotal > 1)
					{
						?>
						<div class="pagination">
							<?php echo $this->pagination->getPagesLinks(); ?>
						</div>
					<?php } ?>
				</div>
			<?php }
			else
			{
				?>
				<div class="not-loggedin-msg text-center">
					<div class="alert alert-danger fade show">
						<p><?php echo Text::_('COM_SPBOOKING_NOT_LOGGED_IN_MSG'); ?></p>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
