<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingViewInvoice extends HtmlView
{
	protected $item;

	public function display($tpl = null)
	{
		$model      = $this->getModel();
		$cparams    = ComponentHelper::getParams('com_spbooking');
		$payment_model = BaseDatabaseModel::getInstance('Payment', 'SpbookingModel');
		$doc        = Factory::getDocument();
		$this->item = $this->get('Item');
		$this->item->tax = $cparams->get('tax', '', 'INT');

		if ($this->item->booking_for == 'room')
		{
			if (!empty($this->item))
			{
				$this->item->accomodation_info = $payment_model->getAccomodationInfo($this->item->accomodation_id);

				if (!empty($this->item->cartData) && is_string($this->item->cartData))
				{
					$this->item->cartData = json_decode($this->item->cartData);
				}

				$this->subtotal = 0;
				$this->total = 0;
				$this->tax = 0;

				if (!empty($this->item->cartData))
				{
					foreach ($this->item->cartData as $key => $cdata)
					{
						if ($key == 'additionalServices')
						{
							foreach ($cdata as $additionalServices)
							{
								$this->subtotal += $additionalServices->price;
							}
						}
						else
						{
							$room_price = $this->calculateUnitPrice($cdata->room_price) * (int) $cdata->n_rooms;
							$this->subtotal += (float) $room_price;
						}
					}
				}

				$this->tax = ($this->subtotal * (float) $this->item->tax) / 100;
				$this->total = $this->subtotal + $this->tax;
			}
		}
		elseif ($this->item->booking_for == 'package')
		{
			$this->item->package = $payment_model->getPackageInfo($this->item->package_id);

			if (!empty($this->item->cartData) && is_string($this->item->cartData))
			{
				$this->item->cartData = json_decode($this->item->cartData);
			}

			if (!empty($this->item->cartData))
			{
				$this->item->cartData->price      = (int) $this->item->cartData->price;
				$this->item->cartData->sale_price = (int) $this->item->cartData->sale_price;
				$this->price                      = $this->item->cartData->price;
				$this->sale_price                 = $this->item->cartData->sale_price;
				$this->child_price                = (int) $this->item->cartData->child_price;
				$this->child_sale_price           = (int) $this->item->cartData->child_sale_price;
				$this->total_child_price          = 0;
				$this->additional_service         = 0;

				if (!empty($this->sale_price))
				{
					$this->price = $this->sale_price;
				}

				if (!empty($this->child_sale_price))
				{
					$this->child_price = $this->child_sale_price;
				}

				if (!empty($this->item->cartData->additionalServices))
				{
					foreach ($this->item->cartData->additionalServices as $service)
					{
						$this->additional_service += $service->price;
					}
				}

				$this->total_adult_price = $this->price * $this->item->cartData->adult;

				if (!empty($this->child_price))
				{
					$this->total_child_price = $this->child_price * $this->item->cartData->child;
				}

				$this->unit_total = $this->total_adult_price + $this->total_child_price + $this->additional_service;
				$this->subtotal = $this->unit_total;
				$this->tax = ($this->subtotal * (float) $this->item->tax) / 100;
				$this->total = $this->subtotal + $this->tax;
				$this->save_price = $this->item->cartData->price - $this->item->cartData->sale_price;
			}
		}
		elseif ($this->item->booking_for == 'transport')
		{
			$this->item->transport = $payment_model->getTransportInfo($this->item->transport_id);

			if (!empty($this->item->cartData) && is_string($this->item->cartData))
			{
				$this->item->cartData = json_decode($this->item->cartData);
			}

			if (!empty($this->item->cartData))
			{
				$this->item->cartData->price      = (int) $this->item->cartData->price;
				$this->item->cartData->sale_price = (int) $this->item->cartData->sale_price;
				$this->price                      = $this->item->cartData->price;
				$this->sale_price                 = $this->item->cartData->sale_price;
				$this->child_price                = (int) $this->item->cartData->child_price;
				$this->child_sale_price           = (int) $this->item->cartData->child_sale_price;
				$this->pickup_date                = new DateTime($this->item->cartData->pickup_date);
				$this->dropoff_date               = new DateTime($this->item->cartData->dropoff_date);

				$interval = $this->dropoff_date->diff($this->pickup_date);
				$this->total_interval_days = $interval->d;

				if (!empty($this->sale_price))
				{
					$this->price = $this->sale_price;
				}

				if (!empty($this->child_sale_price))
				{
					$this->child_price = $this->child_sale_price;
				}

				$this->subtotal = ($this->price + $this->child_price) * $this->total_interval_days;
				$this->tax = ($this->subtotal * (float) $this->item->tax) / 100;
				$this->total = $this->subtotal + $this->tax;
				$this->save_price = $this->item->cartData->price - $this->item->cartData->sale_price;
			}
		}

		$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/printThis.js');

		return parent::display($tpl = null);
	}

	public function calculateUnitPrice($priceData)
	{
		$price = 0;

		if (!empty($priceData))
		{
			foreach ($priceData as $v)
			{
				$v->special_price = (int) $v->special_price;
				$v->original_price = (int) $v->original_price;
				$v->child_special_price = (int) $v->child_special_price;
				$v->child_price = (int) $v->child_price;
				$total_price = (isset($v->child_val)) ? ($v->original_price + $v->child_price) : $v->original_price;

				if ($v->special_price || $v->child_special_price)
				{
					$price += ($v->special_price > 0 && $v->special_price < $v->original_price) ? $v->special_price : $v->original_price;
					$price += ($v->child_special_price > 0 && $v->child_special_price < $v->child_price && $v->child_val) ? $v->child_special_price : (($v->child_val) ? $v->child_price : 0);
				}
				else
				{
					$price += $total_price;
				}
			}
		}

		return $price;
	}
}

