<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>

<div class="spbooking spbooking-invoice">
	<div id="print-invoice">
		<div class="invoice-title">
			<div class="spbooking-box">
				<div class="spbooking-row">
					<div class="spbooking-col">
						<h4 class="spbooking-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_INVOICE_TITLE'); ?></h4>
					</div>
				</div>
				<div class="spbooking-row text-left">
					<div class="spbooking-col-6">
						<?php if (!empty($this->item->name))
						{
							?>
						<p class="text-mute"><?php echo $this->item->name; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->address))
						{
							?>
						<p class="text-mute"><?php echo $this->item->address; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->phone))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE') . ' - ' . $this->item->phone; ?></p>
						<?php } ?>
					</div>
					<div class="spbooking-col-6 text-right">
						<?php if (!empty($this->item->checkin))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_DATE') . ' - ' . $this->item->checkin; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->checkout))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_DATE') . ' - ' . $this->item->checkout; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->cartData->pickup_location))
						{
							?>
						<p class="text-mute">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_PICKUP_LOCATION') . ': ' . $this->item->cartData->pickup_location . "(" . $this->item->cartData->pickup_date . " " . $this->item->cartData->pickup_time . ")"; ?>
						</p>
						<?php } ?>
						<?php
						if (!empty($this->item->cartData->dropoff_location))
						{
							?>
						<p class="text-mute">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_DROPOFF_LOCATION') . ': ' . $this->item->cartData->dropoff_location . "(" . $this->item->cartData->dropoff_date . " " . $this->item->cartData->dropoff_time . ")"; ?>
						</p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="spbooking-row">
			<div class="spbooking-col">
				<?php if (!empty($this->item->cartData))
				{
					?>
				<div class="spbooking-box">
					<div class="spbooking-table-responsive">
						<table class="spbooking-table" id="invoice-table">
							<thead class="text-left">
								<th><?php echo Text::_('COM_SPBOOKING_TRANSPORT_TITLE'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_TRANSPORT_PERSON'); ?></th>
								<th class="text-right"><?php echo Text::_('COM_SPBOOKING_TRANSPORT_PRICE'); ?></th>
								<th class="text-right"><?php echo Text::_('COM_SPBOOKING_TRANSPORT_GROSS_TOTAL'); ?></th>
							</thead>
							<tbody class="text-left">
								<td>
									<?php if (!empty($this->item->transport->title))
									{
										?>
										<?php echo $this->item->transport->title; ?>
									<?php } ?>
								</td>
								<td>
									<?php if (!empty($this->item->cartData->adult))
									{
										?>
									<small><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></small>
									<?php } ?>
									<?php
									if (!empty($this->item->cartData->child))
									{
										?>
									<small><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></small>
									<?php } ?>
								</td>
								<td class="text-right">
									<!-- Adult -->
									<?php if (!empty($this->item->cartData->sale_price))
									{
										?>
									<small><del><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></del></small>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->sale_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>)
									X
										<?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
									<?php }
									else
									{
										?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>)
									X
										<?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
									<?php } ?>
									<br>
									<!-- Child -->
									<?php
									if ($this->item->cartData->child > 0)
									{
										if (!empty($this->item->cartData->child_sale_price))
										{
											?>
									<small>
										<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price); ?>
										</del>
									</small>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_sale_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') ?>)
									X
											<?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
										<?php }
										else
										{
											?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') ?>)
									X
											<?php echo $this->total_interval_days . ' ' . SpbookingHelper::pluralize($this->total_interval_days, 'COM_SPBOOKING_TRANSPORT_DAY', 'COM_SPBOOKING_TRANSPORT_DAYS'); ?>
										<?php }
									} ?>
								</td>
								<!-- Gross Total -->
								<td class="text-right">
									<!-- Adult -->
									<?php if (!empty($this->item->cartData->sale_price))
									{
										$adult_price = (int) $this->item->cartData->sale_price * $this->total_interval_days;
									}
									else
									{
										$adult_price = (int) $this->item->cartData->price * $this->total_interval_days;
									} ?>
									<span><?php echo SpbookingHelper::formatPrice($adult_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?></span>
									<br>
									<!-- Child -->
									<?php
									if ($this->item->cartData->child > 0)
									{
										if (!empty($this->item->cartData->child_sale_price))
										{
											$child_price = (int) $this->item->cartData->child_sale_price * $this->total_interval_days;
										}
										else
										{
											$child_price = (int) $this->item->cartData->child_price * $this->total_interval_days;
										}
									}?>
									<span><?php echo SpbookingHelper::formatPrice($child_price, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position); ?>
									</span>
								</td>
								<!-- subtotal -->
								<tr>
									<th colspan="2" class="text-left"></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_SUBTOTAL'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- tax info -->
								<tr>
									<th colspan="2" class="text-left"></th>
									<th class="text-right"><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->tax, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total -->
								<tr>
									<th colspan="2" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_TOTAL'); ?></th>
									<th class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
									</th>
								</tr>

								<!-- total paid -->
								<tr>
									<th colspan="2" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord((int) $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total due -->
								<tr>
									<th colspan="2" class="text-left">
										<?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total - $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>

		<div class="spbooking-box is-primary">
			<div class="spbooking-row">
				<div class="spbooking-col-sm-3 text-left">
					<?php echo $this->item->transport->title; ?>
					<?php
					if (!empty($this->item->cartData->adult) || !empty($this->item->cartData->child))
					{
						?>
					<p>
						(<?php if (!empty($this->item->cartData->adult))
						{
							?>
						<small><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></small>
						 <?php } ?>
						<?php
						if (!empty($this->item->cartData->child))
						{
							?>
						<small><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></small>
						<?php } ?>)
					</p>
					<?php } ?>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TOTAL'); ?></span><br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->transport->currency, $this->item->transport->currency_type, $this->item->transport->currency_position, false, 2); ?>
					</h5>
				</div>
			</div>
		</div>
	</div>
	<div class="mt-20">
		<button class="spbooking-btn spbooking-btn-primary print-invoice-button"><i class="fa fa-print"></i> <?php echo Text::_('COM_SPBOOKING_PRINT_INVOICE'); ?></button>
	</div>
</div>


<!-- <div class="spbooking spbooking-invoice">
	<div class="spbooking-row">
		<div class="spbooking-col">
		<?php if (!empty($this->item->cartData))
		{
			?>
			<table class="table table-bordered" id="invoice-table">
				<thead>
					<tr>
						<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_PAYMENT_INFO'); ?></th>
						<th><?php echo Text::_('COM_SPBOOKING_ROOM_PRICE'); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>
							<?php if (!empty($this->item->transport->title))
							{
								?>
								<p class="spbooking-title"><?php echo $this->item->transport->title; ?></p>
							<?php } ?>
							<?php
							if (!empty($this->item->cartData->adult))
							{
								?>
								<p class="text-mute"><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></p>
							<?php } ?>
							<?php
							if (!empty($this->item->cartData->child))
							{
								?>
								<p class="text-mute"><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></p>
							<?php } ?>
							<?php
							if (!empty($this->item->cartData->pickup_location))
							{
								?>
								<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_PAYMENT_PICKUP_LOCATION') . ': ' . $this->item->cartData->pickup_location . "(" . $this->item->cartData->pickup_date . " " . $this->item->cartData->pickup_time . ")"; ?></p>
							<?php } ?>
							<?php
							if (!empty($this->item->cartData->dropoff_location))
							{
								?>
								<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_PAYMENT_DROPOFF_LOCATION') . ': ' . $this->item->cartData->dropoff_location . "(" . $this->item->cartData->dropoff_date . " " . $this->item->cartData->dropoff_time . ")"; ?></p>
							<?php } ?>
						</td>
						<td>
							<?php if (!empty($this->item->cartData->sale_price))
							{
								?>
								<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->price); ?></del>
								<br>
								<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->sale_price); ?></span>
							<?php }
							else
							{
								?>
								<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->price); ?></span>
							<?php } ?>
						</td>
					</tr>
					<tr>
						<th><?php echo Text::_('COM_SPBOOKING_CHECKOUT_SUBTOTAL'); ?></th>
						<td><?php echo SpbookingHelper::formatPrice($this->subtotal); ?></td>
					</tr>
					<tr>
						<th><?php echo Text::sprintf('COM_SPBOOKING_CHECKOUT_TAX', $this->item->tax); ?></th>
						<td><?php echo SpbookingHelper::formatPrice($this->tax); ?></td>
					</tr>
					<tr>
						<th><?php echo Text::sprintf('COM_SPBOOKING_CHECKOUT_TOTAL', $this->item->tax); ?></th>
						<td><?php echo SpbookingHelper::formatPrice($this->total); ?></td>
					</tr>
				</tbody>
			</table> 
			<div class="mt-20">
				<button class="btn btn-success print-invoice-button"><i class="fa fa-print"></i> <?php echo Text::_('COM_SPBOOKING_PRINT_INVOICE'); ?></button>
			</div>
		<?php } ?>
		</div>
	</div>
</div> -->
