<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>

<div class="spbooking spbooking-invoice">
	<div id="print-invoice">
		<div class="invoice-title">
			<div class="spbooking-box">
				<div class="spbooking-row">
					<div class="spbooking-col">
						<h4 class="spbooking-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_INVOICE_TITLE'); ?></h4>
					</div>
				</div>
				<div class="spbooking-row text-left">
					<div class="spbooking-col-6">
						<?php if (!empty($this->item->name))
						{
							?>
						<p class="text-mute"><?php echo $this->item->name; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->address))
						{
							?>
						<p class="text-mute"><?php echo $this->item->address; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->phone))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE') . ' - ' . $this->item->phone; ?></p>
						<?php } ?>
					</div>
					<div class="spbooking-col-6 text-right">
						<?php if (!empty($this->item->checkin))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_INVOICE_START_DATE') . ' - ' . $this->item->checkin; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->checkout))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_INVOICE_END_DATE') . ' - ' . $this->item->checkout; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->cartData->pickup_location))
						{
							?>
						<p class="text-mute">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_PICKUP_LOCATION') . ': ' . $this->item->cartData->pickup_location . "(" . $this->item->cartData->pickup_date . " " . $this->item->cartData->pickup_time . ")"; ?>
						</p>
						<?php } ?>
						<?php
						if (!empty($this->item->cartData->dropoff_location))
						{
							?>
						<p class="text-mute">
							<?php echo Text::_('COM_SPBOOKING_PAYMENT_DROPOFF_LOCATION') . ': ' . $this->item->cartData->dropoff_location . "(" . $this->item->cartData->dropoff_date . " " . $this->item->cartData->dropoff_time . ")"; ?>
						</p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="spbooking-row">
			<div class="spbooking-col">
				<?php if (!empty($this->item->cartData))
				{
					?>
				<div class="spbooking-box">
					<div class="spbooking-table-responsive">
						<table class="spbooking-table" id="invoice-table">
							<thead class="text-left">
								<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_TITLE'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_PERSON'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_PRICE'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_PACKAGE_GROSS_TOTAL'); ?></th>
							</thead>
							<tbody class="text-left">
								<td>
									<?php if (!empty($this->item->package->title))
									{
										?>
										<?php echo $this->item->package->title; ?>
									<?php } ?>
								</td>
								<td>
									<?php if (!empty($this->item->cartData->adult))
									{
										?>
									<small><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></small>
									<?php } ?>
									<?php
									if (!empty($this->item->cartData->child))
									{
										?>
									<small><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></small>
									<?php } ?>
								</td>

								<td class="text-right">
									<!-- Adult -->
									<?php if (!empty($this->item->cartData->sale_price))
									{
										?>
									<small><del><?php echo SpbookingHelper::formatPrice($this->item->cartData->price); ?></del></small>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->sale_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>)
									<?php }
									else
									{
										?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') ?>)
									<?php } ?>
									<br>
									<!-- Child -->
									<?php
									if ($this->item->cartData->child > 0)
									{
										if (!empty($this->item->cartData->child_sale_price))
										{
											?>
									<small>
										<del><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price); ?>
										</del>
									</small>
									<br>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_sale_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') ?>)
										<?php }
										else
										{
											?>
									<span><?php echo SpbookingHelper::formatPrice($this->item->cartData->child_price, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>(<?php echo SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN') ?>)
										<?php }
									} ?>

								</td>
								<!-- Gross Total -->
								<td class="text-right">
									<!-- Adult -->
									<?php if (!empty($this->item->cartData->sale_price))
									{
										?>
									<span><?php echo SpbookingHelper::formatPrice((int) $this->item->cartData->sale_price * (int) $this->item->cartData->adult, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
									<?php }
									else
									{
										?>
									<span><?php echo SpbookingHelper::formatPrice((int) $this->item->cartData->price * (int) $this->item->cartData->adult, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
									<?php } ?>
									<br>
									<!-- Child -->
									<?php
									if ($this->item->cartData->child > 0)
									{
										if (!empty($this->item->cartData->child_sale_price))
										{
											?>
									<span><?php echo SpbookingHelper::formatPrice((int) $this->item->cartData->child_sale_price * (int) $this->item->cartData->child, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
										<?php }
										else
										{
											?>
									<span><?php echo SpbookingHelper::formatPrice((int) $this->item->cartData->child_price * (int) $this->item->cartData->child, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position); ?></span>
										<?php }
									} ?>
								</td>
								<br>

								<!-- Additional Services -->

								<?php if (!empty($this->item->cartData->additionalServices))
								{
									?>
								<tr>
									<?php $sum = 0; ?>
									<td class="text-right"><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'); ?></td>
									<td>
										<?php foreach ($this->item->cartData->additionalServices as $service)
										{
											?>
										<strong class="text-mute"><?php echo $service->title; ?></strong>
										<br>
											<?php $sum += $service->price;
										} ?>
									</td>
									<td></td>
									<td><?php echo SpbookingHelper::formatPrice($sum, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</td>
								</tr>
								<?php } ?>

								<!-- subtotal -->
								<tr>
									<th colspan="2" class="text-left"></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_SUBTOTAL'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- tax info -->
								<tr>
									<th colspan="2" class="text-left"></th>
									<th class="text-right"><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->tax, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total -->
								<tr>
									<th colspan="2" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_TOTAL'); ?></th>
									<th class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</th>
								</tr>

								<!-- total paid -->
								<tr>
									<th colspan="2" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord((int) $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total due -->
								<tr>
									<th colspan="2" class="text-left">
										<?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total - $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>

		<div class="spbooking-box is-primary">
			<div class="spbooking-row">
				<div class="spbooking-col-sm-3 text-left">
					<?php echo $this->item->package->title; ?>
					<p>
						(<?php if (!empty($this->item->cartData->adult))
						{
							?>
						<small><?php echo $this->item->cartData->adult . ' ' . SpbookingHelper::pluralize($this->item->cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></small>
						 <?php } ?>
						<?php
						if (!empty($this->item->cartData->child))
						{
							?>
						<small><?php echo $this->item->cartData->child . ' ' . SpbookingHelper::pluralize($this->item->cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></small>
						<?php } ?>)
					</p>
					<?php if (!empty($this->item->cartData->additionalServices))
					{
						?>
					<p><b><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES') ?></b></p>
						<?php foreach ($this->item->cartData->additionalServices as $service)
						{
							echo $service->title; ?>
					<br>
						<?php } ?>
					<?php } ?>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TOTAL'); ?></span><br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->package->currency, $this->item->package->currency_type, $this->item->package->currency_position, false, 2); ?>
					</h5>
				</div>
			</div>
		</div>
	</div>
	<div class="mt-20">
		<button class="spbooking-btn spbooking-btn-primary print-invoice-button"><i class="fa fa-print"></i> <?php echo Text::_('COM_SPBOOKING_PRINT_INVOICE'); ?></button>
	</div>
</div>
