<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>

<div class="spbooking spbooking-invoice">
	<div id="print-invoice">
		<div class="invoice-title">
			<div class="spbooking-box">
				<div class="spbooking-row">
					<div class="spbooking-col">
						<h4 class="spbooking-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_INVOICE_TITLE'); ?></h4>
					</div>
				</div>
				<div class="spbooking-row text-left">
					<div class="spbooking-col-6">
						<?php if (!empty($this->item->name))
						{
							?>
						<p class="text-mute"><?php echo $this->item->name; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->address))
						{
							?>
						<p class="text-mute"><?php echo $this->item->address; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->phone))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE') . ' - ' . $this->item->phone; ?></p>
						<?php } ?>
					</div>
					<div class="spbooking-col-6 text-right">
						<?php if (!empty($this->item->checkin))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_INVOICE_CHECKIN') . ' - ' . $this->item->checkin; ?></p>
						<?php } ?>
						<?php
						if (!empty($this->item->checkout))
						{
							?>
						<p class="text-mute"><?php echo Text::_('COM_SPBOOKING_INVOICE_CHECKOUT') . ' - ' . $this->item->checkout; ?></p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="spbooking-row">
			<div class="spbooking-col">
				<?php if (!empty($this->item->cartData))
				{
					?>
				<div class="spbooking-box">
					<div class="spbooking-table-responsive">
						<table class="spbooking-table" id="invoice-table">
							<thead class="text-center">
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_TITLE'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_GUESTS'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_NIGHTS'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_PRICE'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_QTY'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_ROOM_GROSS_TOTAL'); ?></th>
							</thead>
							<tbody>
								<?php foreach ($this->item->cartData as $key => $cartData)
								{
									if ($key != 'additionalServices')
									{
										?>
								<tr class="text-center">
									<td>
										<p><?php echo ucfirst($cartData->room_title); ?></p>
									</td>

									<td>
										<?php if (!empty($cartData->adult))
										{
											?>
										<span><?php echo $cartData->adult . ' ' . SpbookingHelper::pluralize($cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></span>
										<?php } ?>
										<?php
										if (!empty($cartData->child))
										{
											?>
										<span><?php echo $cartData->child . ' ' . SpbookingHelper::pluralize($cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></span>
										<?php } ?>
									</td>

									<td>
										<?php if (!empty($cartData->nights))
										{
											?>
										<span><?php echo $cartData->nights . ' ' . SpbookingHelper::pluralize($cartData->nights, 'COM_SPBOOKING_ROOM_NIGHT', 'COM_SPBOOKING_ROOM_NIGHTS'); ?></span>
												<?php
												if (!empty($cartData->room_price) && is_array($cartData->room_price))
												{
													?>
										<p class="text-mute">
											<small>(</small>
													<?php foreach ($cartData->room_price as $index => $v)
													{
														?>
											<small>
														<?php
																		$adult_price = (!empty($v->special_price) && $v->special_price < $v->original_price) ? $v->special_price : $v->original_price;
																		$child_price = (!empty($v->child_special_price) && $v->child_special_price < $v->child_price && $v->child_val) ? $v->child_special_price : $v->child_price; ?>
														<?php echo SpbookingHelper::formatPrice(
															$adult_price,
															$this->item->accomodation_info->currency,
															$this->item->accomodation_info->currency_type,
															$this->item->accomodation_info->currency_position
														); ?>
														<?php
														if ($child_price)
														{
															?> +
															<?php echo SpbookingHelper::formatPrice(
																$child_price,
																$this->item->accomodation_info->currency,
																$this->item->accomodation_info->currency_type,
																$this->item->accomodation_info->currency_position
															);
														} ?>
														<?php
														if ($index < count($cartData->room_price) - 1)
														{
															?>
															<?php echo "+"; ?>
														<?php } ?>
											</small>
													<?php } ?>
											<small>)</small>
										</p>
												<?php } ?>
										<?php } ?>
									</td>
									<td>
										<?php echo SpbookingHelper::formatPrice($this->calculateUnitPrice($cartData->room_price), $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position); ?>
									</td>
									<td>
										<?php echo $cartData->n_rooms . ' ' . SpbookingHelper::pluralize($cartData->n_rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS'); ?>
									</td>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->calculateUnitPrice($cartData->room_price) * (int) $cartData->n_rooms, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position); ?>
									</td>

								</tr>
									<?php }
									else
									{
											$sum = 0; ?>
								<tr class="text-center">
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td>
										<p><b><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES') ?></b></p>
																			<?php foreach ($cartData as $additionalServices)
																			{
																				?>
										<strong class="text-mute"><?php echo $additionalServices->title . '( '; ?></strong>
																				<?php $sum = $sum + $additionalServices->price; ?>
										<span
											class="text-mute"><?php echo SpbookingHelper::formatPrice($additionalServices->price, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position) . ' )'; ?>
										</span>
										<br>
																			<?php } ?>
									</td>
									<td><?php echo SpbookingHelper::formatPrice($sum, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position) ?>
									</td>
								</tr>
									<?php }
								} ?>

								<!-- subtotal -->
								<tr>
									<th colspan="4" class="text-left"></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_SUBTOTAL'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->subtotal, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- tax info -->
								<tr>
									<th colspan="4" class="text-left"></th>
									<th class="text-right"><?php echo Text::sprintf('COM_SPBOOKING_BOOKING_TAX', $this->item->tax . '%'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->tax, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total -->
								<tr>
									<th colspan="4" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_BOOKING_TOTAL'); ?></th>
									<th class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
									</th>
								</tr>

								<!-- total paid -->
								<tr>
									<th colspan="4" class="text-left"><?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord((int) $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
									</td>
								</tr>

								<!-- total due -->
								<tr>
									<th colspan="4" class="text-left">
										<?php echo Text::_('COM_SPBOOKING_IN_WORD') . ': ' . ucwords(SpbookingHelper::numberToWord($this->total - $this->item->total_paid)); ?></th>
									<th class="text-right"><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></th>
									<td class="text-right">
										<?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>

		<div class="spbooking-box is-primary">
			<div class="spbooking-row">
				<div class="spbooking-col-sm-3 text-left">
					<?php if (!empty($this->item->cartData))
					{
						?>
						<?php foreach ($this->item->cartData as $k => $cartData)
						{
							if ($k != 'additionalServices')
							{
								?>
					<p class="">
								<?php echo ucwords($cartData->room_title); ?> <br>
								<?php
								if (!empty($cartData->adult))
								{
									?>
						<small><?php echo $cartData->adult . ' ' . SpbookingHelper::pluralize($cartData->adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></small>
								<?php } ?>
								<?php
								if (!empty($cartData->child))
								{
									?>
						<small><?php echo $cartData->child . ' ' . SpbookingHelper::pluralize($cartData->child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></small>
								<?php } ?>
								<?php
								if (!empty($cartData->nights))
								{
									?>
						<small><?php echo $cartData->nights . ' ' . SpbookingHelper::pluralize($cartData->nights, 'COM_SPBOOKING_ROOM_NIGHT', 'COM_SPBOOKING_ROOM_NIGHTS'); ?></small>
								<?php } ?>
								<?php
								if (!empty($cartData->n_rooms))
								{
									?>
						<small><?php echo $cartData->n_rooms . ' ' . SpbookingHelper::pluralize($cartData->n_rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS'); ?></small>
								<?php } ?>
					</p>
							<?php }
							else
							{
								?>
					<p><b><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'); ?></b></p>
								<?php
								foreach ($cartData as $service)
								{
									?>
									<?php echo $service->title; ?>
					<br>
								<?php }
							}
						} ?>
					<?php } ?>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TOTAL'); ?></span><br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_TOTAL_PAID'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->item->total_paid, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
					</h5>
				</div>
				<div class="spbooking-col-sm-3 text-center">
					<span><?php echo Text::_('COM_SPBOOKING_INVOICE_DUE'); ?></span> <br />
					<h5><?php echo SpbookingHelper::formatPrice($this->total - $this->item->total_paid, $this->item->accomodation_info->currency, $this->item->accomodation_info->currency_type, $this->item->accomodation_info->currency_position, false, 2); ?>
					</h5>
				</div>
			</div>
		</div>
	</div>
	<div class="mt-20">
		<button class="spbooking-btn spbooking-btn-primary print-invoice-button"><i class="fa fa-print"></i> <?php echo Text::_('COM_SPBOOKING_PRINT_INVOICE'); ?></button>
	</div>
</div>
