<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>
    
<div class="spbooking spbooking-icomoon-icons">
    <div class="spbooking-row">
        <div class="spbooking-col-12">
            <h2 class="spbooking-title text-center"><?php echo Text::_('COM_SPBOOKING_ICON_SET'); ?></h2>
            <?php if(!empty($this->icons)) { ?>
                <?php foreach(array_chunk($this->icons, 6) as $icons) { ?>
                    <div class="spbooking-row mt-30">
                        <?php foreach($icons as $key => $icon) { ?>
                            <div class="spbooking-col-lg-2 spbooking-col-md-3 spbooking-col-sm-4">
                                <div class="icon-wrapper">
                                    <span class="copy-msg">Copied to the Clipboard!</span>
                                    <span class="fa fa-clone click-to-copy fa-2x" title="Copy to Clipboard"></span>
                                    <span class="<?php echo $icon; ?> icomoon-5x text-green"></span>
                                    <p class="icon-title"><?php echo str_replace('icomoon-', '', $icon); ?></p>
                                    <input type="hidden" class="original-icon" value="<?php echo $icon; ?>">
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
    </div>
</div>