<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\User\UserHelper;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewCheckout extends HtmlView
{
	protected $item;

	public function display($tpl = null)
	{
		$model  = $this->getModel();
		$doc    = Factory::getDocument();

		$input              = Factory::getApplication()->input;
		$this->checkout_for = $input->get('checkout_for', 'accomodation', 'STRING');
		$accomodation_id = 0;
		$package_id = 0;
		$transport_id = 0;
		$cParams = ComponentHelper::getParams('com_spbooking');
		$currency = $cParams->get('currency', 'USD:$');
		$currency_position = $cParams->get('currency_position', 'left');
		$this->tax = $cParams->get('tax', '', 'INT');

		if ($this->checkout_for == 'accomodation')
		{
			$accomodation_id                         = $input->get('accomodation_id', '', 'INT');
			$this->accomodation_info                 = $model->getAccomodationInfo($accomodation_id);
			$additionalServicesIds                   = $this->accomodation_info->extra_features;
			$this->accomodation_info->extra_features = $model->getAdditionalServices($additionalServicesIds);
			$this->accomodation_tax                  = $this->tax;

			if (!empty($this->accomodation_info->currency))
			{
				$currency = $this->accomodation_info->currency;
			}

			if (!empty($this->accomodation_info->currency_position))
			{
				$currency_position = $this->accomodation_info->currency_position;
			}
		}
		elseif ($this->checkout_for == 'package')
		{
			$package_id                              = $input->get('package_id', '', 'INT');
			$this->package_info                      = $model->getPackageInfo($package_id);
			$additionalServicesIds                   = $this->package_info->additional_services;
			$this->package_info->additional_services = $model->getAdditionalServices($additionalServicesIds);

			// Params
			$this->showTravelInformation             = $cParams->get('travel_information', 1, 'INT');
			$this->showPickupLocation                = $cParams->get('pickup_location', 1, 'INT');
			$this->showPickupDate                    = $cParams->get('pickup_date', 1, 'INT');
			$this->showPickupTime                        = $cParams->get('pickup_time', 1, 'INT');
			$this->showDropOffLocation                   = $cParams->get('dropoff_location', 1, 'INT');
			$this->showDropOffDate                       = $cParams->get('dropoff_date', 1, 'INT');
			$this->showDropOffTime                       = $cParams->get('dropoff_time', 1, 'INT');
			$this->showContactPersonName                 = $cParams->get('contact_person_name', 1, 'INT');
			$this->showContactPersonPhone                = $cParams->get('contact_person_phone', 1, 'INT');

			if (!empty($this->package_info->currency))
			{
				$currency = $this->package_info->currency;
			}

			if (!empty($this->package_info->currency_position))
			{
				$currency_position = $this->package_info->currency_position;
			}
		}
		elseif ($this->checkout_for == 'transport')
		{
			$transport_id = $input->get('transport_id', '', 'INT');
			$this->transport_info = $model->getTransportInfo($transport_id);

			if (!empty($this->transport_info->currency))
			{
				$currency = $this->transport_info->currency;
			}

			if (!empty($this->transport_info->currency_position))
			{
				$currency_position = $this->transport_info->currency_position;
			}
		}

		$currency = explode(':', $currency, 2)[1];

		// If loggedin user then get the first name and last name
		$user = Factory::getUser();
		$this->first_name = '';
		$this->last_name = '';
		$this->user_phone = '';
		$this->user_address = '';
		$this->avaibility = (!empty($this->package_info->availability) ? $this->package_info->availability : '');

		if (!empty($user->id))
		{
			$user_profile = UserHelper::getProfile($user->id)->spbookingprofile;

			if (!empty($user->name))
			{
				$name = explode(" ", $user->name);

				if (!empty($name) && count($name) >= 2)
				{
					$this->last_name = array_pop($name);
					$this->first_name = implode(" ", $name);
				}
			}

			if (!empty($user_profile))
			{
				$this->user_phone = $user_profile['phone'];
				$this->user_address = $user_profile['address'];
			}
		}

		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spcheckout.js');
		$doc->addScriptDeclaration("
            jQuery(function($){
                let adult = 0;
                let child = 0;
                let sum   = 0;
                let avaibility = " . $this->avaibility . "
                
                $('.spboboking-rooms-checkout').spCheckout({
                    total_text: '" . Text::_('COM_SPBOOKING_TOTAL_TEXT') . "',
                    subtotal_text: '" . Text::_('COM_SPBOOKING_SUBTOTAL_TEXT') . "',
                    tax_text: '" . Text::_('COM_SPBOOKING_TAX_TEXT') . "',
                    tax: '" . $this->tax . "',
                    accomodation_id: " . $accomodation_id . ",
                    currency: '" . $currency . "',
                    curr_pos: '" . $currency_position . "',
                });

                $('.spbooking-checkout-package').spCheckout({
                    tax: '" . $this->tax . "',
                    package_id: " . $package_id . "
                });
                $('.spbooking-checkout-transport').spCheckout({
                    tax: '" . $this->tax . "',
                    transport_id: " . $transport_id . "
                });
                $('#adult ,#child').change(function(){
                    adult = $('#adult').val()
                    child = $('#child').val()

                    sum = parseInt(adult) + parseInt(child);                                             
                    
                    $('#sum').val(sum)
                })
                
            });
        "
		);

		return parent::display($tpl = null);
	}
}

