<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>

<div class="spbooking spbooking-checkout-transport">
	<form action="#" class="transport-checkout" id="transport-checkout">
		<!-- user information section -->
		<div class="checkout-customer-information customer-information">
			<div class="spbooking-row">
				<div class="spbooking-col">
					<div class="spbooking-box mt-30">
						<h4 class="is-uppercase"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_INFORMATION'); ?></h4>
						<!-- name row -->
						<div class="spbooking-row">
							<div class="spbooking-col-6">
								<div class="form-group">
									<input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_FIRST_NAME'); ?>"
										value="<?php echo $this->first_name; ?>">
								</div>
							</div>
							<div class="spbooking-col-6">
								<div class="form-group">
									<input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_LAST_NAME'); ?>"
										value="<?php echo $this->last_name; ?>">
								</div>
							</div>
						</div>

						<!-- contact-adult-child row -->
						<div class="spbooking-row">
							<div class="spbooking-col-md-4">
								<div class="form-group">
									<input type="text" class="form-control" name="email" id="email" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_EMAIL'); ?>"
										value="<?php echo !empty(JFactory::getUser()->email) ? JFactory::getUser()->email : ''; ?>">
								</div>
							</div>
							<div class="spbooking-col-md-4">
								<div class="form-group">
									<input type="text" class="form-control" name="phone" id="phone" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE'); ?>"
										value="<?php echo $this->user_phone; ?>">
								</div>
							</div>
							<div class="spbooking-col-6 spbooking-col-md-2">
								<input type="number" class="form-control" name="adult" id="adult" placeholder="<?php echo Text::_('COM_SPBOOKING_ADULT'); ?>">
							</div>
							<div class="spbooking-col-6 spbooking-col-md-2">
								<input type="number" class="form-control" name="child" id="child" placeholder="<?php echo Text::_('COM_SPBOOKING_CHILD'); ?>">
							</div>
						</div>

						<div class="spbooking-row">
							<div class="spbooking-col">
								<div class="form-group">
									<textarea name="customer_address" class="form-control" cols="10" rows="3"
										placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_ADDRESS') ?>"><?php echo $this->user_address; ?></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- travel information -->
		<!-- trasport info -->
		<!-- hide by default -->
		<div class="checkout-travel-information transport-travel customer-information">
			<div class="spbooking-row">
				<div class="spbooking-col">
					<div class="spbooking-box">
						<h4 class="is-uppercase"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TRANSPORT_INFO'); ?></h4>
						<div class="spbooking-box mt-30">
							<!-- pickup row -->
							<div class="spbooking-row">
								<div class="spbooking-col-12 spbooking-col-md-6">
									<div class="form-group">
										<input type="text" class="form-control" name="pickup_location" id="pickup_location"
											placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_LOCATION'); ?>">
									</div>
								</div>
								<div class="spbooking-col-6 spbooking-col-md-3">
									<div class="form-group">
										<input type="text" class="form-control" name="pickup_date" id="pickup_date" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_DATE'); ?>">
									</div>
								</div>
								<div class="spbooking-col-6 spbooking-col-md-3">
									<div class="form-group">
										<input type="text" class="form-control" name="pickup_time" id="pickup_time" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_TIME'); ?>">
									</div>
								</div>
							</div>

							<!-- dropoff row -->
							<div class="spbooking-row">
								<div class="spbooking-col-12 spbooking-col-md-6">
									<div class="form-group">
										<input type="text" class="form-control" name="dropoff_location" id="dropoff_location"
											placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_LOCATION'); ?>">
									</div>
								</div>
								<div class="spbooking-col-6 spbooking-col-md-3">
									<div class="form-group">
										<input type="text" class="form-control" name="dropoff_date" id="dropoff_date" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_DATE'); ?>">
									</div>
								</div>
								<div class="spbooking-col-6 spbooking-col-md-3">
									<div class="form-group">
										<input type="text" class="form-control" name="dropoff_time" id="dropoff_time" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_TIME'); ?>">
									</div>
								</div>
							</div>

							<!-- contact person info -->
							<div class="spbooking-row">
								<div class="spbooking-col-md-6">
									<div class="form-group">
										<input type="text" class="form-control" name="contact_person_name" id="contact_person_name"
											placeholder="<?php echo Text::_('COM_SPBOOKING_PAYPAL_CONTACT_NAME'); ?>">
									</div>
								</div>
								<div class="spbooking-col-md-6">
									<div class="form-group">
										<input type="text" class="form-control" name="contact_person_phone" id="contact_person_phone"
											placeholder="<?php echo Text::_('COM_SPBOOKING_PAYPAL_CONTACT_PHONE'); ?>">
									</div>
								</div>
							</div>
							<div class="spbooking-row">
								<div class="spbooking-col">
									<span class="transport-not-available-msg text-danger"></span>
								</div>
							</div>
						</div>

						<div class="reserve-box">
							<input type="hidden" name="transport_id" value="<?php echo $this->transport_info->id; ?>">
							<input type="hidden" name="price" value="<?php echo $this->transport_info->price; ?>">
							<input type="hidden" name="sale_price" value="<?php echo $this->transport_info->sale_price; ?>">
							<input type="hidden" name="child_price" value="<?php echo $this->transport_info->child_price; ?>">
							<input type="hidden" name="child_sale_price" value="<?php echo $this->transport_info->child_sale_price; ?>">
							<input type="hidden" name="tax" value="<?php echo $this->tax; ?>">
						</div>

						<!-- continue back button row -->
						<div class="spbooking-row mt-30">
							<div class="spbooking-col">
								<button class="spbooking-btn spbooking-btn-primary continue-to-payment pull-right" type="submit"
									id="spbooking-checkout-transport"><?php echo Text::_('COM_SPBOOKING_BTN_CONTINUE'); ?></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
	<div class="spbooking-row">
		<div class="spbooking-col">
			<div class="checkout-message-for-transport"></div>
		</div>
	</div>
</div>
