<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
?>

<div class="spbooking spbooking-checkout-package">
	<div class="spbooking-row mt-preset">
		<div class="spbooking-col">
			<div class="email-verification-message-for-package"></div>
		</div>
	</div>
	<form action="#" class="package-checkout" id="package-checkout">
		<!-- user information section -->
		<div class="checkout-customer-information customer-information">
			<div class="spbooking-row">
				<div class="spbooking-col">
					<div class="spbooking-box mt-30 ">
						<!-- Additional Services --> 
						<?php if (isset($this->package_info->additional_services) && $this->package_info->additional_services)
						{
							?>
							<div class="container">
								<h4 class="sptitle is-uppercase"><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'); ?></h4>
								<div class="row">
									<div class="col-12">
										<table class="table">
											<thead>
												<tr>
													<th scope="col"><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICE'); ?></th>
													<th scope="col"><?php echo Text::_('COM_SPBOOKING_COMMON_PRICE'); ?></th>
													<th scope="col"><?php echo Text::_('COM_SPBOOKING_ADDITIONAL_SERVICES_MAX_QUANTITY'); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php foreach ($this->package_info->additional_services as $key => $additionalService)
												{
													?>
													<tr>
														<td>
															<div class="accommodation-checkout-additionalService-title">
																<input type="checkbox" name="additionalServices[]" class="additionalServices" id="additionalServices<?php echo $key; ?>" value="<?php echo $additionalService->id; ?>" data-price="<?php echo $additionalService->price; ?>" data-title="<?php echo $additionalService->title ?>">
																<label>
																	<?php echo $additionalService->title; ?>
																</label>
															</div>
														</td>
														<td><?php echo $additionalService->price; ?></td>
														<td><?php echo $additionalService->max_quantity; ?></td>
													</tr>
												<?php } ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						<?php } ?>

						<!-- End of Additional Services -->
						<br>
						<h4 class="is-uppercase"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_INFORMATION'); ?></h4>

						<!-- name row -->
						<div class="spbooking-row">
							<div class="spbooking-col-6">
								<div class="form-group">
									<input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_FIRST_NAME'); ?>" value="<?php echo $this->first_name; ?>" require>
								</div>
							</div>
							<div class="spbooking-col-6">
								<div class="form-group">
									<input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_LAST_NAME'); ?>" value="<?php echo $this->last_name; ?>" require>
								</div>
							</div>
						</div>

						<!-- contact-adult-child row -->
						<div class="spbooking-row">
							<div class="spbooking-col-lg-4">
								<div class="form-group">
									<input type="text" class="form-control" name="email" id="email" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_EMAIL'); ?>" value="<?php echo !empty(Factory::getUser()->email) ? Factory::getUser()->email : ''; ?>" require>
								</div>
							</div>
							<div class="spbooking-col-md-3">
								<div class="form-group">
									<input type="text" class="form-control" name="phone" id="phone" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE'); ?>" value="<?php echo $this->user_phone; ?>">
								</div>
							</div>
							<div class="spbooking-col-5 spbooking-col-md-4 spbooking-col-lg-3">
								<div class="form-group">
									<input type="number" class="form-control" name="adult" id="adult" placeholder="<?php echo Text::_('COM_SPBOOKING_ADULT'); ?>" require>

								</div>
							</div>

							<div class="spbooking-col-5 spbooking-col-md-4 spbooking-col-lg-2">
								<div class="form-group">
									<input type="number" class="form-control" name="child" id="child" placeholder=" <?php echo Text::_('COM_SPBOOKING_CHILD'); ?>">
								</div>
							</div>

						</div>

						<div class="spbooking-row">
							<div class="spbooking-col">
								<div class="form-group">
									<textarea name="customer_address" class="form-control" cols="10" rows="3" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_ADDRESS') ?>"><?php echo $this->user_address; ?></textarea>
									<br>
									<input type="hidden" id="avaibility" name="avaibility" value="<?php echo $this->avaibility; ?>">
									<input type="hidden" id="sum" name="sum" />
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>

			<div class="reserve-box">
				<input type="hidden" name="package_id" value="<?php echo $this->package_info->id; ?>">
				<input type="hidden" name="price" value="<?php echo $this->package_info->price; ?>">
				<input type="hidden" name="sale_price" value="<?php echo $this->package_info->sale_price; ?>">
				<input type="hidden" name="child_price" value="<?php echo $this->package_info->child_price; ?>">
				<input type="hidden" name="child_sale_price" value="<?php echo $this->package_info->child_sale_price; ?>">
				<input type="hidden" name="tax" value="<?php echo $this->tax; ?>">
			</div> 
			<!-- travel information -->
			<!-- trasport info -->
			<!-- hide by default -->
			<?php if ($this->showTravelInformation)
			{
				?>
			<div class="checkout-travel-information package-travel customer-information">
				<div class="spbooking-box">
					<div class="spbooking-row">
						<div class="spbooking-col">
							<h4 class="is-uppercase"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_TRANSPORT_INFO'); ?></h4>
							<div class="spbooking-box mt-30">
								<!-- pickup row -->
								<div class="spbooking-row">
									<!-- Show PickUp Location -->
									<?php if ($this->showPickupLocation)
									{
										?>
									<div class="spbooking-col-12 spbooking-col-md-6">
										<div class="form-group">
											<input type="text" class="form-control" name="pickup_location" id="pickup_location" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_LOCATION'); ?>" require>
										</div>
									</div>
									<?php } ?>
									<!-- Show PickUp Date -->
									<?php if ($this->showPickupDate)
									{
										?>
									<div class="spbooking-col-6 spbooking-col-md-3">
										<div class="form-group">
											<input type="text" class="form-control" name="pickup_date" id="pickup_date" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_DATE'); ?>" require>
										</div>
									</div>
									<?php } ?>
									<!-- Show PickUp Time -->
									<?php if ($this->showPickupTime)
									{
										?>
									<div class="spbooking-col-6 spbooking-col-md-3">
										<div class="form-group">
											<input type="text" class="form-control" name="pickup_time" id="pickup_time" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PICKUP_TIME'); ?>" require>
										</div>
									</div>
									<?php } ?>                                  
								</div>

								<!-- dropoff row -->
								<div class="spbooking-row">
									<!-- Show DropOff Location-->
									<?php if ($this->showDropOffLocation)
									{
										?>
									<div class="spbooking-col-12 spbooking-col-md-6">
										<div class="form-group">
											<input type="text" class="form-control" name="dropoff_location" id="dropoff_location" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_LOCATION'); ?>" require>
										</div>
									</div>
									<?php } ?>
									<!-- Show DropOff Date-->
									<?php if ($this->showDropOffDate)
									{
										?>
									<div class="spbooking-col-6 spbooking-col-md-3">
										<div class="form-group">
											<input type="text" class="form-control" name="dropoff_date" id="dropoff_date" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_DATE'); ?>" require>
										</div>
									</div>
									<?php } ?>
									<!-- Show DropOff Time-->
									<?php if ($this->showDropOffTime)
									{
										?>
									<div class="spbooking-col-6 spbooking-col-md-3">
										<div class="form-group">
											<input type="text" class="form-control" name="dropoff_time" id="dropoff_time" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_DROPOFF_TIME'); ?>">
										</div>
									</div>
									<?php } ?>                                
								</div>

								<!-- contact person info -->
								<div class="spbooking-row">
									<!-- Show Contact Person -->
									<?php if ($this->showContactPersonName)
									{
										?>
									<div class="spbooking-col-md-6">
										<div class="form-group">
											<input type="text" class="form-control" name="contact_person_name" id="contact_person_name" placeholder="<?php echo Text::_('COM_SPBOOKING_PAYPAL_CONTACT_NAME'); ?>">
										</div>
									</div>
									<?php } ?>
									<!-- Show Contact Person Phone -->
									<?php if ($this->showContactPersonPhone)
									{
										?>
									<div class="spbooking-col-md-6">
										<div class="form-group">
											<input type="text" class="form-control" name="contact_person_phone" id="contact_person_phone" placeholder="<?php echo Text::_('COM_SPBOOKING_PAYPAL_CONTACT_PHONE'); ?>">
										</div>
									</div>
									<?php } ?>                                   
								</div>
							</div>                                               
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
			<!-- continue back button row -->
			<div class="spbooking-row mt-30">
				<div class="spbooking-col">
					<button class="spbooking-btn spbooking-btn-primary continue-to-payment pull-right" type="submit" id="spbooking-checkout-package"><?php echo Text::_('COM_SPBOOKING_BTN_CONTINUE'); ?></button>
				</div>
			</div>
	</form>
</div>
