<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;

?>

<div class="spboboking-rooms-checkout spbooking">
	<form action="#" class="checkout-form" id="checkout-form">
		<div class="spbooking-row">
			<!-- user input column -->
			<div class="spbooking-col-12 spbooking-col-lg-8 info-container">
				<!-- customer information section -->
				<div class="customer-information">
					<div class="spbooking-box">
						<?php if (isset($this->accomodation_info->extra_features) && $this->accomodation_info->extra_features)
						{
							?>
						<!-- Additional Services -->
						<div class="container">
							<h4 class="sptitle is-uppercase"><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICES'); ?></h4>
							<div class="row">
								<div class="col-12">
									<table class="table">
										<thead>
											<tr>
												<th scope="col"><?php echo Text::_('COM_SPBOOKING_TITLE_ADDITIONALSERVICE'); ?></th>
												<th scope="col"><?php echo Text::_('COM_SPBOOKING_COMMON_PRICE'); ?></th>
												<th scope="col"><?php echo Text::_('COM_SPBOOKING_ADDITIONAL_SERVICES_MAX_QUANTITY'); ?></th>
											</tr>
										</thead>
										<tbody>
											<?php foreach ($this->accomodation_info->extra_features as $key => $additionalService)
											{
												?>
											<tr>
												<td>
													<div class="accommodation-checkout-additionalService-title">
														<input type="checkbox" name="additionalServices[]" class="additionalServices" id="additionalServices<?php echo $key; ?>"
															value="<?php echo $additionalService->id; ?>" data-price="<?php echo $additionalService->price; ?>"
															data-title="<?php echo $additionalService->title ?>">
														<label>
															<?php echo $additionalService->title; ?>
														</label>
													</div>
												</td>
												<td><?php echo $additionalService->price; ?></td>
												<td><?php echo $additionalService->max_quantity; ?></td>
											</tr>
											<?php } ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
						<!-- End of Additional Services -->
						<?php } ?>
						<br>
						<h4 class=" sptitle is-uppercase"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_INFORMATION'); ?></h4>
						<div class="spbooking-row">
							<div class="spbooking-col-12 spbooking-col-md-6">
								<div class="form-group">
									<input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_FIRST_NAME'); ?>"
										value="<?php echo $this->first_name; ?>">
								</div>
							</div>
							<div class="spbooking-col-12 spbooking-col-md-6">
								<div class="form-group">
									<input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_LAST_NAME'); ?>"
										value="<?php echo $this->last_name; ?>">
								</div>
							</div>
						</div>

						<div class="spbooking-row">
							<div class="spbooking-col-12 spbooking-col-md-6">
								<div class="form-group">
									<input type="text" class="form-control" name="email" id="email" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_EMAIL'); ?>"
										value="<?php echo !empty(JFactory::getUser()->email) ? JFactory::getUser()->email : ''; ?>">
								</div>
							</div>
							<div class="spbooking-col-12 spbooking-col-md-6">
								<div class="form-group">
									<input type="text" class="form-control" name="phone" id="phone" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_PHONE'); ?>"
										value="<?php echo $this->user_phone; ?>">
								</div>
							</div>
						</div>

						<div class="spbooking-row">
							<div class="spbooking-col">
								<div class="form-group">
									<textarea name="customer_address" class="form-control" cols="10" rows="3"
										placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_ADDRESS') ?>"><?php echo $this->user_address; ?></textarea>
								</div>
							</div>
						</div>

						<div class="spbooking-row">
							<div class="spbooking-col">
								<div class="form-group">
									<textarea name="customer_comment" class="form-control" cols="10" rows="3" placeholder="<?php echo Text::_('COM_SPBOOKING_CHECKOUT_CUSTOMER_COMMENT') ?>"></textarea>
								</div>
							</div>
						</div>

					</div>
					<div class=" spbooking-row mt-30">
						<div class="spbooking-col">
							<button class="btn checkout-proceed pull-right" id="spbooking-checkout-proceed" type="submit"><?php echo Text::_('COM_SPBOOKING_CHECKOUT_PROCEED'); ?></button>
						</div>
					</div>
				</div>

				<!-- End of Additional Services -->
				<div class="reserve-box">
					<input type="hidden" name="accomodation_id" value="<?php echo $this->accomodation_info->id; ?>">
				</div>
			</div>
			<div class="spbooking-row mt-30">
				<div class="spbooking-col-12">
					<div class="display-compilation-message"></div>
				</div>
			</div>
			<!-- cart information column -->
			<div class="spbooking-col-12 spbooking-col-lg-4">
				<div class="spbooking-cart">
					<div class="cart-header">
						<h4 class="is-title"><?php echo $this->accomodation_info->title; ?></h4>
					</div>
					<div class="cart-body">
					</div>
				</div>
			</div>
			<input type="hidden" name="tax" value="<?php echo $this->accomodation_tax; ?>">
		</div>
	</form>
</div>
