<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Router\Route;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingViewAccomodations extends HtmlView
{
	protected $items;

	protected $pagination;

	public $columns, $cParams;

	public function display($tpl = null)
	{
		$model 			    = $this->getModel();
		$accomodation_model = BaseDatabaseModel::getInstance('Accomodation', 'SpbookingModel');
		$app                = Factory::getApplication();
		$doc                = Factory::getDocument();
		$menu               = $app->getMenu()->getActive();
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->cParams      = ComponentHelper::getParams('com_spbooking');
		$this->columns      = $this->cParams->get('accomodations_columns', 2);
		$this->mParams      = $menu->getParams();
		$this->menuItemId   = SpbookingHelper::getItemId('accomodations');
		$price_from         = 0;
		$this->min_price    = INF;
		$this->max_price    = -INF;

		$this->facilities   = SpbookingHelper::getFacilities('accomodation');
		$this->tags         = SpbookingHelper::getItemTags('accomodation');

		if (!empty($this->items))
		{
			foreach ($this->items as $item)
			{
				$checkin = new Date;
				$checkin = $checkin->format('Y-m-d');
				$checkout = new Date('now +1 day');
				$checkout = $checkout->format('Y-m-d');
				$rooms = SpbookingHelper::getAvailableRooms($checkin, $checkout, $item->id);
				$item->review   = SpbookingHelper::calculateReview($item->id, 'accomodation');

				if (!empty($rooms))
				{
					$original_price = array();
					$special_price = array();

					$item->price_from = 0;
					$item->save_money = 0;

					foreach ($rooms as $room)
					{
						if (!empty($room->original_avg_price) && is_numeric($room->original_avg_price))
						{
							$original_price[] = $room->original_avg_price;
						}

						if (!empty($room->special_avg_price) && is_numeric($room->special_avg_price))
						{
							$special_price[] = $room->special_avg_price;
						}
					}

					$min_original_price = 0;
					$min_special_price = 0;

					if (!empty($special_price))
					{
						$min_special_price = min($special_price);
					}

					if (!empty($original_price))
					{
						$min_original_price = min($original_price);
					}

					if (!empty($min_special_price) && $min_special_price < $min_original_price)
					{
						$item->price_from = $min_special_price;
						$item->save_money = ($min_original_price - $min_special_price);
					}
					else
					{
						$item->price_from = $min_original_price;
					}
				}

				$item->thumb = SpbookingHelper::getThumbs($item->banner, 'thumbnail', '360x348');
			}
		}

		if (!empty($this->items))
		{
			foreach ($this->items as $item)
			{
				$item->url = Route::_('index.php?option=com_spbooking&view=accomodation&view_style=grid&id=' . $item->id . ':' . $item->alias . $this->menuItemId);
			}
		}

		// Global js variable declrations
		$doc->addScriptDeclaration("
            var acMinPrice = '" . $this->min_price . "';
            var acMaxPrice = '" . $this->max_price . "';
        "
		);

		$input          = Factory::getApplication()->input;
		$disableSidebar = $input->get('disable_sidebar', 0, 'INT');

		if ($disableSidebar)
		{
			$this->_layout = 'without_sidebar';
		}

		return parent::display($tpl = null);
	}
}

