<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use SpbookingHelper as Helper;
use Joomla\CMS\Layout\LayoutHelper;

$input = Factory::getApplication()->input;
$view_style = $input->get('view_style', 'grid', 'STRING');

?>

<div class="spbooking spbooking-accomodation-listing">
	<div class="spbooking-row topbar-search-options">
		<div class="spbooking-col-sm-12">
			<?php echo LayoutHelper::render('accomodations.topbar_filter'); ?>
		</div>
	</div>

	<div class="spbooking-row">
		<!-- contents column -->
		<div class="spbooking-col-md-12 spbooking-col-lg-12">
			<div class="head-bar">
				<!-- view style switcher -->
				<div class="view-style-switcher">
					<button class="btn btn-primary view-style-grid <?php echo $view_style == 'grid' ? 'active' : ''; ?>" data-view="accomodations" data-menuitemid="<?php echo str_replace("&Itemid=", "", $this->menuItemId); ?>" type="button"><span class="fa fa-th"></span></button>
					<button class="btn btn-primary view-style-list <?php echo $view_style == 'list' ? 'active' : ''; ?>" data-view="accomodations" data-menuitemid="<?php echo str_replace("&Itemid=", "", $this->menuItemId); ?>" type="button"><span class="fa fa-list"></span></button>
					<span class="text-mute"><?php echo Text::sprintf('COM_SPBOOKING_TOTAL_N_RESULTS_FOUND', count((array) $this->items), Helper::pluralize(count((array) $this->items), 'COM_SPBOOKING_RESULT', 'COM_SPBOOKING_RESULTS')); ?></span>
				</div>
			</div>

			<!-- accomodation contents container -->
			<div class="accomodation-contents">
				<!-- if $this->items has value -->
				<?php if (!empty($this->items))
				{
					?>
					<?php if ($view_style == 'grid')
					{
						?>
						<?php echo LayoutHelper::render('accomodations.grid.listing', array('accomodations' => $this->items, 'columns' => $this->columns)); ?>
					<?php }
					elseif ($view_style == 'list')
					{
						?>
						<?php echo LayoutHelper::render('accomodations.list.listing', array('accomodations' => $this->items, 'columns' => $this->columns)); ?>
					<?php } ?>
				<?php }
				else
				{
					?>
					<div class="spbooking-empty-item">
						<p><?php echo Text::sprintf('COM_SPBOOKING_NO_ITEM_FOUND', Text::_('COM_SPBOOKING_ACCOMODATION')); ?></p>
					</div>
				<?php } ?>
			</div>

			<!-- pagination  -->
			<?php if ($this->pagination->pagesTotal > 1)
			{
				?>
				<div class="pagination">
					<?php echo $this->pagination->getPagesLinks(); ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
