<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingViewAccomodation extends HtmlView
{
	protected $item;

	public function display($tpl = null)
	{
		$model          = $this->getModel();
		$bookings_model = BaseDatabaseModel::getInstance('Bookings', 'SpbookingModel');
		$doc            = Factory::getDocument();
		$input          = Factory::getApplication()->input;
		$this->cParams  = ComponentHelper::getParams('com_spbooking');
		$this->item     = $this->get('Item');
		$this->showRatings    = $this->cParams->get('rating');

		$this->checkin         = $input->get('checkin', '', 'STRING');
		$this->checkout        = $input->get('checkout', '', 'STRING');
		$this->rooms           = $input->get('rooms', 1, 'STRING');
		$this->adult           = $input->get('adults', 1, 'STRING');
		$this->child           = $input->get('child', 0, 'STRING');
		$this->edit_slidershow = $this->cParams->get('edit_slidershow_height_width');			
		
		$this->slideShowWidth  = ($this->cParams->get('slideshow_width') && $this->edit_slidershow  ? $this->cParams->get('slideshow_width') : '');	
		$this->slideShowHeight = ($this->cParams->get('slideshow_height') && $this->edit_slidershow ? $this->cParams->get('slideshow_height') : '');	
		

		$this->item->additional_review  = (!empty($this->item->additional_review) && is_string($this->item->additional_review)) ? json_decode($this->item->additional_review) : array();
		$this->item->certificates       = (!empty($this->item->certificates) && is_string($this->item->certificates)) ? json_decode($this->item->certificates) : array();

		if (!empty($this->item->gallery))
		{
			$this->item->gallery = json_decode($this->item->gallery);
		}

		if (!empty($this->item->facilities))
		{
			$this->item->facilities = json_decode($this->item->facilities);
		}

		if (!empty($this->item->policies))
		{
			$this->item->policies = json_decode($this->item->policies);
		}

		if (!empty($this->item->others))
		{
			$this->item->others = json_decode($this->item->others);
		}

		if (empty($this->checkin) || empty($this->checkout))
		{
			$this->checkin  = new Date;
			$this->checkin  = $this->checkin->format('Y-m-d');
			$this->checkout = new Date('now +1 day');
			$this->checkout = $this->checkout->format('Y-m-d');
		}

		$this->item->rooms = SpbookingHelper::getAvailableRooms($this->checkin, $this->checkout, $this->item->id, $this->rooms, $this->adult, $this->child);
		$this->item->rooms_gallery = array();

		$min_child_price            = 0;
		$min_original_price         = 0;
		$min_special_price          = 0;
		$this->item->sale_price     = 0;
		$this->item->original_price = 0;

		if (!empty($this->item->rooms))
		{
			foreach ($this->item->rooms as $key => $room)
			{
				// Organize room facilities
				if (!empty($room->facilities))
				{
					$room->facilities = explode(',', $room->facilities);
				}

				$room->calculated_price = SpbookingHelper::calculatePriceForDay($room->id, $this->checkin);

				// Pack all the rooms gallery
				$obj = new CMSObject;
				$obj->room_gallery = array();
				$obj->room_title = $room->title;
				$obj->room_image = $room->image;

				if (!empty($room->gallery) && count($this->item->rooms_gallery) < 4)
				{
					$room_gallery = json_decode($room->gallery);
					$obj->room_gallery = $room_gallery;
				}

				$this->item->rooms_gallery[] = $obj;

				// Minimum room price
				$special_price = array();
				$original_price = array();

				if (!empty($room->special_avg_price) && is_numeric($room->special_avg_price))
				{
					$special_price[] = $room->special_avg_price;
				}

				if (!empty($room->child_special_avg_price) && is_numeric($room->child_special_avg_price))
				{
					$child_special_price[] = $room->child_special_avg_price;
				}

				if (!empty($room->original_avg_price) && is_numeric($room->original_avg_price))
				{
					$original_price[] = $room->original_avg_price;
				}

				if (!empty($room->child_avg_price) && is_numeric($room->child_avg_price))
				{
					$child_price[] = $room->child_avg_price;
				}
			}

			if (!empty($special_price))
			{
				$min_special_price = min($special_price);
			}

			if (!empty($child_special_price))
			{
				$min_child_special_price = min($child_special_price);
			}

			if (!empty($original_price))
			{
				$min_original_price = min($original_price);
			}

			if (!empty($child_price))
			{
				$min_child_price = min($child_price);
			}

			// Adult Price
			if (!empty($min_special_price) && $min_special_price < ($min_original_price))
			{
				$this->item->sale_price = $min_special_price;
				$this->item->original_price = $min_original_price;
			}
			else
			{
				$this->item->sale_price = 0;
				$this->item->original_price = $min_original_price;
			}

			// Child Price
			if (!empty($min_child_special_price) && $min_child_special_price < ($min_child_price))
			{
				$this->item->child_sale_price = $min_child_special_price;
				$this->item->child_price = $min_child_price;
			}
			else
			{
				$this->item->child_sale_price = 0;
				$this->item->child_price = $min_child_price;
			}
		}

		$this->item->location = '';

		if (!empty($this->item->city))
		{
			$this->item->location .= $this->item->city . ', ';
		}

		if (!empty($this->item->country))
		{
			$this->item->location .= $this->item->country;
		}

		$this->item->reviews = SpbookingHelper::calculateReview($this->item->id, 'accomodation');

		if (!empty($this->item->map))
		{
			$map_type = $this->cParams->get('maptype', 'google');

			if ($map_type == 'google')
			{
				$gmap_api = $this->cParams->get('gmap_api', '');
				$doc->addScript('//maps.google.com/maps/api/js?libraries=places&key=' . $gmap_api);
			}
			elseif ($map_type == 'osm')
			{
				$doc->addStylesheet('https://unpkg.com/leaflet@1.4.0/dist/leaflet.css');
				$doc->addScript('https://unpkg.com/leaflet@1.4.0/dist/leaflet.js');
			}

			$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spmap.js');
			$doc->addScriptDeclaration("
                jQuery(function($){
                    $(document).spMap({
                        'google_map_id': 'accomodation-google-map',
                        'osm_id': 'accomodation-osm-map',
                        'osm_id': 'accomodation-osm-map',
                        latlng: '" . $this->item->map . "',
                        maptype: '" . $map_type . "',
                        mapbox_token: '" . $this->cParams->get('mapbox_key', '') . "',
                        title: '" . $this->item->title . "',
                        tile_type: '" . $this->cParams->get('map_view', 'streets') . "',
                        zoom: 8
                    });
                });
            "
			);
		}

		$currency = !empty($this->item->currency) ? $this->item->currency : $this->cParams->get('currency', 'USD:$');
		$currency = explode(':', $currency);
		$currency = $currency[1];
		$currency_position = !empty($this->item->currency_position) ? $this->item->currency_position : $this->cParams->get('currency_position', 'left');

		$doc->addScriptDeclaration("var feedbackUrl = '" . Route::_('index.php?option=com_spbooking&task=accomodation.submitFeedback') . "';");
		$doc->addScriptDeclaration("var currency = '" . $currency . "', curr_pos = '" . $currency_position . "';");
		$doc->addStylesheet(Uri::root(true) . '/components/com_spbooking/assets/css/spreview.css');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/feedback.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/spreview.js');
		$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/accomodation-checkout.js');

		return parent::display($tpl = null);
	}
}

