<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;

$slideShowImages   = ($this->slideShowWidth) ? 'spbooking-col-' . $this->slideShowWidth : 'spbooking-col-6';
$height			   = ($this->slideShowHeight) ? $this->slideShowHeight : null;
$emptyRoomsGallery = '';

if (empty($this->item->rooms_gallery)) {
	$emptyRoomsGallery  = "style='margin-right:auto'";
	$slideShowImages    = ($this->slideShowWidth) ? 'spbooking-col-' . ($this->slideShowWidth * 2) : 'spbooking-col-12';
}
?>

<div class="spbooking spbooking-accomodation-details spbooking-view-details spbooking-view-package">
	<!-- package details basic information -->
	<div class="spbooking-container">
		<div class="spbooking-row spbooking-align-center">
			<div class="spbooking-col-12 spbooking-col-lg-9 spbooking-details-top-left">
				<?php if ($this->item->category_title) { ?>
					<h4 class="spbooking-details-category">
						<?php echo $this->item->category_title; ?>
					</h4>
				<?php } ?>

				<p class="spbooking-title"><?php echo $this->item->title; ?></p>

				<div class="spbooking-title-bottom">
					<?php if ($this->item->location) { ?>
						<div class="spbooking-details-location">
							<i class="fa fa-map-marker text-green"></i>&nbsp;<span class="text-mute"><?php echo $this->item->location; ?></span>
						</div>
					<?php } ?>
					<?php if (!empty($this->item->start_date) && $this->item->start_date != '0000-00-00') { ?>
						<div class="spbooking-details-date-wrap">
							<span class="spbooking-details-start-date">
								<i class="fa fa-calendar text-green"></i>&nbsp;<span class="text-mute"><?php echo date('dS M', strtotime($this->item->start_date)); ?></span>
							</span>
							<?php if (!empty($this->item->end_date) && $this->item->end_date != '0000-00-00') { ?>
								-
								<span class="spbooking-details-end-date text-mute">
									<?php echo date('dS M', strtotime($this->item->end_date)); ?>
								</span>
							<?php } ?>
						</div>
					<?php } ?>
				</div> <!-- /.spbooking-title-bottom -->
			</div> <!-- /.spbooking-col-9 -->
			<div class="spbooking-col-12 spbooking-col-lg-3 spbooking-details-top-right">
				<div class="spbooking-price-box text-right">
					<?php if (!empty($this->item->original_price)) { ?>
						<?php if (!empty($this->item->sale_price)) { ?>
							<div class="original-price">
								<del class="text-mute">
									<?php echo SpbookingHelper::formatPrice($this->item->original_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</del>
							</div>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->sale_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?>
							</div>
						<?php } else { ?>
							<div class="sale-price text-green">
								<span>
									<?php echo SpbookingHelper::formatPrice($this->item->original_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position); ?>
								</span> / <?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?>
							</div>
						<?php } ?>
					<?php } ?>
				</div>
				<div class="spbooking-top-right-bottom mt-10">
					<button class="spbooking-btn spbooking-btn-primary spbooking-btn accomodation-global-booknow" type="button"><?php echo Text::_('COM_SPBOOKING_BOOK_NOW_BUTTON'); ?></button>
				</div> <!-- /.spbooking-top-right-bottom  -->
			</div> <!-- /.spbooking-col-3 -->
		</div>
	</div>

	<!-- accomodation gallery -->
	<div class="spbooking-row spbooking-no-gutters accomodation-gallery mt-preset">
		<div class="accomodation-images <?php echo $slideShowImages; ?>" <?php echo $emptyRoomsGallery; ?>>
			<!-- if accomodation gallery situated then display slider -->
			<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $this->item->gallery, 'title' => $this->item->title, 'banner_image' => $this->item->banner, 'modifier_class' => 'ac-gallery', 'show_title' => false, 'height' => $height)); ?>
		</div>
		<?php if (!empty($this->item->rooms_gallery)) { ?>
			<div class="room-images <?php echo $slideShowImages; ?>">
				<!-- rooms gallery -->
				<!-- if there are one room then full 6 cols -->
				<?php if (count($this->item->rooms_gallery) == 1) { ?>
					<?php foreach ($this->item->rooms_gallery as $gallery) { ?>
						<div class="spbooking-row spbooking-no-gutters accomodation-single-room">
							<div class="spbooking-col-12">
								<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g11','height' => $height)); ?>
							</div>
						</div>
					<?php } ?>
				<?php } elseif (count($this->item->rooms_gallery) == 2) { ?>
					<?php foreach ($this->item->rooms_gallery as $key => $gallery) { ?>
						<div class="spbooking-row spbooking-no-gutters">
							<div class="spbooking-col-12">
								<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g1' . ($key + 1),'height' => $height/2)); ?>
							</div>
						</div>
					<?php } ?>
				<?php } elseif (count($this->item->rooms_gallery) == 3) { ?>
					<?php foreach ($this->item->rooms_gallery as $key => $gallery) { ?>
						<?php if ($key == 0) { ?>
							<div class="spbooking-row spbooking-no-gutters">
								<div class="spbooking-col-6">
									<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g11','height' => $height/2)); ?>
								</div>
							<?php } ?>
							<?php if ($key == 1) { ?>
								<div class="spbooking-col-6">
									<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g12','height' => $height/2)); ?>
								</div>
							</div>
						<?php } ?>
						<?php if ($key == 2) { ?>
							<div class="spbooking-row spbooking-no-gutters">
								<div class="spbooking-col-12">
									<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g13','height' => $height/2)); ?>
								</div>
							</div>
						<?php } ?>
					<?php } ?>
				<?php } elseif (count($this->item->rooms_gallery) >= 4) { ?>
					<?php foreach ($this->item->rooms_gallery as $key => $gallery) { ?>
						<?php if ($key == 4) {
							break;
						}
						elseif ($key % 2 == 0) { ?>
							<?php if ($key > 0) { ?>
			</div>
		<?php } ?>
		<div class="spbooking-row spbooking-no-gutters">
			<div class="spbooking-col-6">
				<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g1' . ($key + 1),'height' => $height/2)); ?>
			</div>
		<?php } else { ?>
			<div class="spbooking-col-6">
				<?php echo LayoutHelper::render('gallery.gallery', array('gallery' => $gallery->room_gallery, 'title' => $gallery->room_title, 'banner_image' => $gallery->room_image, 'modifier_class' => 'accomodation-room ac-g1' . ($key + 1),'height' => $height/2)); ?>
			</div>
		<?php } ?>
	<?php } ?>
<?php } ?>
		</div>
	<?php } ?>
	</div>

	<div class="spbooking-container">
		<!-- accomodation overview  -->
		<div class="spbooking-row accomodation-overview mt-preset">
			<!-- accomodation-description -->
			<?php // Generate columns
			if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) == 1) {
				$left_col = 6;
				$right_col = 3;
				$review_col = 3;
			} else {
				$left_col = 9;
				$right_col = 3;
				$review_col = 12;
			}
			?>

			<div class="spbooking-col-md-12 spbooking-col-lg-6">
				<h4 class="overview is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_OVERVIEW_TITLE'); ?></h4>
				<?php
				if (!empty($this->item->description)) { ?>
					<div class="description"><?php echo $this->item->description; ?></div>
				<?php } ?>
			</div>

			<!-- overall rating  -->
			<?php if ($this->showRatings) { ?>
				<div class="spbooking-col spbooking-col-md-6 spbooking-col-lg-<?php echo $right_col; ?>">
					<div class="overall-rating">
						<div class="spbooking-box">
							<p class="title"><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></p>
							<h1 class="rating"><?php echo $this->item->reviews['average_rating']; ?><small>/5</small></h1>
							<?php
							foreach (range(1, 5) as $key => $rating) { ?>
								<?php if ($rating <= $this->item->reviews['average_rating']) { ?>
									<span class="fa fa-star is-filled"></span>
								<?php } elseif ($rating > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $rating - 1) { ?>
									<span class="fa fa-star-half-o is-filled"></span>
								<?php } else { ?>
									<span class="fa fa-star-o"></span>
								<?php } ?>
							<?php } ?>
							<p class="total-reivews"><?php echo "(" . $this->item->reviews['total_reviews'] . " " . SpbookingHelper::pluralize($this->item->reviews['total_reviews'], 'COM_SPBOOKING_TOTAL_REVIEW_TEXT', 'COM_SPBOOKING_TOTAL_REVIEWS_TEXT') . ")"; ?></p>
						</div>
					</div>
				</div>
			<?php } ?>

			<!-- accomodation oscars -->
			<?php if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) == 1) { ?>
				<!-- oscars -->
				<div class="spbooking-col-md-6 spbooking-col-lg-<?php echo $review_col; ?> spbooking-item-certificates">
					<div class="package-award">
						<div class="spbooking-box">
							<?php foreach ($this->item->certificates as $certificate) {
							?>
								<img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
							<?php } ?>
						</div>
					</div>
				</div><!-- /.spbooking-col- -->
			<?php } ?>
		</div>

		<?php if (!empty($this->item->certificates) && $this->item->certificates && count((array) $this->item->certificates) > 1) { ?>
			<!-- package overview -->
			<div class="spbooking-row spbooking-item-certificates">
				<?php foreach ($this->item->certificates as $certificate) { ?>
					<div class="spbooking-col-sm-3 mt-20">
						<img src="<?php echo $certificate->image; ?>" alt="<?php echo $certificate->name; ?>">
					</div>
				<?php } ?>
			</div> <!-- /.spbooking-row -->
		<?php } ?>

		<!-- accomodation amenities -->
		<div class="spbooking-row accomodation-amenities mt-preset">
			<div class="spbooking-col-sm-12">
				<h4 class="amenities is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_AMENITIES'); ?></h4>
				<?php
				if (!empty($this->item->facilities) && is_object($this->item->facilities)) { ?>
					<div class="amenities-wrapper">
						<div class="spbooking-row">
							<?php foreach ($this->item->facilities as $facility) { ?>
								<div class="spbooking-col-6 spbooking-col-md-4 spbooking-col-lg-3">
									<div class="amenities-holder">
										<?php if (!empty($facility->icon_image)) { ?>
											<?php if ($facility->icon_image == 'icon') { ?>
												<?php if (!empty($facility->icon)) { ?>
													<span class="amenities-icon <?php echo $facility->icon; ?>"></span>
												<?php } ?>
											<?php } elseif ($facility->icon_image == 'image') { ?>
												<?php if (!empty($facility->image)) { ?>
													<img src="<?php echo Uri::root() . $facility->image; ?>" alt="">
												<?php } ?>
											<?php } ?>
										<?php } ?>

										<?php if (!empty($facility->key)) { ?>
											<span><?php echo $facility->key; ?></span>
										<?php } ?>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>

		<!-- accomodation location map row  -->
		<?php if (!empty($this->item->map)) { ?>
			<div class="spbooking-row">
				<div class="spbooking-col-12">
					<?php if ($this->cParams->get('maptype', 'google') == 'google') { ?>
						<div id="accomodation-google-map"></div>
					<?php } else { ?>
						<div id="accomodation-osm-map"></div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>


		<!-- accomodation available rooms -->
		<div class="spbooking-row accomodation-available-rooms mt-preset" id="available-rooms">
			<input type="hidden" class="accomodation-id" value="<?php echo $this->item->id; ?>">
			<input type="hidden" class="accomodation-slug" value="<?php echo $this->item->id . ':' . $this->item->alias; ?>">
			<div class="spbooking-col-sm-12">
				<h4 class="available-rooms-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_AVAILABLE_ROOMS'); ?></h4>
				<ul class="list-group">
					<!-- check checkin-checkout availability -->
					<li class="list-group-item no-border">
						<div class="checkin-out-range mb-10">
							<div class="spbooking-row">
								<div class="spbooking-col-md-6 spbooking-offset-md-3 range-input">
									<input name="checkin-range" type="text" class="accomodation-checkin-out-range form-control" placeholder="Check-in/Check-out" data-checkin="<?php echo $this->checkin; ?>" data-checkout="<?php echo $this->checkout; ?>">
									<div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
								</div>
							</div>
						</div>
					</li>

					<!-- header info -->
					<li class="list-group-item no-bd only-title">
						<div class="spbooking-row rooms-info-header">
							<div class="spbooking-col-sm-3">
								<h4 class="included"><?php echo Text::_("COM_SPBOOKING_ACCOMODATION_WHAT_INCLUDED_TITLE"); ?></h4>
							</div>
							<div class="spbooking-col-sm-3">
								<h4 class="capacity"><?php echo Text::_("COM_SPBOOKING_ACCOMODATION_CAPACITY_TITLE"); ?></h4>
							</div>
							<div class="spbooking-col-sm-3">
								<h4 class="rooms"><?php echo Text::_("COM_SPBOOKING_ACCOMODATION_ROOM_TITLE"); ?></h4>
							</div>
							<div class="spbooking-col-sm-3">
								<h4 class="price"><?php echo Text::_("COM_SPBOOKING_ACCOMODATION_PRICE_TITLE"); ?></h4>
							</div>
						</div>
					</li>

					<?php foreach ($this->item->rooms as $room) { ?>
						<li class="list-group-item">
							<div class="spbooking-row rooms-info-body" id="room-<?php echo $room->id; ?>">
								<!-- whats inculded -->
								<div class="spbooking-col-md-3">
									<h5 class="title"><?php echo $room->title; ?></h5>
									<p class="rooms-available <?php echo $room->available_rooms < 1 ? 'text-red' : ''; ?>"><?php echo Text::sprintf('COM_SPBOOKING_N_ROOM_AVAILABLE', $room->available_rooms, SpbookingHelper::pluralize($room->available_rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS')); ?></p>
									<p class="room-services">
										<?php if (!empty($room->facilities)) { ?>
											<?php foreach ($room->facilities as $facility) { ?>
												<span><?php echo trim($facility); ?></span>
											<?php } ?>
										<?php } ?>
									</p>
								</div>

								<!-- capacity -->
								<div class="spbooking-col-md-3">
									<div class="spbooking-row">
										<div class="spbooking-col">
											<!-- adult -->
											<select name="accomodation-room-adult" id="" class="spbooking-select form-control accomodation-room-adult">
												<option value=""><?php echo Text::_('COM_SPBOOKING_SELECT_ADULT'); ?></option>
												<?php for ($index = 1; $index <= $room->adult; $index++) { ?>
													<option value="<?php echo $index; ?>" <?php echo !empty($this->adult) && $this->adult == $index ? 'selected' : ''; ?>><?php echo $index . ' ' . SpbookingHelper::pluralize($index, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?></option>
												<?php } ?>
											</select>
										</div>
										<div class="spbooking-col">
											<!-- child -->
											<select name="accomodation-room-child" id="" class="spbooking-select form-control accomodation-room-child">
												<option value=""><?php echo Text::_('COM_SPBOOKING_SELECT_CHILD'); ?></option>
												<?php for ($index = 1; $index <= $room->child; $index++) { ?>
													<option value="<?php echo $index; ?>" <?php echo !empty($this->child) && $this->child == $index ? 'selected' : ''; ?>><?php echo $index . ' ' . SpbookingHelper::pluralize($index, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
								</div>

								<!-- rooms -->
								<div class="spbooking-col-md-3">
									<select class="spbooking-select form-control select-nrooms">
										<option value=""><?php echo Text::_('COM_SPBOOKING_SELECT_AVAILABLE_ROOMS'); ?></option>
										<?php for ($index = 1; $index <= $room->available_rooms; $index++) { ?>
											<option value="<?php echo $index; ?>" <?php echo !empty($this->rooms) && $this->rooms == $index ? 'selected' : ''; ?>><?php echo $index . ' ' . SpbookingHelper::pluralize($index, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS'); ?></option>
										<?php } ?>
									</select>
								</div>

								<!-- price  -->
								<div class="spbooking-col-md-3">
									<div class="sale-price text-green">
										<!-- Adult Special Price -->
										<?php if (!empty($room->special_avg_price)) { ?>
											<?php if ($room->special_avg_price < $room->original_avg_price) { ?>
												<del class="text-mute"><?php echo SpbookingHelper::formatPrice($room->original_avg_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position, false, 2); ?>
												</del>
												<br>
											<?php } ?>
											<span>
												<?php echo SpbookingHelper::formatPrice(
													$room->special_avg_price,
													$this->item->currency,
													$this->item->currency_type,
													$this->item->currency_position,
													false,
													2
												); ?>
											</span>/<?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?> (<?php echo Text::_('COM_BOOKING_ROOM_FOR_ADULT'); ?>)
											<br>
										<?php } else { ?>
											<span><?php echo SpbookingHelper::formatPrice(
														$room->original_avg_price,
														$this->item->currency,
														$this->item->currency_type,
														$this->item->currency_position,
														false,
														2
													); ?></span>/<?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?> (<?php echo Text::_('COM_BOOKING_ROOM_FOR_ADULT'); ?>)
											<br>
										<?php } ?>

										<br>

										<!-- Child Special Price -->

										<?php if (!empty($room->child_special_avg_price)) { ?>
											<?php if ($room->child_special_avg_price < $room->child_avg_price) { ?>
												<del class="text-mute"><?php echo SpbookingHelper::formatPrice($room->child_avg_price, $this->item->currency, $this->item->currency_type, $this->item->currency_position, false, 2); ?>
												</del>
												<br>

											<?php } ?>

											<span>
												<?php echo SpbookingHelper::formatPrice(
														$room->child_special_avg_price,
														$this->item->currency,
														$this->item->currency_type,
														$this->item->currency_position,
														false,
														2
													); ?></span>/<?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?> (<?php echo Text::_('COM_BOOKING_ROOM_FOR_CHILD'); ?>)

										<?php } 
										elseif (!empty($room->child_avg_price)) { ?>
											<span><?php echo SpbookingHelper::formatPrice(
														$room->child_avg_price,
														$this->item->currency,
														$this->item->currency_type,
														$this->item->currency_position,
														false,
														2
													); ?></span>/<?php echo Text::_('COM_SPBOOKING_ROOM_NIGHT'); ?> (<?php echo Text::_('COM_BOOKING_ROOM_FOR_CHILD'); ?>)
										<?php } ?>
									</div>
									<button class="btn btn-success spbooking-room-booknow" <?php echo ($room->available_rooms > 0 ? '' : 'disabled'); ?> title="<?php echo ($room->available_rooms > 0 ? 'Book now' : 'No Room Available'); ?>"><?php echo Text::_('COM_SPBOOKING_BOOK_NOW_BUTTON'); ?></button>
								</div>

								<!-- reserve info box -->
								<div class="reserve-info-box">
									<input type="hidden" class="accomodation-room-title" value="<?php echo $room->title; ?>">
									<input type="hidden" class="accomodation-room-id" value="<?php echo $room->id; ?>">
									<input type="hidden" class="accomodation-room-price" value="<?php echo base64_encode(json_encode($room->c_price)); ?>">
								</div>
							</div>
						</li>
					<?php } ?>
				</ul>
			</div>
		</div>

		<!-- accomodation policies -->

		<div class="spbooking-row accomodation-policies mt-preset">
			<div class="spbooking-col">
				<?php if (!empty($this->item->policies)) { ?>
					<h4 class="is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_POLICIES'); ?></h4>
					<table class="table table-bordered mt-30">
						<?php foreach ($this->item->policies as $policy) { ?>
							<tr>
								<th width="30%">
									<?php if (!empty($policy->icon_image)) { ?>
										<?php if ($policy->icon_image == 'icon') { ?>
											<span class="text-green <?php echo $policy->icon; ?>"></span>
										<?php } else { ?>
											<img src="<?php echo $policy->image; ?>" alt="">
										<?php } ?>
									<?php } ?>
									<?php echo " " . $policy->key; ?>
								</th>
								<td width="70%"><?php echo $policy->value; ?></td>
							</tr>
						<?php } ?>
					</table>
				<?php } ?>
			</div>
		</div>

		<!-- accomodation other informations -->

		<div class="spbooking-row accomodation-amenities mt-preset">
			<div class="spbooking-col-sm-12">
				<?php if (!empty($this->item->others) && is_object($this->item->others)) { ?>
					<h4 class="amenities is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_OTHERS'); ?></h4>
					<div class="amenities-wrapper">
						<div class="spbooking-row">
							<?php foreach ($this->item->others as $other_info) { ?>
								<div class="spbooking-col-6 spbooking-col-md-4 spbooking-col-lg-3">
									<div class="accomodation-other-holder">
										<div class="icon-image-wrap">
											<?php if (!empty($other_info->icon_image)) { ?>
												<?php if ($other_info->icon_image == 'icon') { ?>
													<?php if (!empty($other_info->icon)) { ?>
														<span class="other-info-icon <?php echo $other_info->icon; ?>"></span>
													<?php } ?>
												<?php } elseif ($other_info->icon_image == 'image') { ?>
													<?php if (!empty($other_info->image)) { ?>
														<img src="<?php echo Uri::root() . $other_info->image; ?>" alt="">
													<?php } ?>
												<?php } ?>
											<?php } ?>
										</div>

										<?php if (!empty($other_info->key)) { ?>
											<h4 class="other-info-title"><?php echo $other_info->key; ?></h4>
										<?php } ?>
										<?php if (!empty($other_info->value)) { ?>
											<p class="other-info-description"><strong><?php echo $other_info->value; ?></strong></p>
										<?php } ?>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
		<!-- / accomodation other information -->

		<!-- accomodation cart -->
		<div class="accomodation-cart">
			<div class="cart-mini">
				<span class="fa fa-times-circle fa-2x cart-close"></span>
			</div>
			<div class="cart-header">

			</div>
			<div class="cart-body">

			</div>
			<div class="cart-footer">

			</div>
		</div>

		<!-- display review information -->
		<?php if ($this->showRatings) { ?>
			<div class="spbooking-row review-displays">
				<div class="spbooking-col-md-4 spbooking-col-lg-3">
					<div class="overall-rating">
						<div class="spbooking-box">
							<p class="title"><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></p>
							<h1 class="rating"><?php echo $this->item->reviews['average_rating']; ?><small>/5</small></h1>
							<?php foreach (range(1, 5) as $key => $rating) { ?>
								<?php if ($rating <= $this->item->reviews['average_rating']) { ?>
									<span class="fa fa-star is-filled"></span>
								<?php } 
								elseif ($rating > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $rating - 1) {
								?>
									<span class="fa fa-star-half-o is-filled"></span>
								<?php } else { ?>
									<span class="fa fa-star-o"></span>
								<?php } ?>
							<?php } ?>
							<p class="total-reivews"><?php echo "(" . $this->item->reviews['total_reviews'] . " " . Text::_('COM_SPBOOKING_ACCOMODATION_TOTAL_REVIEWS_TEXT') . ")"; ?></p>
						</div>
					</div>
				</div>

				<!-- rating breakdown -->
				<div class="spbooking-col-md-8 spbooking-col-lg-5">
					<div class="rating-breakdown">
						<div class="spbooking-box">
							<p class="title"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_RATING_BREAKDOWN_TITLE'); ?></p>
							<?php if (!empty($this->item->reviews['rating_breakdown'])) { ?>
								<?php $breakdown = $this->item->reviews['rating_breakdown'];
								$i = 0; ?>
								<ul class="rating-breakdown-list">
									<?php foreach (range(5, 1) as $index) { ?>
										<li class="rating-breakdown-item">
											<div class="star-info"><?php echo $index; ?> <span class="fa fa-star is-filled"></span> </div>
											<?php if ($breakdown[$index] != 0) { ?>
												<progress class="rt-progress-bar" max="100" value="<?php echo round($breakdown[$index] * 100 / array_sum($breakdown)) ?>">
												</progress>
											<?php } ?>
											<div class="rt-br-rating-count">
												<span><?php echo $breakdown[$index]; ?></span>
											</div>
										</li>
									<?php } ?>
								</ul>
							<?php } ?>
						</div>
					</div>
				</div>

				<!-- traveller review -->
				<div class="spbooking-col-lg-4">
					<div class="rating-travellers-rating">
						<div class="spbooking-box">
							<p class="title"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_TRAVELLER_RATING_TITLE'); ?></p>
							<?php
							$traveller_review = !empty($this->item->reviews['traveller_review']) ? $this->item->reviews['traveller_review'] : array();
							$total_review = !empty($this->item->reviews['total_reviews']) ? $this->item->reviews['total_reviews'] : 1;
							$average_travellers_review = !empty($this->item->reviews['average_traveller_review']) ? $this->item->reviews['average_traveller_review'] : array();
							?>
							<?php if (!empty($traveller_review)) { ?>
								<ul class="traveller-review-list">
									<?php foreach ($traveller_review as $key => $trv) { ?>
										<?php
										$divideBY = ($average_travellers_review[$key]) ? $average_travellers_review[$key] : $total_review;
										$rating_point = round($trv / $divideBY);
										$review_categories = SpbookingHelper::getReviewOptions(array('safty_security' => 'Safety and Security', 'maintenance' => 'Maintenance', 'cleanliness' => 'Cleanliness', 'service' => 'Service', 'hospitality' => 'Hospitality'));
										?>
										<li class="traveller-review-item">
											<div class="review-category"><?php echo $review_categories[$key]; ?></div>
											<div class="review-count">
												<?php foreach (range(1, 5) as $index) { ?>
													<span class="fa fa-smile-o <?php echo $index <= $rating_point ? 'is-filled' : ''; ?>"></span>
												<?php } ?>
											</div>
										</li>
									<?php } ?>
								</ul>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>

		<?php if (!empty($this->item->reviews['reviews'])) { ?>
			<!-- user comments -->
			<div class="spbooking-row accomodation-user-comments">
				<div class="spbooking-col-sm-12">
					<p class="user-comments-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_COMMENTS') . " (" . $this->item->reviews['total_reviews'] . ")"; ?></p>
					<ul class="user-comment-list list-group">
						<?php foreach ($this->item->reviews['reviews'] as $comment) { ?>
							<li class="user-comment-item list-group-item">
								<div class="comment-header">
									<img class="img-round" src="<?php echo Uri::root() . 'components/com_spbooking/assets/images/default.png'; ?>" alt="">
									<p class='user-name'><?php echo $comment->user_name; ?></p>
									<small class="comment-date text-mute"><?php echo HTMLHelper::_('date', $comment->created, 'jS M, Y'); ?></small>
								</div>
								<?php if (!empty($comment->review)) { ?>
									<div class="comment-body mt-10">
										<p><?php echo $comment->review; ?></p>
									</div>
								<?php } ?>

								<?php if (!empty($comment->inner_rating) && $this->showRatings) { ?>
									<?php foreach (range(1, 5) as $index) { ?>
										<?php if ($index <= $comment->inner_rating) { ?>
											<span class="fa fa-star is-filled"></span>
										<?php } elseif ($index > $comment->inner_rating && $comment->inner_rating > $index - 1) { ?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php } else { ?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
									<strong><?php echo $comment->inner_rating; ?></strong>
								<?php } ?>
							</li>
						<?php } ?>
					</ul>
				</div>
			</div>
		<?php } ?>

		<!-- give feedback form -->
		<!-- if review enabled -->
		<?php if (!empty($this->cParams->get('review', 1))) {
			$review_categories_feedback = SpbookingHelper::getReviewOptions(array('safty_security' => 'Safety and Security', 'maintenance' => 'Maintenance', 'cleanliness' => 'Cleanliness', 'service' => 'Service', 'hospitality' => 'Hospitality'));
		?>
			<!-- if guest review disabled -->
			<?php if ($this->cParams->get('guest_review', 0) == 0) { ?>
				<!-- if user logged in -->
				<?php if (Factory::getUser()->id > 0) { ?>
					<div class="spbooking-row user-feedback">
						<div class="spbooking-col-sm-12">
							<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
							<form action="#" class="feedback-form" id="feedback-form">
								<div class="feedback-first-formgroup">
									<div class="form-group overall-rating">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

										<?php foreach (range(1, 5) as $index) { ?>
											<?php if ($index <= $this->item->reviews['average_rating']) { ?>
												<span class="fa fa-star is-filled"></span>
											<?php } elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1) { ?>
												<span class="fa fa-star-half-o is-filled"></span>
											<?php } else { ?>
												<span class="fa fa-star-o"></span>
											<?php } ?>
										<?php } ?>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
										<ul class="review-categories-list">
											<?php foreach ($review_categories_feedback as $k => $value) { ?>
												<li class="review-list-item">
													<span class="review-list-item-title" data-alias="<?php echo $k; ?>"><?php echo $value; ?> </span>
													<input type="hidden" name="review_categories[]" value="<?php echo $k; ?>">
												</li>
											<?php } ?>
										</ul>
									</div>

									<div class="form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
										<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
									</div>
								</div>

								<div class="feedback-second-formgroup">
									<div class="form-row form-group">
										<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
										<div class="group-row">
											<div class="row">
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
												<div class="col">
													<div class="reserve-box">
														<input type="hidden" name="accomodation_id" value="<?php echo $this->item->id; ?>">
														<input type="hidden" name="review_for" value="accomodation">
													</div>

													<div class="form-group submit-button-wrap">
														<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
													</div>
												</div>
											</div>
										</div>
									</div>
							</form>
						</div>
					</div>
				<?php } else {
				?>
					<p class="login-message">
						<?php $link = base64_encode(Route::_('index.php?option=com_spbooking&view=accomodation&id=' . $this->item->id . SpbookingHelper::getItemid('accomodations'))); ?>
						<?php $login_link = Route::_('index.php?option=com_users&view=login' . SpbookingHelper::getItemid('login') . '&return=' . $link); ?>
						<?php echo Text::sprintf('COM_SPBOOKING_LOGIN_FOR_FEEDBACK', $login_link); ?>
					</p>
				<?php } ?>
			<?php } else {
			?>
				<!-- if guest review allowed -->
				<div class="spbooking-row user-feedback">
					<div class="spbooking-col-sm-12">
						<label class="give-feedback-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_TITLE'); ?></label>
						<form action="#" class="feedback-form" id="feedback-form">
							<div class="feedback-first-formgroup">
								<div class="form-group overall-rating">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCMODATION_OVERALL_RATING'); ?></label>

									<?php foreach (range(1, 5) as $index) { ?>
										<?php if ($index <= $this->item->reviews['average_rating']) { ?>
											<span class="fa fa-star is-filled"></span>
										<?php } elseif ($index > $this->item->reviews['average_rating'] && $this->item->reviews['average_rating'] > $index - 1) { ?>
											<span class="fa fa-star-half-o is-filled"></span>
										<?php } else { ?>
											<span class="fa fa-star-o"></span>
										<?php } ?>
									<?php } ?>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_RATING'); ?></label>
									<ul class="review-categories-list">
										<?php foreach ($review_categories_feedback as $rcfk => $value) { ?>
											<li class="review-list-item">
												<span class="review-list-item-title" data-alias="<?php echo $rcfk; ?>"><?php echo $value; ?> </span>
												<input type="hidden" name="review_categories[]" value="<?php echo $rcfk; ?>">
											</li>
										<?php } ?>
									</ul>
								</div>

								<div class="form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK'); ?></label>
									<textarea name="review" id="feedback" cols="10" rows="7" class="form-control"></textarea>
								</div>
							</div>

							<div class="feedback-second-formgroup">
								<div class="form-row form-group">
									<label for=""><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_FEEDBACK_PERSONAL_INFO'); ?></label>
									<div class="group-row">
										<div class="row">
											<?php if (Factory::getUser()->id > 0) { ?>
												<input type="hidden" name="user_name" value="<?php echo Factory::getUser()->name; ?>">
												<input type="hidden" name="user_email" value="<?php echo Factory::getUser()->email; ?>">
											<?php } else { ?>
												<div class="col-md-6">
													<input type="text" class="form-control" name="user_name" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_NAME'); ?>">
												</div>
												<div class="col-md-6">
													<input type="email" class="form-control" name="user_email" required="required" placeholder="<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_USER_EMAIL'); ?>">
												</div>
											<?php } ?>
											<div class="col">
												<div class="reserve-box">
													<input type="hidden" name="accomodation_id" value="<?php echo $this->item->id; ?>">
													<input type="hidden" name="review_for" value="accomodation">
												</div>

												<div class="form-group submit-button-wrap">
													<button type="submit" class="spbooking-btn spbooking-btn-primary is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATION_SUBMIT_FEEDBACK'); ?></button>
												</div>
											</div>
										</div>
									</div>
								</div>
						</form>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
</div>